/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsOrderNumberComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsOrderNumberComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AssociatedOrderDetailsPanel
extends StateDependantTableDetailsPanel<TradeGoodsLight> {
    private static final long serialVersionUID = 1L;

    public AssociatedOrderDetailsPanel(RowEditor<TradeGoodsLight> editor, RDProvider provider) {
        super(editor, provider, true, true, false, true);
        this.setTitleText(Words.ASSOCIATED_ORDER_NUMBERS);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    public boolean isDeletable() {
        return this.provider.isDeletable(TradeGoodsComplete_.associatedOrderNumbers);
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        TradeGoodsOrderNumberComplete o = new TradeGoodsOrderNumberComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        o.setNumber("");
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
        this.editor.validate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return TradeGoodsLight_.state;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean isValid = true;
            for (Table2RowPanel f : this.table.getRows()) {
                if (f.isRowValid()) continue;
                isValid = false;
            }
            if (!isValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ASSOCIATED_NUMBERS_ARE_SET));
            }
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(TradeGoodsComplete_.associatedOrderNumbers));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDTextField numberField;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.numberField = new RDTextField(AssociatedOrderDetailsPanel.this.provider);
            this.numberField.setNode(m.getNode().getChildNamed(TradeGoodsOrderNumberComplete_.number));
            this.setLayout(new InnerLayout());
            if (AssociatedOrderDetailsPanel.this.isDeletable()) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.add(this.numberField);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.numberField);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.numberField.requestFocusInWindowNow();
        }

        @Override
        public Object getObject4Column(int column) {
            if (column == 0) {
                return this.numberField.getText();
            }
            return 0;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.numberField.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public boolean isRowValid() {
            if (this.numberField.getText().isEmpty()) {
                this.numberField.setInvalid();
                return false;
            }
            return true;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.numberField.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.numberField = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.numberField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.numberField.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.numberField.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.numberField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

