/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.wag;

import ch.icit.pegasus.client.ClientIDToolkit;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.MailToolkit;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.LegTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.handlingcost.FlightHandlingCostConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightDeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.sob.SalesOnBoardStateE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.exception.ValidationException;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Desktop;
import java.io.File;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagModuleDataHandler
extends DefaultDataHandler<FlightReference, FlightComplete> {
    static Logger log = LoggerFactory.getLogger(WagModuleDataHandler.class);

    public WagModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataAfterClosing(final Node<?> node, final RemoteLoader listener, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight f = (FlightLight)node.getValue();
                f = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightLight(new FlightReference(f.getId())).getValue();
                Node flightNode = node;
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                flightNode.removeExistingValues();
                flightNode.setValue((Object)f, 0L);
                flightNode.updateNode();
                return flightNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    private void ensurePax(FlightComplete flight) {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        for (FlightLegComplete l : flight.getLegs()) {
            if (!l.getDepartureAirport().equals((Object)s.getNightStop()) && !l.getArrivalAirport().equals((Object)s.getNightStop()) && !l.getDepartureAirport().equals((Object)s.getDayStop()) && !l.getArrivalAirport().equals((Object)s.getDayStop())) continue;
            for (PaxFigureComplete pf : l.getPaxFigures()) {
                pf.setNumber(Integer.valueOf(0));
            }
        }
        for (FlightHandlingCostConfigurationComplete c : flight.getFlightHandlingCostConfiguration()) {
            if (flight.getId() != null) {
                c.setFlight(new FlightReference(flight.getId()));
                continue;
            }
            c.setFlight((FlightReference)flight);
        }
    }

    @Override
    public void updateData(final Node<FlightReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node writeNode = node;
                Node retNode = null;
                ArrayList<Object> legs = new ArrayList<Object>();
                Iterator it = writeNode.getChildNamed(FlightLight_.legs).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    FlightLegComplete l = (FlightLegComplete)leg.getValue();
                    for (PaxFigureComplete f : l.getPaxFigures()) {
                        f.setLeg(l);
                    }
                    legs.add(leg.getValue());
                }
                ((FlightComplete)writeNode.getValue(FlightComplete.class)).setLegs(legs);
                Node id = writeNode.getChildNamed(FlightLight.ID_);
                FlightComplete newDTO = null;
                boolean isNewlyCreated = false;
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                RestaurantDeliverySettingsComplete restaurantSettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
                Node seals = NodeToolkit.getAffixNamed((String)"SealedEQs");
                FlightSealsComplete fsc = seals != null ? (FlightSealsComplete)seals.getValue() : null;
                boolean wasChange = false;
                ArrayList errorCallback = new ArrayList();
                if (id.getValue() != null) {
                    FlightComplete dto = (FlightComplete)node.getValue(FlightComplete.class);
                    if (!settings.getAutoCheckout().booleanValue()) {
                        dto.setAutoCheckout(Boolean.valueOf(false));
                    }
                    WagModuleDataHandler.this.ensureAdditionalOrders(dto);
                    WagModuleDataHandler.this.ensurePax(dto);
                    FlightComplete fc = dto;
                    if (!Boolean.TRUE.equals(fc.getAdHoc()) || fc.getFlightState() == FlightStateE.PLANNED) {
                        // empty if block
                    }
                    FlightToolkit.syncInOutCodeAndLegCode((FlightComplete)dto);
                    FlightToolkit.syncStdStaAndLegTime((FlightComplete)dto);
                    FlightToolkit.syncAdditionalSpaces((FlightComplete)dto);
                    Boolean canCreateFlight = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreateFlight(dto.getOutboundCode(), new TimestampWrapper(dto.getStd()), dto.getInboundCode(), new TimestampWrapper(dto.getSta()), new FlightReference(dto.getId()));
                    if (!Boolean.TRUE.equals(canCreateFlight)) {
                        DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                        throw new ClientGetFromServerException("A Flight with Outbound (" + dto.getOutboundCode() + ") at " + c.convert((Object)dto.getStd(), null, new Object[0]) + " and Inbound (" + dto.getInboundCode() + ") at " + c.convert((Object)dto.getSta(), null, new Object[0]) + " already exists.");
                    }
                    if (Boolean.TRUE.equals(((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getHasFlightInvoice(new FlightReference(dto.getId())))) {
                        InvoiceLight invoiceLight = (InvoiceLight)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoiceForFlight(new FlightReference(dto.getId())).getValue();
                    }
                    FlightComplete oldFlight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(dto.getId())).getValue();
                    ServiceReturnWithMessage serviceReturn = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(dto, new ListWrapper(errorCallback), false, false, false, false);
                    dto = (FlightComplete)serviceReturn.getObject();
                    if (Boolean.TRUE.equals(fc.getAdHoc()) && dto == null) {
                        newDTO = fc;
                        newDTO.setFlightState(FlightStateE.DELETED);
                    }
                    if (dto != null) {
                        FlightToolkit.syncAdditionalSpaces((FlightComplete)dto);
                    }
                    if (errorCallback.isEmpty()) {
                        newDTO = dto == null ? fc : dto;
                    } else {
                        retNode = new Node();
                        retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                    }
                }
                if (newDTO != null && newDTO.getFlightState() != FlightStateE.PLANNED && newDTO.getFlightState() != FlightStateE.DELETED && !isNewlyCreated && !newDTO.getHasStowingListChanged().booleanValue()) {
                    try {
                        switch (newDTO.getFlightState()) {
                            case PLANNED: 
                            case CANCELLED: 
                            case CLOSED: {
                                break;
                            }
                            case DISPATCHED: 
                            case EN_ROUTE: 
                            case OPEN: {
                                if (wasChange) {
                                    GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
                                    g.setFlight(new FlightReference(newDTO.getId()));
                                    FlightSealsComplete nfsc = (FlightSealsComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue();
                                    StowingToolkit.mergeSeals((FlightSealsComplete)nfsc, (FlightSealsComplete)fsc);
                                    fsc = nfsc;
                                }
                                if (fsc == null) break;
                                StowingToolkit.ensureSealState(newDTO, (FlightSealsComplete)fsc);
                                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateSeals(fsc);
                                break;
                            }
                        }
                    }
                    catch (ClientServerCallException e1) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)e1), WagModuleDataHandler.this.model.getTable());
                    }
                }
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                if (retNode != null) {
                    return retNode;
                }
                node.removeExistingValues();
                if (newDTO != null) {
                    node.setValue(newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureAdditionalOrders(FlightComplete flight) {
        if (flight.getAdditionalOrders() != null) {
            FlightLegComplete leg = flight.getLegs().isEmpty() ? null : (FlightLegComplete)flight.getLegs().get(0);
            for (AdditionalOrderComplete a : flight.getAdditionalOrders()) {
                if (flight.getLegs().contains(a.getLeg())) continue;
                a.setLeg((ILegComplete)leg);
            }
        }
    }

    @Override
    public void createNewData(final Node<FlightComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightComplete fc = (FlightComplete)node.getValue(FlightComplete.class);
                RestaurantDeliverySettingsComplete restaurantDeliverySettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
                StowingListTemplateComplete templateForCustomer = restaurantDeliverySettings.getDefaultStowingList();
                StowingListTemplateVariantLight currentStowingList = (StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).resolveVariant(new StowingListTemplateReference(templateForCustomer.getId()), new TimestampWrapper(fc.getStd())).getValue();
                if (templateForCustomer == null) {
                    throw new ValidationException("Stowing List Template in Master Data Settings Restaurant must be set");
                }
                fc.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                fc.setAdHoc(Boolean.valueOf(true));
                fc.setStd(DateUtil.getSQLDate((Date)new java.sql.Date(fc.getStd().getTime()), (Time)new Time(restaurantDeliverySettings.getDefaultOrderTime().getTime())));
                fc.setSta(new Timestamp(fc.getStd().getTime()));
                fc.setRealsta(new Timestamp(fc.getStd().getTime()));
                fc.setRealsta(new Timestamp(fc.getStd().getTime()));
                fc.setOutboundCode(fc.getRestaurant().getName());
                fc.setInboundCode(fc.getRestaurant().getName());
                fc.setLabelLayout(fc.getCustomer().getDefaultLabel());
                ArrayList warnings = new ArrayList();
                FlightLegComplete leg = new FlightLegComplete();
                leg.setNumber(Integer.valueOf(0));
                leg.setLegType(LegTypeE.OUTBOUND);
                leg.setDepartureAirport(fc.getRestaurant().getDeliveryAirport());
                leg.setArrivalAirport(fc.getRestaurant().getDeliveryAirport());
                leg.setCateringLeg(Boolean.valueOf(true));
                fc.getLegs().add(leg);
                AircraftLight aircraft = currentStowingList.getAircraft();
                StowingListTemplateComplete stowingList = templateForCustomer;
                HashMap legMapping = new HashMap();
                legMapping.put(templateForCustomer.getLegs().get(0), leg);
                Node aircraftMapping = node.getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING);
                if (aircraftMapping != null) {
                    aircraftMapping.commitThis();
                }
                ArrayList errorCallback = new ArrayList();
                for (FlightLegComplete fLeg : fc.getLegs()) {
                    for (Object sc : currentStowingList.getSeatConfigurations()) {
                        boolean found = false;
                        for (PaxFigureComplete figure : fLeg.getPaxFigures()) {
                            if (!sc.getCabinClass().equals((Object)figure.getCabinClass())) continue;
                            found = true;
                        }
                        if (found) continue;
                        PaxFigureComplete p = new PaxFigureComplete();
                        p.setClientOId(Long.valueOf(ADTO.getNextId()));
                        p.setCabinClass(sc.getCabinClass());
                        p.setLeg(fLeg);
                        p.setNumber(Integer.valueOf(0));
                        fLeg.getPaxFigures().add(p);
                    }
                }
                fc.setInboundCode(fc.getOutboundCode());
                for (AdditionalOrderComplete additionalOrderComplete : fc.getAdditionalOrders()) {
                    additionalOrderComplete.setLeg((ILegComplete)leg);
                }
                int orders = 0;
                while (!Boolean.TRUE.equals(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreate(fc.getOutboundCode(), new TimestampWrapper(fc.getStd()), fc.getInboundCode(), new TimestampWrapper(fc.getSta())))) {
                    fc.setOutboundCode(fc.getRestaurant().getName() + " " + ++orders);
                    fc.setInboundCode(fc.getRestaurant().getName() + " " + orders);
                }
                FlightComplete nfc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).createWithAircraft(fc, (StowingListTemplateReference)stowingList, (AircraftReference)aircraft, aircraftMapping != null ? new MapWrapper((Map)aircraftMapping.getValue()) : new MapWrapper(), new MapWrapper(legMapping), new ListWrapper(warnings)).getValue();
                if (!errorCallback.isEmpty()) {
                    // empty if block
                }
                ListWrapper additionalOrderSpaces = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces(new FlightReference(nfc.getId()));
                for (AdditionalOrderComplete order : nfc.getAdditionalOrders()) {
                    if (additionalOrderSpaces.getList().isEmpty()) continue;
                    order.setStowingPosition((DeliverySpaceComplete)additionalOrderSpaces.getList().get(0));
                }
                nfc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(nfc, new ListWrapper(), false, false, false, false).getObject();
                nfc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(nfc.getId())).getValue();
                if (Boolean.TRUE.equals(restaurantDeliverySettings.getSendMailAfterCreation())) {
                    UserComplete user = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getLoggedInUser().getValue();
                    ArrayList<String> targets = new ArrayList<String>();
                    for (EMailReceiptComplete mailReceipt : restaurantDeliverySettings.getMailReceipts()) {
                        targets.add(mailReceipt.getMailAddress());
                    }
                    FlightDeliverySlipReportConfiguration config = new FlightDeliverySlipReportConfiguration();
                    config.setDto((IDTO)new FlightReference(nfc.getId()));
                    config.setFormat(ReportingOutputFormatE.PDF);
                    config.setPrintBody(Boolean.valueOf(true));
                    config.setPrintTitlepage(Boolean.valueOf(false));
                    config.setCashDeliverySlip(Boolean.valueOf(true));
                    config.setIncludeTemperature(Boolean.valueOf(true));
                    config.setIncludeDrawers(Boolean.valueOf(true));
                    SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.DELIVERYSLIP);
                    for (ReportFileComplete result : r.getResults()) {
                        if (!result.getDescription().contains("Weisse Arena")) continue;
                        config.setStylesheet(result);
                    }
                    PegasusFileComplete flightDeliverySlipReport = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDeliverySlipReport((DeliverySlipReportConfiguration)config, new ListWrapper(new ArrayList())).getValue();
                    File deliverySlip = FileTransferUtil.download((PegasusFileComplete)flightDeliverySlipReport, (FileTransferListener[])new FileTransferListener[0]);
                    Desktop.getDesktop().open(deliverySlip);
                    String userName = user.getUserName();
                    if (!StringUtil.isBlank((String)user.getContact().getFirstName())) {
                        userName = user.getContact().getFirstName();
                    }
                    if (!StringUtil.isBlank((String)user.getContact().getLastName())) {
                        userName = " " + user.getContact().getLastName();
                    }
                    MailToolkit.sendWAGOrderMail((String)"Weisse Arena Gastro Order created", (String)("New Order created (" + userName + ")"), (File)deliverySlip, targets);
                }
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                node.removeExistingValues();
                node.setValue((Object)nfc, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                WagModuleDataHandler.this.setCurrentLoadMaximum(26);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightStateE();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllTruckTourTypes();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealChecks();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealTypes();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllLegTypes();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightTypes();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxFigureTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AlaCarteMenuTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LanguageCodeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllDateDurations();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettingsCached();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductTypeComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                WagModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PreparationGroupComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return WagModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<FlightComplete> resetData(Node<FlightComplete> node) {
        return null;
    }

    @Override
    public Node<FlightComplete> createEmptyNode() {
        FlightComplete f = new FlightComplete();
        f.setClientOId(Long.valueOf(ADTO.getNextId()));
        f.setFlightState(FlightStateE.OPEN);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (settings.getDefaultFlightScheduleType() != null) {
            f.setFlightType(settings.getDefaultFlightScheduleType());
        } else {
            f.setFlightType(FlightTypeE.RETURN);
        }
        RestaurantDeliverySettingsComplete deliverySettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
        if (deliverySettings != null && deliverySettings.getDefaultStowingList() != null) {
            f.setCustomer(deliverySettings.getDefaultStowingList().getCustomer());
        }
        f.setSta((Timestamp)DateUtil.addDays((Date)new Timestamp(System.currentTimeMillis()), (int)1));
        f.setStd((Timestamp)DateUtil.addDays((Date)new Timestamp(System.currentTimeMillis()), (int)1));
        f.setSobBarSetNumber("");
        f.setSobLoadFlightToHandheld(Boolean.valueOf(false));
        f.setSobState(SalesOnBoardStateE.NONE);
        f.setFlightOrderReceived(Boolean.valueOf(false));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, false);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightComplete nflight;
                Long id = (Long)node.getValueForNamed("id");
                boolean isOpen = false;
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (id != null) {
                    isOpen = true;
                    nflight = WagModuleDataHandler.this.loadCompleteFlight((FlightReference)node.getValue());
                } else {
                    FlightLight oflight = (FlightLight)node.getValue(FlightLight.class);
                    oflight.setFlightState(FlightStateE.PLANNED);
                    nflight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(oflight).getValue();
                    ClientIDToolkit.initClientIds((ADTO)nflight, new ArrayList());
                }
                List service = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getMappedServices(nflight).getList();
                Node serviceNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)service, true, false);
                serviceNode.setName("usedLegServices");
                NodeToolkit.removeAffixNamed((String)"usedLegServices");
                NodeToolkit.addAffix((Node)serviceNode);
                FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)nflight);
                Node dtoNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)nflight, false, false);
                dtoNode.removeExistingValues();
                dtoNode.setValue((Object)nflight, 0L);
                dtoNode.updateNode();
                node.removeExistingValues();
                node.setValue((Object)nflight, 0L);
                node.updateNode();
                this.updateMasterData((Node<FlightLight>)node, dtoNode, id, nflight, isOpen);
                return dtoNode;
            }

            public void updateMasterData(Node<FlightLight> node2, Node dtoNode, Long id, FlightComplete nflight, boolean isOpen) throws ClientServerCallException {
                Map spmlsWrapped = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getChoosableSpecialMenuTypes((FlightLight)node2.getValue()).getMap();
                HashMap spmls = new HashMap();
                for (Map.Entry entry : spmlsWrapped.entrySet()) {
                    spmls.put(entry.getKey(), ((ListWrapper)entry.getValue()).getList());
                }
                Map alaCarteWrapped = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getChoosableALaCarteMenuTypes((FlightLight)node2.getValue()).getMap();
                HashMap alaCarte = new HashMap();
                for (Map.Entry entry : alaCarteWrapped.entrySet()) {
                    alaCarte.put(entry.getKey(), ((ListWrapper)entry.getValue()).getList());
                }
                ArrayList ccs = new ArrayList();
                ccs.addAll(spmls.keySet());
                Node cClasses = NodeToolkit.getAffixNamed((String)"spmlCabinClasses");
                if (cClasses == null) {
                    cClasses = INodeCreator.getDefaultImpl().createNodes(ccs, false);
                    cClasses.setName("spmlCabinClasses");
                    NodeToolkit.addAffix((Node)cClasses);
                } else {
                    cClasses.removeExistingValues();
                    cClasses.setValue(ccs, 0L);
                    cClasses.updateNode();
                }
                Node types = NodeToolkit.getAffixNamed((String)"spmlMenuTypes");
                if (types == null) {
                    types = new ViewNode("spmlMenuTypes");
                    types.setValue(spmls, 0L);
                    NodeToolkit.addAffix((Node)types);
                } else {
                    types.removeExistingValues();
                    types.setValue(spmls, 0L);
                    types.updateNode();
                }
                types = NodeToolkit.getAffixNamed((String)"alaCarteMenuTypes");
                if (types == null) {
                    types = new ViewNode("alaCarteMenuTypes");
                    types.setValue(alaCarte, 0L);
                    NodeToolkit.addAffix((Node)types);
                } else {
                    types.removeExistingValues();
                    types.setValue(alaCarte, 0L);
                    types.updateNode();
                }
                ccs = new ArrayList();
                ccs.addAll(alaCarte.keySet());
                cClasses = NodeToolkit.getAffixNamed((String)"alaCarteCabinClasses");
                if (cClasses == null) {
                    cClasses = INodeCreator.getDefaultImpl().createNodes(ccs, false);
                    cClasses.setName("alaCarteCabinClasses");
                    NodeToolkit.addAffix((Node)cClasses);
                } else {
                    cClasses.removeExistingValues();
                    cClasses.setValue(ccs, 0L);
                    cClasses.updateNode();
                }
                WagModuleDataHandler.loadSealConfiguration(nflight);
                WagModuleDataHandler.revalidateMasterData(nflight, isOpen, dtoNode);
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public static void loadSealConfiguration(FlightComplete nflight) throws ClientServerCallException {
        FlightSealsComplete eqs;
        NodeToolkit.removeAffixNamed((String)"SealedEQs");
        if (nflight == null || nflight.getId() == null) {
            return;
        }
        GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
        g.setFlight(new FlightReference(nflight.getId()));
        FlightSealsComplete seals = eqs = (FlightSealsComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue();
        seals.setClientOId(Long.valueOf(ADTO.getNextId()));
        for (EquipmentSealsComplete e : seals.getEquipments()) {
            e.setClientOId(Long.valueOf(ADTO.getNextId()));
        }
        Node sealedEqs = INodeCreator.getDefaultImpl().getNode4DTO((Object)eqs, false, false);
        sealedEqs.setName("SealedEQs");
        NodeToolkit.addAffix((Node)sealedEqs);
    }

    public static <T extends FlightReference> void revalidateMasterData(FlightComplete nflight, boolean isOpen, Node<T> node) throws ClientServerCallException {
        Node r = NodeToolkit.getAffixNamed((String)"plegs");
        if (r != null) {
            Iterator it = r.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                INodeCreator.getDefaultImpl().removeFromAllNodes(n);
            }
        }
        NodeToolkit.removeAffixNamed((String)"plegs");
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
        if (nflight != null && nflight.getActiveStowingList() != null) {
            Node addPos;
            List additionalOrderSpaces;
            Node adSPMLPos = isOpen ? INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces((FlightReference)nflight).getList(), false) : INodeCreator.getDefaultImpl().createNodes(((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalSPMLOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList(), false);
            if (adSPMLPos != null) {
                adSPMLPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
                NodeToolkit.addAffix((Node)adSPMLPos);
            }
            if (isOpen) {
                additionalOrderSpaces = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces((FlightReference)nflight).getList();
                addPos = INodeCreator.getDefaultImpl().createNodes(additionalOrderSpaces, false);
            } else {
                additionalOrderSpaces = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList();
                addPos = INodeCreator.getDefaultImpl().createNodes(additionalOrderSpaces, false);
            }
            if (addPos != null) {
                NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                addPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                NodeToolkit.addAffix((Node)addPos);
            }
        }
        if (node != null) {
            Node legs;
            Node stw = node.getChildNamed(DtoFieldConstants.OLD_STW);
            if (stw == null) {
                stw = new DTONode();
                stw.setName(DtoFieldConstants.OLD_STW);
                node.addChild(stw, 0L);
            }
            if (nflight != null) {
                stw.setValue((Object)nflight.getActiveStowingList(), 0L);
            }
            if ((legs = node.getChildNamed(FlightComplete_.legs)) != null) {
                ViewNode n = new ViewNode("plegs");
                Iterator it = legs.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    n.addChild(leg, 0L);
                }
                n.setName("plegs");
                n.setValue(legs.getValue(), 0L);
                NodeToolkit.addAffix((Node)n);
            }
        }
    }

    public FlightComplete loadCompleteFlight(FlightReference l) throws ClientServerCallException {
        FlightComplete nflight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(l.getId())).getValue();
        return nflight;
    }

    @Override
    public Class<FlightComplete> getCommittingClass() {
        return FlightComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<FlightReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

