/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.wag.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class OrderDataDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> restaurant;
    private TitledItem<DateChooser> deliveryDate;

    public OrderDataDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ORDER);
        this.restaurant = new TitledItem<SearchTextField2<RestaurantComplete>>(SearchTextField2Factory.getRestaurantSearch(true, null), WordsToolkit.toCapitalLetter((String)Words.RESTAURANT), TitledItem.TitledItemOrientation.NORTH);
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(null), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryDate.getElement().setIsTimestamp(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.restaurant);
        this.addToView(this.deliveryDate);
    }

    @Override
    public void setNode(Node<?> node) {
        Node stdN;
        Timestamp std;
        Node fsNode;
        super.setNode(node);
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        if (this.editor.getModel().isAddRow()) {
            FlightComplete dto = (FlightComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if ((fsNode = node.getChildNamed(DtoFieldConstants.NEW_FS)) == null) {
            fsNode = new DTOProxyNode();
            fsNode.setName(DtoFieldConstants.NEW_FS);
            node.addChild(fsNode, 0L);
        }
        if ((std = (Timestamp)(stdN = node.getChildNamed(FlightLight_.std)).getValue()) == null) {
            stdN.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
            std = (Timestamp)stdN.getValue();
        }
        if (currentUser.getAssociatedCustomer() != null) {
            node.getChildNamed(FlightLight_.customer).setValue((Object)currentUser.getAssociatedCustomer(), 0L);
        }
        if (currentUser.getAccessibleRestaurants().size() == 1) {
            node.getChildNamed(FlightLight_.restaurant).setValue(currentUser.getAccessibleRestaurants().get(0), 0L);
        }
        this.restaurant.getElement().setNode(node.getChildNamed(FlightLight_.restaurant));
        this.deliveryDate.getElement().setNode(stdN);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.restaurant.setEnabled(isEnabled && this.editor.getModel().isAddRow());
        this.deliveryDate.setEnabled(isEnabled && this.editor.getModel().isAddRow());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode() != null) {
            Node currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.outboundCode);
            if (currentNode != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
            if ((currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.std)) != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
        }
        this.restaurant.kill();
        this.deliveryDate.kill();
        this.restaurant = null;
        this.deliveryDate = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.restaurant);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.restaurant.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.restaurant).getValue() == null) {
            this.restaurant.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_RESTAURANT));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STD));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return super.commitParagraph();
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = OrderDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + OrderDataDetailsPanel.this.restaurant.getPreferredSize().getHeight());
            h += OrderDataDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + OrderDataDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            return new Dimension(300, h += OrderDataDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ww = (parent.getWidth() - (2 * OrderDataDetailsPanel.this.horizontalBorder + OrderDataDetailsPanel.this.inner_horizontalBorder)) / 2;
            OrderDataDetailsPanel.this.restaurant.setLocation(OrderDataDetailsPanel.this.horizontalBorder, OrderDataDetailsPanel.this.verticalBorder);
            OrderDataDetailsPanel.this.restaurant.setSize(parent.getWidth() - 2 * OrderDataDetailsPanel.this.horizontalBorder, (int)OrderDataDetailsPanel.this.restaurant.getPreferredSize().getHeight());
            OrderDataDetailsPanel.this.deliveryDate.setLocation(OrderDataDetailsPanel.this.horizontalBorder, OrderDataDetailsPanel.this.restaurant.getY() + OrderDataDetailsPanel.this.restaurant.getHeight() + OrderDataDetailsPanel.this.verticalBorder);
            OrderDataDetailsPanel.this.deliveryDate.setSize(OrderDataDetailsPanel.this.deliveryDate.getPreferredSize());
        }
    }
}

