/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.weeklyplan.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight_;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<WeeklyPlanLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> description;
    private TitledPeriodEditor period;
    private TitledItem<RDComboBox> department;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<SearchTextField2<RestaurantComplete>> restaurant;

    public ConfigurationDetailsPanel(RowEditor<WeeklyPlanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Specification");
        this.period = new TitledPeriodEditor(null, null, true, provider);
        this.period.getStartDateChooser().setOverrideName(WeeklyPlanLight_.period);
        this.period.getEndDateChooser().setOverrideName(WeeklyPlanLight_.period);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class)), "Department", TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, editor.getModel().getNode().getChildNamed(WeeklyPlanComplete_.customer)), "Customer", TitledItem.TitledItemOrientation.NORTH);
        this.restaurant = new TitledItem<SearchTextField2<RestaurantComplete>>(SearchTextField2Factory.getRestaurantSearch(true, (Node<RestaurantComplete>)editor.getModel().getNode().getChildNamed(WeeklyPlanComplete_.restaurant)), "Restaurant", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.description);
        this.addToView(this.period);
        this.addToView(this.department);
        this.addToView(this.customer);
        this.addToView(this.restaurant);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            WeeklyPlanComplete dto = (WeeklyPlanComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(WeeklyPlanComplete_.name));
        this.description.getElement().setNode(node.getChildNamed(WeeklyPlanComplete_.description));
        this.period.setNode((Node<PeriodComplete>)node.getChildNamed(WeeklyPlanComplete_.period));
        this.department.getElement().setNode(node.getChildNamed(WeeklyPlanComplete_.department));
        this.customer.getElement().setNode(node.getChildNamed(WeeklyPlanComplete_.customer));
        this.restaurant.getElement().setNode(node.getChildNamed(WeeklyPlanComplete_.restaurant));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.restaurant.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Date currentDate = new Date(((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.startDate}).getValue()).getTime());
        int days = 6;
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)days);
        currentDate = new PeriodComplete(new Date(currentDate.getTime()), new Date(currentDate.getTime())).getEndDate();
        Date endDate = new Date(((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.endDate}).getValue()).getTime());
        if (!currentDate.equals(endDate = new PeriodComplete(new Date(endDate.getTime()), new Date(endDate.getTime())).getEndDate())) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Weekly Plan range must exactly match 7 days"));
        }
        if (StringUtil.isBlank((String)((String)this.editor.getModel().getNode().getChildNamed(WeeklyPlanComplete_.name).getValue()))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name must be set"));
        }
        return validationObjects;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.name = null;
        this.description.kill();
        this.description = null;
        this.period.kill();
        this.period = null;
        this.customer.kill();
        this.customer = null;
        this.department.kill();
        this.department = null;
        this.restaurant.kill();
        this.restaurant = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.restaurant);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.period.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.department.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.restaurant.getPreferredSize().getHeight());
            return new Dimension(300, h += ConfigurationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ww = (parent.getWidth() - (2 * ConfigurationDetailsPanel.this.horizontalBorder + ConfigurationDetailsPanel.this.inner_horizontalBorder)) / 2;
            ConfigurationDetailsPanel.this.name.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.name.setSize(200, (int)ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.description.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.name.getY() + ConfigurationDetailsPanel.this.name.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.description.setSize(200, (int)ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.period.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.description.getY() + ConfigurationDetailsPanel.this.description.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.period.setSize(ConfigurationDetailsPanel.this.period.getPreferredSize());
            ConfigurationDetailsPanel.this.department.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.period.getY() + ConfigurationDetailsPanel.this.period.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.department.setSize(200, (int)ConfigurationDetailsPanel.this.department.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.customer.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.department.getY() + ConfigurationDetailsPanel.this.department.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.customer.setSize(200, (int)ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.restaurant.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.customer.getY() + ConfigurationDetailsPanel.this.customer.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.restaurant.setSize(200, (int)ConfigurationDetailsPanel.this.restaurant.getPreferredSize().getHeight());
        }
    }
}

