/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.forecast;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.panels.DateDurationPanelInt;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class UpdateForeCastPaxComponent
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> node;
    private List<FlightLegComplete> selectedLegs;
    private FlightLight selectedFlight;
    private TitledItem<CheckBox> includeCrewPax;
    private TitledItem<CheckBox> includeSPMLPaxUpdate;
    private List<TitledItem<CheckBox>> typesList = new ArrayList<TitledItem<CheckBox>>();
    private TitledItem<DateDurationPanelInt> durationField;
    private int paxForeCastReady = 0;

    public UpdateForeCastPaxComponent(Node<FlightLight> node) {
        this.node = node;
        this.setLayout(new Layout());
        this.durationField = new TitledItem<DateDurationPanelInt>(new DateDurationPanelInt(), Words.SEARCH_FLIGHT_WITHIN, TitledItem.TitledItemOrientation.NORTH);
        this.includeCrewPax = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrewPax.setEnabled(true);
        this.includeCrewPax.fadeIn();
        this.includeSPMLPaxUpdate = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML_FORECAST, TitledItem.TitledItemOrientation.EAST);
        this.add(this.includeCrewPax);
        this.add(this.includeSPMLPaxUpdate);
        this.add(this.durationField);
    }

    public Node<?> updateForecastPax(FlightLight oldFlight, long time) {
        long std = oldFlight.getStd().getTime();
        FlightSearchConfiguration fsc = new FlightSearchConfiguration();
        fsc.setCustomer(oldFlight.getCustomer());
        fsc.setFlightNumber(oldFlight.getOutboundCode());
        fsc.setDayPeriod(new PeriodComplete(new Date((std -= time) - 1L), new Date(std + 1L)));
        try {
            String text;
            SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)fsc);
            FlightLight newFlight = sri.hasNext() ? (FlightLight)sri.next() : null;
            if (newFlight == null) {
                text = Words.NO_FLIGHT_FOR_PAX_UPDATE_FOUND;
                this.paxForeCastReady = 2;
            } else {
                DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                this.selectedLegs = newFlight.getLegs();
                this.selectedFlight = newFlight;
                text = Phrase.getPhrase((String)Phrase.FOUND_LEGS_FOR, (Object[])new Object[]{newFlight.getOutboundCode(), c.convert((Object)newFlight.getStd(), null, new Object[0])});
                int count = 1;
                for (FlightLegComplete leg : this.selectedLegs) {
                    text = text + Phrase.getPhrase((String)Phrase.LEG_COUNT, (Object[])new Object[]{count});
                    Collections.sort(leg.getPaxFigures());
                    for (PaxFigureComplete f : leg.getPaxFigures()) {
                        text = text + Phrase.getPhrase((String)Phrase.CABIN_CLASS_ITEM, (Object[])new Object[]{f.getCabinClass().getCode(), f.getPaxFigureType() != null ? f.getPaxFigureType().getCode() : "Final Pax", f.getNumber()});
                    }
                    text = text + "</ul>";
                    ++count;
                }
                text = text + Words.PRESS_OK_TO_SAVE_PAX_COUNT;
                this.paxForeCastReady = 1;
            }
            Node n = new Node();
            n.setValue((Object)text, 0L);
            return n;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            this.hideAnimation();
            this.showMessage(Words.UNABLE_TO_LOAD_FORECAST);
            this.paxForeCastReady = 2;
            this.popup.hideCancelButton();
            this.popup.setOkButtonText(Words.CLOSE);
            return null;
        }
    }

    public void loadForeCast(final long time) {
        ThreadSafeLoader.run(new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight oldFlight = (FlightLight)UpdateForeCastPaxComponent.this.node.getValue();
                return UpdateForeCastPaxComponent.this.updateForecastPax(oldFlight, time);
            }

            private void insertUI(String text) {
                UpdateForeCastPaxComponent.this.hideAnimation();
                UpdateForeCastPaxComponent.this.showMessage(text);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node != null) {
                            String text = (String)node.getValue();
                            this.insertUI(text);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        });
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.paxForeCastReady == 0) {
            long time = this.durationField.getElement().getWindow();
            this.durationField.fadeOut(true);
            this.durationField = null;
            this.hideMessage();
            if (this.includeCrewPax != null) {
                this.includeCrewPax.setVisible(false);
            }
            if (this.includeSPMLPaxUpdate != null) {
                this.includeSPMLPaxUpdate.setVisible(false);
            }
            for (TitledItem<CheckBox> i : this.typesList) {
                i.setVisible(false);
            }
            this.showAnimation(Words.LOAD_FORE_CAST);
            this.loadForeCast(time);
        } else if (this.paxForeCastReady == 1) {
            this.showAnimation(Words.UPDATE_FLIGHT);
            ThreadSafeLoader.run(this.getJob());
            this.popup.enableCancelButton(false);
            this.popup.enableOKButton(false);
        } else if (this.paxForeCastReady == 2) {
            this.popup.hidePopUp(new Object[0]);
        } else {
            super.enterPressed(isOK);
        }
    }

    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UpdateForeCastPaxComponent.this.hideMessage();
                FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight((FlightReference)UpdateForeCastPaxComponent.this.node.getValue()).getValue();
                boolean includeCC = ((CheckBox)UpdateForeCastPaxComponent.this.includeCrewPax.getElement()).isChecked();
                boolean includeSPMLForecast = false;
                if (UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate != null) {
                    includeSPMLForecast = ((CheckBox)UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.getElement()).isChecked();
                }
                HashSet<PaxFigureTypeComplete> usedTypes = new HashSet<PaxFigureTypeComplete>();
                boolean useFinalPax = false;
                boolean hasFinalPax = false;
                for (TitledItem i : UpdateForeCastPaxComponent.this.typesList) {
                    if (i.getUserObject() == null) {
                        hasFinalPax = true;
                        useFinalPax = ((CheckBox)i.getElement()).isChecked();
                        continue;
                    }
                    if (!((CheckBox)i.getElement()).isChecked()) continue;
                    usedTypes.add((PaxFigureTypeComplete)i.getUserObject());
                }
                if (!hasFinalPax) {
                    useFinalPax = true;
                }
                for (FlightLegComplete leg : fc.getLegs()) {
                    for (FlightLegComplete oldLeg : UpdateForeCastPaxComponent.this.selectedLegs) {
                        if (!oldLeg.getNumber().equals(leg.getNumber())) continue;
                        for (PaxFigureComplete pf : leg.getPaxFigures()) {
                            if ((pf.getPaxFigureType() != null || !useFinalPax) && !usedTypes.contains(pf.getPaxFigureType()) || !includeCC && Boolean.TRUE.equals(pf.getCabinClass().getCrewClass())) continue;
                            for (PaxFigureComplete opf : oldLeg.getPaxFigures()) {
                                if (!opf.getCabinClass().equals((Object)pf.getCabinClass())) continue;
                                pf.setNumber(opf.getNumber());
                            }
                        }
                    }
                }
                if (includeSPMLForecast) {
                    FlightComplete ofComplete = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(UpdateForeCastPaxComponent.this.selectedFlight.getId())).getValue();
                    for (SpecialMealOrderComplete o : ofComplete.getSpmlOrders()) {
                        if (this.hasOrder(o, fc.getSpmlOrders())) continue;
                        SpecialMealOrderComplete no = new SpecialMealOrderComplete();
                        no.setClientOId(Long.valueOf(ADTO.getNextId()));
                        no.setCabinClass(o.getCabinClass());
                        no.setCount(o.getCount());
                        no.setFlight((FlightReference)fc);
                        no.setMenuType(o.getMenuType());
                        no.setPaxName(o.getPaxName());
                        no.setPredefined(Boolean.valueOf(false));
                        no.setSeatNumber(o.getSeatNumber());
                        no.setStowingPosition(null);
                        for (FlightLegComplete l : o.getLegs()) {
                            FlightLegComplete nl = this.getLeg(l, fc.getLegs());
                            if (nl == null) continue;
                            no.getLegs().add(nl);
                        }
                        fc.getSpmlOrders().add(no);
                    }
                }
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(), false, false, false, false);
                return new ViewNode("");
            }

            private FlightLegComplete getLeg(FlightLegComplete origin, List<FlightLegComplete> legs) {
                for (FlightLegComplete l : legs) {
                    if (!l.getNumber().equals(origin.getNumber())) continue;
                    return l;
                }
                return null;
            }

            private boolean hasOrder(SpecialMealOrderComplete originOrder, List<SpecialMealOrderComplete> orders) {
                for (SpecialMealOrderComplete o : orders) {
                    if (!o.getCabinClass().equals((Object)originOrder.getCabinClass()) || !o.getCount().equals(originOrder.getCount()) || !o.getMenuType().equals((Object)originOrder.getMenuType())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        UpdateForeCastPaxComponent.this.popup.hideCancelButton();
                        UpdateForeCastPaxComponent.this.popup.setOkButtonText(Words.CLOSE);
                        UpdateForeCastPaxComponent.this.popup.hideScheduled(300, Words.SUCCESSFUL);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)UpdateForeCastPaxComponent.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            UpdateForeCastPaxComponent.this.layoutAnimation(parent);
            int currentY = UpdateForeCastPaxComponent.this.border;
            if (UpdateForeCastPaxComponent.this.durationField != null) {
                UpdateForeCastPaxComponent.this.durationField.setLocation(UpdateForeCastPaxComponent.this.border, currentY);
                UpdateForeCastPaxComponent.this.durationField.setSize(UpdateForeCastPaxComponent.this.durationField.getPreferredSize());
                currentY = UpdateForeCastPaxComponent.this.durationField.getY() + UpdateForeCastPaxComponent.this.durationField.getHeight() + UpdateForeCastPaxComponent.this.border;
            }
            if (UpdateForeCastPaxComponent.this.includeCrewPax != null) {
                UpdateForeCastPaxComponent.this.includeCrewPax.setLocation(UpdateForeCastPaxComponent.this.border, currentY);
                UpdateForeCastPaxComponent.this.includeCrewPax.setSize(UpdateForeCastPaxComponent.this.includeCrewPax.getPreferredSize());
                currentY = UpdateForeCastPaxComponent.this.includeCrewPax.getY() + UpdateForeCastPaxComponent.this.includeCrewPax.getHeight() + UpdateForeCastPaxComponent.this.border;
            }
            if (UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate != null) {
                UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.setLocation(UpdateForeCastPaxComponent.this.border, currentY);
                UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.setSize(UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.getPreferredSize());
                currentY = UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.getY() + UpdateForeCastPaxComponent.this.includeSPMLPaxUpdate.getHeight() + UpdateForeCastPaxComponent.this.border;
            }
            for (TitledItem i : UpdateForeCastPaxComponent.this.typesList) {
                i.setLocation(UpdateForeCastPaxComponent.this.border, currentY);
                i.setSize(i.getPreferredSize());
                currentY = i.getY() + i.getHeight() + UpdateForeCastPaxComponent.this.border;
            }
        }
    }
}

