/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.job.start;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionJobStartComponent
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<JobComplete> node;
    private RowModel<JobComplete> model;
    private TitledItem<ComboBox> startJob;
    private boolean jobDone = false;

    public ActionJobStartComponent(Node<JobComplete> node, RowModel<JobComplete> model) {
        this.node = node;
        this.model = model;
        this.setLayout(new Layout());
        this.startJob = new TitledItem<ComboBox>(ComboBoxFactory.getYesNoComboBox(false), "Start", TitledItem.TitledItemOrientation.NORTH);
        this.startJob.getElement().addItem("-");
        this.startJob.getElement().setSelectedItem("-");
        this.startJob.fadeIn();
        this.add(this.startJob);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.startJob != null) {
            this.startJob.kill();
        }
        this.startJob = null;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            if (this.jobDone) {
                this.popup.hidePopUp(new Object[0]);
            } else {
                this.startJob.setVisible(false);
                this.showAnimation(Words.SAVE_DATA);
                ThreadSafeLoader.run(this.getJob());
                this.popup.enableCancelButton(false);
                this.popup.enableOKButton(false);
            }
        } else {
            super.enterPressed(isOK);
        }
    }

    public ThreadSafeExecutable getJob() {
        this.jobDone = true;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).startJob(new JobReference(((JobComplete)ActionJobStartComponent.this.node.getValue()).getId()));
                JobComplete job = (JobComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getJob(new JobReference(((JobComplete)ActionJobStartComponent.this.node.getValue()).getId())).getValue();
                ActionJobStartComponent.this.node.removeExistingValues();
                ActionJobStartComponent.this.node.setValue((Object)job, 0L);
                ActionJobStartComponent.this.node.updateNode();
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionJobStartComponent.this.model.updateView();
                        ActionJobStartComponent.this.popup.hideCancelButton();
                        ActionJobStartComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionJobStartComponent.this.popup.hideScheduled(300, Words.SUCCESSFUL);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ActionJobStartComponent.this);
                        ActionJobStartComponent.this.hideAnimation();
                        ActionJobStartComponent.this.showMessage("Error occurred");
                        ActionJobStartComponent.this.popup.hideCancelButton();
                        ActionJobStartComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionJobStartComponent.this.popup.enableOKButton(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.startJob != null ? this.startJob.getElement().isInnerComponent(c) : false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ActionJobStartComponent.this.border;
            if (ActionJobStartComponent.this.startJob != null) {
                currentY = (int)((double)currentY + (ActionJobStartComponent.this.startJob.getPreferredSize().getHeight() + (double)ActionJobStartComponent.this.border));
            }
            return new Dimension(0, currentY);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionJobStartComponent.this.layoutAnimation(parent);
            int currentY = ActionJobStartComponent.this.border;
            if (ActionJobStartComponent.this.startJob != null) {
                ActionJobStartComponent.this.startJob.setLocation(ActionJobStartComponent.this.border, currentY);
                ActionJobStartComponent.this.startJob.setSize(parent.getWidth() - 2 * ActionJobStartComponent.this.border, (int)ActionJobStartComponent.this.startJob.getPreferredSize().getHeight());
            }
        }
    }
}

