/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.store.transition;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class PrintStockHistoryComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StockReportConfiguration> stockConfig;
    private TitledPeriodEditor period;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearch;

    public PrintStockHistoryComponent() {
        super(true, false, false, false, ReportTypeE.STOCK_EXPORT);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.period);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        StockReportConfiguration config = new StockReportConfiguration();
        config.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        this.stockConfig = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.createComponents();
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)this.stockConfig.getChildNamed(StockReportConfiguration_.period), null);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.stockConfig.getChildNamed(StockReportConfiguration_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.period);
        this.getViewContainer().add(this.customerSearch);
    }

    @Override
    public String getTitleString() {
        return Words.STORES;
    }

    @Override
    public String getTitleValue() {
        return Words.DELIVERY_LIST;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.period != null) {
            this.period.kill();
        }
        if (this.customerSearch != null) {
            this.customerSearch.kill();
        }
        this.period = null;
        this.customerSearch = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(true);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.period != null) {
            this.period.setVisible(false);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PrintStockHistoryComponent.this.stockConfig.commit();
                StockReportConfiguration config = (StockReportConfiguration)PrintStockHistoryComponent.this.stockConfig.getValue();
                config.setFormat(ReportingOutputFormatE.PDF);
                ListWrapper reps = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportStylesheets(ReportTypeE.FLIGHT_DELIVERY_LIST);
                if (!reps.getList().isEmpty()) {
                    config.setStylesheet((ReportFileComplete)reps.getList().get(0));
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createStoreTransitionReport(config).getValue();
                PrintStockHistoryComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStockHistoryComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintStockHistoryComponent.this.layoutInheritedComponents(parent);
            if (PrintStockHistoryComponent.this.customerSearch != null) {
                PrintStockHistoryComponent.this.customerSearch.setLocation(PrintStockHistoryComponent.this.border, y + PrintStockHistoryComponent.this.border);
                PrintStockHistoryComponent.this.customerSearch.setSize(parent.getWidth() - 2 * PrintStockHistoryComponent.this.border, (int)PrintStockHistoryComponent.this.customerSearch.getPreferredSize().getHeight());
                y = PrintStockHistoryComponent.this.customerSearch.getY() + PrintStockHistoryComponent.this.customerSearch.getHeight() + PrintStockHistoryComponent.this.border;
            }
            if (PrintStockHistoryComponent.this.period != null) {
                PrintStockHistoryComponent.this.period.setLocation(PrintStockHistoryComponent.this.border, y + PrintStockHistoryComponent.this.border);
                PrintStockHistoryComponent.this.period.setSize(parent.getWidth() - 2 * PrintStockHistoryComponent.this.border, (int)PrintStockHistoryComponent.this.period.getPreferredSize().getHeight());
                y = PrintStockHistoryComponent.this.period.getY() + PrintStockHistoryComponent.this.period.getHeight() + PrintStockHistoryComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStockHistoryComponent.this.getInheritedComponentsHeight();
            h += PrintStockHistoryComponent.this.border;
            if (PrintStockHistoryComponent.this.customerSearch != null) {
                h = (int)((double)h + PrintStockHistoryComponent.this.customerSearch.getPreferredSize().getHeight());
                h += PrintStockHistoryComponent.this.border;
            }
            if (PrintStockHistoryComponent.this.period != null) {
                h = (int)((double)h + PrintStockHistoryComponent.this.period.getPreferredSize().getHeight());
                h += PrintStockHistoryComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

