/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.popup.content;

import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContent;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FilteredDataSelectionContent
extends SubModulePopupContent
implements ButtonListener {
    private RadioButtonBox exportSelectionBox;
    protected TitledItem<RadioButton> exportCurrent;
    protected TitledItem<RadioButton> exportFiltered;
    protected TitledItem<RadioButton> exportAll;
    protected TitledItem<RadioButton> numbers;
    protected TextField numberField;
    protected InfoButton numberInfo;
    protected ExpandIcon expandIcon;
    protected Table2 table;
    private boolean withNumbers;

    public FilteredDataSelectionContent() {
        this(false);
    }

    public FilteredDataSelectionContent(boolean withNumbers) {
        this.withNumbers = withNumbers;
        this.setLayout(new Layout());
        this.exportSelectionBox = new RadioButtonBox();
        this.exportCurrent = new TitledItem<RadioButton>(new RadioButton(), this.getExportCurrentText(), TitledItem.TitledItemOrientation.EAST);
        this.exportFiltered = new TitledItem<RadioButton>(new RadioButton(), this.getExportFilteredText(), TitledItem.TitledItemOrientation.EAST);
        if (this.canExportAll()) {
            this.exportAll = new TitledItem<RadioButton>(new RadioButton(), this.getExportAllText(), TitledItem.TitledItemOrientation.EAST);
        }
        this.exportCurrent.getElement().addButtonListener(this);
        this.exportFiltered.getElement().addButtonListener(this);
        if (this.canExportAll()) {
            this.exportAll.getElement().addButtonListener(this);
        }
        this.exportCurrent.getElement().setChecked(true);
        this.exportSelectionBox.addBox(this.exportCurrent, this.exportCurrent.getElement());
        this.exportSelectionBox.addBox(this.exportFiltered, this.exportFiltered.getElement());
        if (this.canExportAll()) {
            this.exportSelectionBox.addBox(this.exportAll, this.exportAll.getElement());
        }
        if (withNumbers) {
            this.numbers = new TitledItem<RadioButton>(new RadioButton(), "Export by Number", TitledItem.TitledItemOrientation.EAST);
            this.numbers.getElement().addButtonListener(this);
            this.exportSelectionBox.addBox(this.numbers, this.numbers.getElement());
            this.numberField = new TextField();
            this.numberField.getFader().setPermanent(true);
            this.add(this.numberField);
            this.numberInfo = new InfoButton();
            this.numberInfo.getFader().setPermanent(true);
            this.numberInfo.installStringViewer(ProductToolkit.getStringRangeDescription());
            this.add(this.numberInfo);
            this.table = this.createTable();
            if (this.table != null) {
                this.expandIcon = new ExpandIcon();
                this.expandIcon.addButtonListener(this);
                this.table.getFader().setPermanent(true);
                this.table.getFader().setMetaParent(this);
                this.table.getFader().setProgress(0.0f);
                this.table.setSize(0, (int)this.numberField.getPreferredSize().getHeight());
                this.table.setEnabled(false);
                this.expandIcon.setEnabled(false);
                this.add(this.table);
                this.add(this.expandIcon);
            }
            this.numberField.setEnabled(false);
            this.numberInfo.setEnabled(false);
        }
        this.add(this.exportSelectionBox);
    }

    public String getExportAllText() {
        return "Export all";
    }

    public String getExportFilteredText() {
        return "Export filtered";
    }

    public String getExportCurrentText() {
        return "Export current";
    }

    public boolean canExportAll() {
        return true;
    }

    public Table2 createTable() {
        return null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.expandIcon != null & this.expandIcon == source) {
            if (!this.expandIcon.isExpanded()) {
                this.hideTable();
            } else {
                this.showTable();
            }
        } else if (this.numbers != null) {
            boolean isNumbers = false;
            if (this.numbers.getElement() == source) {
                isNumbers = true;
            }
            this.numberField.setEnabled(isNumbers);
            this.numberInfo.setEnabled(isNumbers);
            if (this.expandIcon != null) {
                this.expandIcon.setEnabled(isNumbers);
            }
            if (this.table != null) {
                this.table.setEnabled(isNumbers);
            }
        }
    }

    private void showTable() {
        if (this.table != null) {
            this.table.fadeIn();
            this.table.setSizeSmooth(this.table.getWidth(), 250);
            this.numberField.fadeOut(false);
            this.numberInfo.fadeOut(false);
        }
    }

    private void hideTable() {
        if (this.table != null) {
            this.table.fadeOut(false);
            this.table.setSizeSmooth(this.table.getWidth(), (int)this.numberField.getPreferredSize().getHeight());
            this.numberField.fadeIn();
            this.numberInfo.fadeIn();
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.exportCurrent);
        CheckedListAdder.addToList(a, this.exportFiltered);
        CheckedListAdder.addToList(a, this.exportAll);
        if (this.withNumbers) {
            CheckedListAdder.addToList(a, this.numberField);
            CheckedListAdder.addToList(a, this.table);
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.exportCurrent.requestFocusInWindow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = (int)((double)h + FilteredDataSelectionContent.this.exportSelectionBox.getPreferredSize().getHeight());
            h += FilteredDataSelectionContent.this.border;
            if (FilteredDataSelectionContent.this.table != null) {
                h += FilteredDataSelectionContent.this.table.getHeight();
                h += FilteredDataSelectionContent.this.border;
            } else if (FilteredDataSelectionContent.this.numberField != null) {
                h = (int)((double)h + FilteredDataSelectionContent.this.numberField.getPreferredSize().getHeight());
                h += FilteredDataSelectionContent.this.border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            FilteredDataSelectionContent.this.exportSelectionBox.setLocation(0, 0);
            FilteredDataSelectionContent.this.exportSelectionBox.setSize(parent.getWidth() - 2 * FilteredDataSelectionContent.this.border, (int)FilteredDataSelectionContent.this.exportSelectionBox.getPreferredSize().getHeight());
            int h2 = FilteredDataSelectionContent.this.exportSelectionBox.getY() + FilteredDataSelectionContent.this.exportSelectionBox.getHeight() + FilteredDataSelectionContent.this.border;
            if (FilteredDataSelectionContent.this.numberField != null) {
                if (FilteredDataSelectionContent.this.expandIcon != null) {
                    FilteredDataSelectionContent.this.numberField.setLocation((int)((double)FilteredDataSelectionContent.this.border + FilteredDataSelectionContent.this.expandIcon.getPreferredSize().getWidth() + (double)FilteredDataSelectionContent.this.border), h2);
                    FilteredDataSelectionContent.this.numberField.setSize((int)((double)FilteredDataSelectionContent.this.exportSelectionBox.getWidth() - (3.0 + FilteredDataSelectionContent.this.numberInfo.getPreferredSize().getWidth() + (double)FilteredDataSelectionContent.this.border + FilteredDataSelectionContent.this.expandIcon.getPreferredSize().getWidth())), (int)FilteredDataSelectionContent.this.numberField.getPreferredSize().getHeight());
                    FilteredDataSelectionContent.this.expandIcon.setLocation(FilteredDataSelectionContent.this.border, (int)((double)(FilteredDataSelectionContent.this.numberField.getY() + FilteredDataSelectionContent.this.numberField.getHeight()) - FilteredDataSelectionContent.this.expandIcon.getPreferredSize().getHeight() - 6.0));
                    FilteredDataSelectionContent.this.expandIcon.setSize(FilteredDataSelectionContent.this.expandIcon.getPreferredSize());
                } else {
                    FilteredDataSelectionContent.this.numberField.setLocation(FilteredDataSelectionContent.this.border, h2);
                    FilteredDataSelectionContent.this.numberField.setSize((int)((double)FilteredDataSelectionContent.this.exportSelectionBox.getWidth() - (3.0 + FilteredDataSelectionContent.this.numberInfo.getPreferredSize().getWidth())), (int)FilteredDataSelectionContent.this.numberField.getPreferredSize().getHeight());
                }
                FilteredDataSelectionContent.this.numberInfo.setLocation(FilteredDataSelectionContent.this.numberField.getX() + FilteredDataSelectionContent.this.numberField.getWidth() + 3, (int)((double)(FilteredDataSelectionContent.this.numberField.getY() + FilteredDataSelectionContent.this.numberField.getHeight()) - FilteredDataSelectionContent.this.numberInfo.getPreferredSize().getHeight() - 2.0));
                FilteredDataSelectionContent.this.numberInfo.setSize(FilteredDataSelectionContent.this.numberInfo.getPreferredSize());
                if (FilteredDataSelectionContent.this.table != null) {
                    FilteredDataSelectionContent.this.table.setLocation(FilteredDataSelectionContent.this.numberField.getX(), FilteredDataSelectionContent.this.numberField.getY());
                    FilteredDataSelectionContent.this.table.setSize(FilteredDataSelectionContent.this.numberField.getWidth(), FilteredDataSelectionContent.this.table.getHeight());
                    h2 = FilteredDataSelectionContent.this.table.getY() + FilteredDataSelectionContent.this.table.getHeight() + FilteredDataSelectionContent.this.border;
                } else {
                    h2 = FilteredDataSelectionContent.this.numberField.getY() + FilteredDataSelectionContent.this.numberField.getHeight() + FilteredDataSelectionContent.this.border;
                }
            }
        }
    }
}

