/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.irregularity;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.IrregularityReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class PrintIrregularityComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> node;
    private TitledPeriodEditor periodEditor;
    private TitledItem<CheckBox> showHistoricalData;
    private TitledItem<CheckBox> includeCustomerData;

    public PrintIrregularityComponent(Node<BasicArticleLight> flightNode) {
        super(true, false, false, true, false, ReportTypeE.IRREGULARITY);
        this.node = flightNode;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.includeCustomerData);
        CheckedListAdder.addToList(focusList, this.showHistoricalData);
        return focusList;
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return ((BasicArticleLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[12];
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.showHistoricalData != null) {
            this.showHistoricalData.kill();
        }
        this.showHistoricalData = null;
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        this.periodEditor = null;
        if (this.includeCustomerData != null) {
            this.includeCustomerData.kill();
        }
        this.includeCustomerData = null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), false, false), null);
        this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.showHistoricalData = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ALL, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.periodEditor);
        this.getViewContainer().add(this.includeCustomerData);
        this.getViewContainer().add(this.showHistoricalData);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.periodEditor.setVisible(true);
        this.includeCustomerData.setVisible(true);
        this.showHistoricalData.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.periodEditor.setVisible(false);
        this.includeCustomerData.setVisible(false);
        this.showHistoricalData.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                IrregularityReportConfiguration config = new IrregularityReportConfiguration(ReportingOutputFormatE.XLSX, PrintIrregularityComponent.this.getSelectedReport());
                config.setArticle(new BasicArticleReference(((BasicArticleLight)PrintIrregularityComponent.this.node.getValue()).getId()));
                config.setPeriod(PrintIrregularityComponent.this.periodEditor.getPeriod());
                config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)PrintIrregularityComponent.this.includeCustomerData.getElement()).isChecked()));
                if (((CheckBox)PrintIrregularityComponent.this.showHistoricalData.getElement()).isChecked()) {
                    config.setShowHistorizedData(Boolean.valueOf(true));
                    config.setShowLastestValue(Boolean.valueOf(true));
                } else {
                    config.setShowHistorizedData(Boolean.valueOf(false));
                    config.setShowLastestValue(Boolean.valueOf(true));
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createIrregularityReport(config).getValue();
                PrintIrregularityComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintIrregularityComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintIrregularityComponent.this.layoutInheritedComponents(parent);
            if (PrintIrregularityComponent.this.periodEditor != null) {
                PrintIrregularityComponent.this.periodEditor.setLocation(PrintIrregularityComponent.this.border, y + PrintIrregularityComponent.this.border);
                PrintIrregularityComponent.this.periodEditor.setSize(parent.getWidth() - 2 * PrintIrregularityComponent.this.border, (int)PrintIrregularityComponent.this.periodEditor.getPreferredSize().getHeight());
                y = PrintIrregularityComponent.this.periodEditor.getY() + PrintIrregularityComponent.this.periodEditor.getHeight();
            }
            if (PrintIrregularityComponent.this.includeCustomerData != null) {
                PrintIrregularityComponent.this.includeCustomerData.setLocation(PrintIrregularityComponent.this.border, y + PrintIrregularityComponent.this.border / 2);
                PrintIrregularityComponent.this.includeCustomerData.setSize(PrintIrregularityComponent.this.includeCustomerData.getPreferredSize());
                y = PrintIrregularityComponent.this.includeCustomerData.getY() + PrintIrregularityComponent.this.includeCustomerData.getHeight();
            }
            if (PrintIrregularityComponent.this.showHistoricalData != null) {
                PrintIrregularityComponent.this.showHistoricalData.setLocation(PrintIrregularityComponent.this.border, y + PrintIrregularityComponent.this.border / 2);
                PrintIrregularityComponent.this.showHistoricalData.setSize(PrintIrregularityComponent.this.showHistoricalData.getPreferredSize());
                y = PrintIrregularityComponent.this.showHistoricalData.getY() + PrintIrregularityComponent.this.showHistoricalData.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintIrregularityComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintIrregularityComponent.this.border;
            if (PrintIrregularityComponent.this.periodEditor != null) {
                h = (int)((double)h + PrintIrregularityComponent.this.periodEditor.getPreferredSize().getHeight());
            }
            if (PrintIrregularityComponent.this.includeCustomerData != null) {
                h += PrintIrregularityComponent.this.border / 2;
                h = (int)((double)h + PrintIrregularityComponent.this.includeCustomerData.getPreferredSize().getHeight());
            }
            if (PrintIrregularityComponent.this.showHistoricalData != null) {
                h += PrintIrregularityComponent.this.border / 2;
                h = (int)((double)h + PrintIrregularityComponent.this.showHistoricalData.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += PrintIrregularityComponent.this.border);
        }
    }
}

