/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.additional;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.FlightHandlingCostConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.search.HandlingCostSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class ImportAdditionalAndHandlingComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> node;
    private List<ExcelRow> rows;
    private List<ImportEquipment> equipments = new ArrayList<ImportEquipment>();
    private List<ImportHandling> handling = new ArrayList<ImportHandling>();
    private List<ImportSPML> specialMeals = new ArrayList<ImportSPML>();
    private JLabel message;
    private JLabel title1;
    private JLabel title2;
    private JLabel title3;
    private TitledItem<CheckBox> allSPML;

    public ImportAdditionalAndHandlingComponent(Node<FlightLight> node) {
        super(true, false, false, false, null);
        this.node = node;
        this.getViewContainer().setLayout(new Layout());
        this.ensureAnimation(Words.SELECT_DATA);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.message != null) {
            this.message.setVisible(false);
            if (this.title1 != null) {
                this.title1.setVisible(false);
            }
            if (this.title2 != null) {
                this.title2.setVisible(false);
            }
            if (this.title3 != null) {
                this.title3.setVisible(false);
            }
            for (ImportEquipment eq : this.equipments) {
                eq.setVisible(false);
            }
            for (ImportHandling hq : this.handling) {
                hq.setVisible(false);
            }
            for (ImportSPML specialMeal : this.specialMeals) {
                specialMeal.setVisible(false);
            }
            this.allSPML.setVisible(false);
        }
    }

    @Override
    public void loadReportTypes() {
        block7: {
            this.popup.disablePreviewButton();
            this.reportTypesLoaded = true;
            MainFrame.isTempRelease = true;
            File fileName = FileChooserUtil.loadFile();
            if (fileName != null) {
                File f = fileName;
                this.ensureAnimation(Words.PROCESS_FILE);
                try {
                    this.rows = ExcelToolkit.readRows((File)f);
                }
                catch (ExcelToolkitException e) {
                    InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
                }
                try {
                    this.showPossibleEquipments();
                    this.removeAnimation(false, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.removeAnimation(false, true);
                    this.showMessage(Words.UNABLE_TO_IMPORT_DATA);
                    if (this.popup != null) {
                        this.popup.hideCancelButton();
                        this.popup.disablePreviewButton();
                        this.popup.setOkButtonText(Words.CLOSE);
                        this.printed = true;
                    }
                    break block7;
                }
            }
            this.removeAnimation(false, true);
            this.showMessage(Words.DATA_IMPORT_CANCELLED);
            if (this.popup != null) {
                this.popup.hideCancelButton();
                this.popup.disablePreviewButton();
                this.popup.setOkButtonText(Words.CLOSE);
                this.printed = true;
            }
        }
        MainFrame.isTempRelease = false;
    }

    private void showPossibleEquipments() {
        ImportEquipment latestEq = null;
        for (ExcelRow r : this.rows) {
            String fromServer;
            String fromClient;
            Object cabinClassCode;
            Object legNo;
            TitledItem iq;
            Object qty;
            Object name;
            Object number;
            if (r.getCellCount() <= 0) continue;
            Object id = r.getCells().get(0);
            if (id != null && id.equals("e")) {
                number = r.getCells().get(1);
                name = r.getCells().get(2);
                qty = r.getCells().get(3);
                if (qty == null || qty.equals("")) {
                    qty = "0";
                }
                iq = null;
                iq = name instanceof String ? new ImportEquipment((String)name) : new ImportEquipment("");
                latestEq = iq;
                if (number instanceof String) {
                    ((ImportEquipment)iq).setNumber((String)number);
                } else if (number instanceof Integer) {
                    ((ImportEquipment)iq).setNumber("" + number);
                } else if (number instanceof Double) {
                    ((ImportEquipment)iq).setNumber("" + ((Double)number).intValue());
                }
                if (qty instanceof String) {
                    ((ImportEquipment)iq).setQty(Integer.valueOf((String)qty));
                } else if (qty instanceof Integer) {
                    ((ImportEquipment)iq).setQty((Integer)qty);
                } else if (qty instanceof Double) {
                    ((ImportEquipment)iq).setQty(((Double)qty).intValue());
                }
                this.equipments.add((ImportEquipment)iq);
                continue;
            }
            if (id != null && id.equals("p")) {
                String fromServer2;
                if (latestEq == null) continue;
                number = r.getCells().get(1);
                name = r.getCells().get(2);
                qty = r.getCells().get(3);
                if (qty == null || qty.equals("")) {
                    qty = "0";
                }
                Object leg = null;
                Object clazz = null;
                Object galley = null;
                Object equipment = null;
                Object paxName = null;
                Object seatNumber = null;
                Object labelColor = null;
                Object labelText = null;
                if (r.getCells().size() >= 5) {
                    leg = r.getCells().get(4);
                }
                if (leg == null || leg.equals("")) {
                    InnerPopupFactory.showErrorDialog("Found Product without leg", (Component)this);
                }
                if (r.getCells().size() >= 6) {
                    clazz = r.getCells().get(5);
                }
                if (clazz == null || clazz.equals("")) {
                    InnerPopupFactory.showErrorDialog("Found Product without cabin class", (Component)this);
                }
                if (r.getCells().size() > 6) {
                    galley = r.getCells().get(6);
                }
                if (r.getCells().size() > 7) {
                    equipment = r.getCells().get(7);
                }
                if (r.getCells().size() > 8) {
                    paxName = r.getCells().get(8);
                }
                if (r.getCells().size() > 9) {
                    seatNumber = r.getCells().get(9);
                }
                if (r.getCells().size() > 10) {
                    labelColor = r.getCells().get(10);
                }
                if (r.getCells().size() > 11) {
                    labelText = r.getCells().get(11);
                }
                ImportProduct iq2 = new ImportProduct();
                if (number instanceof String) {
                    iq2.setNumber(Integer.valueOf((String)number));
                } else if (number instanceof Integer) {
                    iq2.setNumber((Integer)number);
                } else if (number instanceof Double) {
                    iq2.setNumber(((Double)number).intValue());
                }
                if (name instanceof String) {
                    iq2.setName((String)name);
                }
                if (qty instanceof String) {
                    iq2.setQty(Integer.valueOf((String)qty));
                } else if (qty instanceof Integer) {
                    iq2.setQty((Integer)qty);
                } else if (qty instanceof Double) {
                    iq2.setQty(((Double)qty).intValue());
                }
                if (leg != null) {
                    if (leg instanceof String) {
                        iq2.setLegNumber(Integer.valueOf((String)leg));
                    } else if (leg instanceof Integer) {
                        iq2.setLegNumber((Integer)leg);
                    } else if (leg instanceof Double) {
                        iq2.setLegNumber(((Double)leg).intValue());
                    }
                }
                if (clazz != null) {
                    String ccName = null;
                    if (clazz instanceof String) {
                        ccName = (String)clazz;
                    }
                    if (ccName != null) {
                        for (CabinClassComplete cc : (List)NodeToolkit.getAffixList(CabinClassComplete.class).getValue()) {
                            if (!cc.getCode().equals(ccName)) continue;
                            iq2.setCabinClass(cc);
                        }
                    }
                }
                if (galley instanceof String && galley.toString().length() > 0) {
                    FlightReference flightReference = new FlightReference(((FlightLight)this.node.getValue()).getId());
                    ArrayList<DeliverySpaceComplete> spacesInGalley = new ArrayList<DeliverySpaceComplete>();
                    try {
                        List orderSpaces = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces(flightReference).getList();
                        for (DeliverySpaceComplete space : orderSpaces) {
                            String fromClient2 = galley.toString().toLowerCase().trim();
                            String fromServer3 = space.getContainingEquipment() == null || space.getContainingEquipment().getContainingGalley() == null ? space.getContainingGalleyCode().toLowerCase() : space.getContainingEquipment().getContainingGalley().getGalleyCode().toLowerCase();
                            if (fromServer3.startsWith("galley ") && !fromClient2.startsWith("galley ")) {
                                fromServer3 = fromServer3.split("galley ")[1];
                            }
                            if (!fromClient2.equals(fromServer3)) continue;
                            spacesInGalley.add(space);
                        }
                    }
                    catch (ClientServerCallException e) {
                        e.printStackTrace();
                    }
                    if (equipment instanceof String && equipment.toString().length() > 0) {
                        String fromClient3 = equipment.toString().toLowerCase().trim();
                        for (DeliverySpaceComplete space : spacesInGalley) {
                            fromServer2 = space.getContainingEquipment() == null || space.getContainingEquipment().getContainingGalley() == null ? space.getContainingEquipmentCode().toLowerCase() : space.getContainingEquipment().getPositionCode().toLowerCase().trim();
                            if (!fromServer2.contains(fromClient3)) continue;
                            iq2.setSpace(space);
                        }
                    }
                }
                if (paxName instanceof String) {
                    iq2.setPaxName(paxName);
                }
                if (seatNumber instanceof String) {
                    iq2.setSeatNumber(seatNumber);
                }
                if (labelColor instanceof String && labelColor.toString().length() > 0) {
                    String fromClient4 = labelColor.toString().toLowerCase().trim();
                    for (ColorComplete colorComplete : (List)NodeToolkit.getAffixList(ColorComplete.class).getValue()) {
                        fromServer2 = colorComplete.getName().toLowerCase();
                        if (!fromServer2.equals(fromClient4)) continue;
                        iq2.setLabelColor(colorComplete);
                    }
                }
                if (labelText instanceof String) {
                    iq2.setLabelText(labelText);
                }
                latestEq.getProducts().add(iq2);
                continue;
            }
            if (id != null && id.equals("h")) {
                number = r.getCells().get(1);
                name = r.getCells().get(2);
                qty = r.getCells().get(3);
                if (qty == null || qty.equals("")) {
                    qty = "0";
                }
                iq = null;
                iq = name instanceof String ? new ImportHandling((String)name) : new ImportHandling("");
                if (number instanceof String) {
                    ((ImportHandling)iq).setNumber((String)number);
                } else if (number instanceof Integer) {
                    ((ImportHandling)iq).setNumber("" + number);
                } else if (number instanceof Double) {
                    ((ImportHandling)iq).setNumber("" + ((Double)number).intValue());
                }
                if (qty instanceof String) {
                    ((ImportHandling)iq).setQty(Integer.valueOf((String)qty));
                } else if (qty instanceof Integer) {
                    ((ImportHandling)iq).setQty((Integer)qty);
                } else if (qty instanceof Double) {
                    ((ImportHandling)iq).setQty(((Double)qty).intValue());
                }
                this.handling.add((ImportHandling)iq);
                continue;
            }
            if (id == null || !id.equals("s")) continue;
            Object spmlCode = r.getCells().get(2);
            Object qty2 = r.getCells().get(3);
            if (qty2 == null || qty2.equals("")) {
                qty2 = "0";
            }
            if ((legNo = r.getCells().get(4)) == null || legNo.equals("")) {
                InnerPopupFactory.showErrorDialog("Found SPML without leg", (Component)this);
            }
            if ((cabinClassCode = r.getCells().get(5)) == null || cabinClassCode.equals("")) {
                InnerPopupFactory.showErrorDialog("Found SPML without cabin class", (Component)this);
            }
            Object paxName = r.getCells().get(8);
            Object seatNo = r.getCells().get(9);
            Object remark = r.getCells().get(12);
            ImportSPML importSPML = new ImportSPML(spmlCode + " - Leg " + legNo + " - " + cabinClassCode);
            if (paxName instanceof String) {
                importSPML.setPaxName((String)paxName);
            }
            if (seatNo instanceof String) {
                importSPML.setSeatNo((String)seatNo);
            }
            if (remark instanceof String) {
                importSPML.setRemark((String)remark);
            }
            if (spmlCode instanceof String && spmlCode.toString().length() > 0) {
                fromClient = spmlCode.toString().toLowerCase().trim();
                for (SpecialMenuTypeComplete colorComplete : (List)NodeToolkit.getAffixList(SpecialMenuTypeComplete.class).getValue()) {
                    fromServer = colorComplete.getCode().toLowerCase();
                    if (!fromServer.equals(fromClient)) continue;
                    importSPML.setSpmlType(colorComplete);
                }
            }
            if (cabinClassCode instanceof String && cabinClassCode.toString().length() > 0) {
                fromClient = cabinClassCode.toString().toLowerCase().trim();
                for (SpecialMenuTypeComplete colorComplete : (List)NodeToolkit.getAffixList(CabinClassComplete.class).getValue()) {
                    fromServer = colorComplete.getCode().toLowerCase();
                    if (!fromServer.equals(fromClient)) continue;
                    importSPML.setCabinClass((CabinClassComplete)colorComplete);
                }
            }
            if (qty2 instanceof String) {
                importSPML.setCount(Integer.valueOf((String)qty2));
            } else if (qty2 instanceof Integer) {
                importSPML.setCount((Integer)qty2);
            } else if (qty2 instanceof Double) {
                importSPML.setCount(((Double)qty2).intValue());
            }
            if (legNo instanceof String) {
                importSPML.setLegNo(Integer.valueOf((String)legNo));
            } else if (legNo instanceof Integer) {
                importSPML.setLegNo((Integer)legNo);
            } else if (legNo instanceof Double) {
                importSPML.setLegNo(((Double)legNo).intValue());
            }
            this.specialMeals.add(importSPML);
        }
        if (this.equipments.isEmpty()) {
            InnerPopupFactory.showErrorDialog("No equipments found, ensure the equipment lines uses a 'e' in the first column", (Component)this);
        }
        for (ImportEquipment equipment : this.equipments) {
            if (!equipment.getProducts().isEmpty()) continue;
            InnerPopupFactory.showErrorDialog("No products in equipment found, ensure the product lines uses a 'p' in the first column", (Component)this);
        }
        if (this.message == null) {
            this.message = new JLabel();
            this.message.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.message.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.message);
        }
        this.message.setText("<html><b>Import Additionals & Handlings</b><br/>Check all Equipments & Handlings you want to load additionally</html>");
        if (!this.equipments.isEmpty()) {
            this.title1 = new JLabel("<html><b>Equipments</b></html>");
            this.title1.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.title1.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.title1);
        }
        for (ImportEquipment eq : this.equipments) {
            this.getViewContainer().add(eq);
        }
        if (!this.handling.isEmpty()) {
            this.title2 = new JLabel("<html><b>Handlings</b></html>");
            this.title2.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.title2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.title2);
        }
        for (ImportHandling hq : this.handling) {
            this.getViewContainer().add(hq);
        }
        if (!this.specialMeals.isEmpty()) {
            this.title3 = new JLabel("<html><b>Special Meals</b></html>");
            this.title3.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.title3.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            this.getViewContainer().add(this.title3);
        }
        this.allSPML = new TitledItem<CheckBox>(new CheckBox(), Words.ALL_SPML, TitledItem.TitledItemOrientation.EAST);
        this.allSPML.getElement().addButtonListener((s, x, y) -> {
            for (ImportSPML meal : this.specialMeals) {
                ((CheckBox)meal.getElement()).setChecked(this.allSPML.getElement().isChecked());
            }
        });
        this.getViewContainer().add(this.allSPML);
        for (ImportSPML specialMeal : this.specialMeals) {
            this.getViewContainer().add(specialMeal);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    protected String getProgressText() {
        return "Create Additional Orders,  Handling Costs & Special Meals";
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        return ((FlightLight)this.node.getValue()).getOutboundCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    private AdditionalOrderComplete createNewAdditionalOrder(FlightComplete flight, ImportProduct p, ImportEquipment i) throws ServiceException {
        int f;
        AdditionalOrderComplete a = new AdditionalOrderComplete();
        ProductVariantSearchConfiguration c = new ProductVariantSearchConfiguration();
        c.setNumber(Integer.valueOf(p.getNumber()));
        SearchResultIterator si = new SearchResultIterator((ASearchConfiguration)c);
        ProductVariantLight np = (ProductVariantLight)si.next();
        if (np.getProduct() == null && np.getProductId() != null) {
            ProductComplete productByReference = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductByReference(new ProductReference(np.getProductId())).getValue();
            a.setProduct(productByReference);
        } else {
            a.setProduct(np.getProduct());
        }
        if (p.getLegNumber() > 0) {
            a.setLeg((ILegComplete)flight.getLegs().get(p.getLegNumber() - 1));
        } else {
            a.setLeg((ILegComplete)flight.getLegs().get(0));
        }
        if (p.getCabinClass() != null) {
            a.setCabinClass(p.getCabinClass());
        }
        if ((f = i.getQty()) == 0) {
            f = 1;
        }
        a.setQuantity(Integer.valueOf(p.getQty() * f));
        a.setStowingPosition(p.getSpace());
        a.setPassengerName(p.getPaxName());
        a.setSeatNumber(p.getSeatNumber());
        a.setLabelColor(p.getLabelColor());
        a.setLabelText(p.getLabelText());
        a.setExpiryDate(FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()), (FlightLight)flight, (ProductComplete)a.getProduct()));
        return a;
    }

    private SpecialMealOrderComplete createNewSPMLOrder(FlightComplete flight, ImportSPML p) throws ServiceException {
        SpecialMealOrderComplete a = new SpecialMealOrderComplete();
        a.setCount(Integer.valueOf(p.getCount()));
        a.setFlight((FlightReference)flight);
        a.setCabinClass(p.getCabinClass());
        a.setMenuType(p.getSpmlType());
        a.setPaxName(p.getPaxName());
        a.setPredefined(Boolean.valueOf(false));
        a.setSeatNumber(p.getSeatNo());
        a.setPaxRemark(p.getRemark());
        if (p.getLegNo() > 0) {
            a.getLegs().add(flight.getLegs().get(p.getLegNo() - 1));
        } else {
            a.getLegs().add(flight.getLegs().get(0));
        }
        return a;
    }

    private FlightHandlingCostConfigurationComplete createNewHandlingCost(FlightComplete flight, ImportHandling p) throws ServiceException {
        FlightHandlingCostConfigurationComplete a = new FlightHandlingCostConfigurationComplete();
        a.setFlight((FlightReference)flight);
        HandlingCostSearchConfiguration c = new HandlingCostSearchConfiguration();
        try {
            int i = Integer.valueOf(p.getNumber());
            c.setNumber(Integer.valueOf(i));
            c.setName(p.getNumber());
        }
        catch (Exception i) {
            // empty catch block
        }
        SearchResultIterator si = new SearchResultIterator((ASearchConfiguration)c);
        HandlingCostComplete np = (HandlingCostComplete)si.next();
        a.setHandlingCost(np);
        int f = p.getQty();
        if (f == 0) {
            f = 1;
        }
        a.setAmount(Integer.valueOf(f));
        return a;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightHandlingCostConfigurationComplete hc;
                FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(((FlightLight)ImportAdditionalAndHandlingComponent.this.node.getValue()).getId())).getValue();
                ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
                for (ImportEquipment i : ImportAdditionalAndHandlingComponent.this.equipments) {
                    if (!((CheckBox)i.getElement()).isChecked()) continue;
                    for (ImportProduct p : i.getProducts()) {
                        try {
                            AdditionalOrderComplete additional = ImportAdditionalAndHandlingComponent.this.createNewAdditionalOrder(fc, p, i);
                            fc.getAdditionalOrders().add(additional);
                        }
                        catch (Exception e) {
                            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to create Additional Order for Produt No: " + p.getNumber() + " - " + p.getName()));
                        }
                    }
                }
                for (TitledItem h : ImportAdditionalAndHandlingComponent.this.handling) {
                    if (!((CheckBox)h.getElement()).isChecked()) continue;
                    try {
                        hc = ImportAdditionalAndHandlingComponent.this.createNewHandlingCost(fc, (ImportHandling)h);
                        fc.getFlightHandlingCostConfiguration().add(hc);
                    }
                    catch (Exception e) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to create Handling Cost for Handling No: " + ((ImportHandling)h).getNumber() + " - " + ((ImportHandling)h).getName()));
                    }
                }
                for (TitledItem h : ImportAdditionalAndHandlingComponent.this.specialMeals) {
                    if (!((CheckBox)h.getElement()).isChecked()) continue;
                    try {
                        hc = ImportAdditionalAndHandlingComponent.this.createNewSPMLOrder(fc, (ImportSPML)h);
                        fc.getSpmlOrders().add(hc);
                    }
                    catch (Exception e) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to create Special Meal: " + h.getName()));
                    }
                }
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(), false, false, false, false);
                if (!a.isEmpty()) {
                    InnerPopupFactory.showErrorDialog(a, "Unable to import all Additional Products, Handlings & SPML Orders", (Component)ImportAdditionalAndHandlingComponent.this);
                }
                ImportAdditionalAndHandlingComponent.this.printed = true;
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ImportAdditionalAndHandlingComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    private class ImportProduct {
        private int number;
        private String name;
        private int qty;
        private int legNumber = 0;
        private DeliverySpaceComplete space;
        private String paxName;
        private String seatNumber;
        private ColorComplete labelColor;
        private String labelText;
        private CabinClassComplete cabinClass;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public int getLegNumber() {
            return this.legNumber;
        }

        public void setLegNumber(int legNumber) {
            this.legNumber = legNumber;
        }

        public CabinClassComplete getCabinClass() {
            return this.cabinClass;
        }

        public void setCabinClass(CabinClassComplete cabinClass) {
            this.cabinClass = cabinClass;
        }

        public String getPaxName() {
            return this.paxName;
        }

        public void setPaxName(String paxName) {
            this.paxName = paxName;
        }

        public String getSeatNumber() {
            return this.seatNumber;
        }

        public void setSeatNumber(String seatNumber) {
            this.seatNumber = seatNumber;
        }

        public String getLabelText() {
            return this.labelText;
        }

        public void setLabelText(String labelText) {
            this.labelText = labelText;
        }

        public ColorComplete getLabelColor() {
            return this.labelColor;
        }

        public void setLabelColor(ColorComplete labelColor) {
            this.labelColor = labelColor;
        }

        public DeliverySpaceComplete getSpace() {
            return this.space;
        }

        public void setSpace(DeliverySpaceComplete space) {
            this.space = space;
        }
    }

    private class ImportSPML
    extends TitledItem<CheckBox> {
        private int legNo;
        private CabinClassComplete cabinClass;
        private SpecialMenuTypeComplete spmlType;
        private int count;
        private String seatNo;
        private String paxName;
        private String remark;
        private DeliverySpaceComplete space;

        public ImportSPML(String name) {
            super(new CheckBox(), name, TitledItem.TitledItemOrientation.EAST);
        }

        public int getLegNo() {
            return this.legNo;
        }

        public void setLegNo(int legNo) {
            this.legNo = legNo;
        }

        public CabinClassComplete getCabinClass() {
            return this.cabinClass;
        }

        public void setCabinClass(CabinClassComplete cabinClass) {
            this.cabinClass = cabinClass;
        }

        public SpecialMenuTypeComplete getSpmlType() {
            return this.spmlType;
        }

        public void setSpmlType(SpecialMenuTypeComplete spmlType) {
            this.spmlType = spmlType;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getSeatNo() {
            return this.seatNo;
        }

        public void setSeatNo(String seatNo) {
            this.seatNo = seatNo;
        }

        public String getPaxName() {
            return this.paxName;
        }

        public void setPaxName(String paxName) {
            this.paxName = paxName;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public DeliverySpaceComplete getSpace() {
            return this.space;
        }

        public void setSpace(DeliverySpaceComplete space) {
            this.space = space;
        }
    }

    private class ImportEquipment
    extends TitledItem<CheckBox> {
        private static final long serialVersionUID = 1L;
        private String name;
        private String number;
        private int qty;
        private List<ImportProduct> products;

        public ImportEquipment(String name) {
            super(new CheckBox(), name, TitledItem.TitledItemOrientation.EAST);
            this.products = new ArrayList<ImportProduct>();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public List<ImportProduct> getProducts() {
            return this.products;
        }
    }

    private class ImportHandling
    extends TitledItem<CheckBox> {
        private static final long serialVersionUID = -2000699836769759295L;
        private String number;
        private String name;
        private int qty;

        public ImportHandling(String name) {
            super(new CheckBox(), name, TitledItem.TitledItemOrientation.EAST);
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ImportAdditionalAndHandlingComponent.this.layoutInheritedComponents(parent);
            y += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.message != null) {
                ImportAdditionalAndHandlingComponent.this.message.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                ImportAdditionalAndHandlingComponent.this.message.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)ImportAdditionalAndHandlingComponent.this.message.getPreferredSize().getHeight());
                y += ImportAdditionalAndHandlingComponent.this.message.getHeight();
                y += ImportAdditionalAndHandlingComponent.this.border * 2;
            }
            if (ImportAdditionalAndHandlingComponent.this.title1 != null) {
                ImportAdditionalAndHandlingComponent.this.title1.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                ImportAdditionalAndHandlingComponent.this.title1.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)ImportAdditionalAndHandlingComponent.this.title1.getPreferredSize().getHeight());
                y += ImportAdditionalAndHandlingComponent.this.title1.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.equipments) {
                i.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                i.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)i.getPreferredSize().getHeight());
                y += i.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
            y += ImportAdditionalAndHandlingComponent.this.border / 2;
            y += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.title2 != null) {
                ImportAdditionalAndHandlingComponent.this.title2.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                ImportAdditionalAndHandlingComponent.this.title2.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)ImportAdditionalAndHandlingComponent.this.title2.getPreferredSize().getHeight());
                y += ImportAdditionalAndHandlingComponent.this.title2.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.handling) {
                i.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                i.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)i.getPreferredSize().getHeight());
                y += i.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
            y += ImportAdditionalAndHandlingComponent.this.border / 2;
            y += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.title3 != null) {
                ImportAdditionalAndHandlingComponent.this.title3.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                ImportAdditionalAndHandlingComponent.this.title3.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)ImportAdditionalAndHandlingComponent.this.title3.getPreferredSize().getHeight());
                y += ImportAdditionalAndHandlingComponent.this.title3.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
            if (ImportAdditionalAndHandlingComponent.this.allSPML != null) {
                ImportAdditionalAndHandlingComponent.this.allSPML.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                ImportAdditionalAndHandlingComponent.this.allSPML.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)ImportAdditionalAndHandlingComponent.this.allSPML.getPreferredSize().getHeight());
                y += ImportAdditionalAndHandlingComponent.this.allSPML.getHeight() + ImportAdditionalAndHandlingComponent.this.border;
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.specialMeals) {
                i.setLocation(ImportAdditionalAndHandlingComponent.this.border, y);
                i.setSize(parent.getWidth() - 2 * ImportAdditionalAndHandlingComponent.this.border, (int)i.getPreferredSize().getHeight());
                y += i.getHeight() + ImportAdditionalAndHandlingComponent.this.border / 2;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ImportAdditionalAndHandlingComponent.this.getInheritedComponentsHeight();
            h += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.message != null) {
                h = (int)((double)h + ImportAdditionalAndHandlingComponent.this.message.getPreferredSize().getHeight());
                h += ImportAdditionalAndHandlingComponent.this.border * 2;
            }
            if (ImportAdditionalAndHandlingComponent.this.title2 != null) {
                h = (int)((double)h + (ImportAdditionalAndHandlingComponent.this.title2.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.equipments) {
                h = (int)((double)h + (i.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            h += ImportAdditionalAndHandlingComponent.this.border / 2;
            h += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.title2 != null) {
                h = (int)((double)h + (ImportAdditionalAndHandlingComponent.this.title2.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.handling) {
                h = (int)((double)h + (i.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            h += ImportAdditionalAndHandlingComponent.this.border / 2;
            h += ImportAdditionalAndHandlingComponent.this.border;
            if (ImportAdditionalAndHandlingComponent.this.title3 != null) {
                h = (int)((double)h + (ImportAdditionalAndHandlingComponent.this.title3.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            if (ImportAdditionalAndHandlingComponent.this.allSPML != null) {
                h = (int)((double)h + (ImportAdditionalAndHandlingComponent.this.allSPML.getPreferredSize().getHeight() + (double)ImportAdditionalAndHandlingComponent.this.border));
            }
            for (TitledItem i : ImportAdditionalAndHandlingComponent.this.specialMeals) {
                h = (int)((double)h + (i.getPreferredSize().getHeight() + (double)(ImportAdditionalAndHandlingComponent.this.border / 2)));
            }
            return new Dimension(0, h += ImportAdditionalAndHandlingComponent.this.border);
        }
    }
}

