/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.deliveryslip;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.print.shared.deliveryslip.PrintDeliverySlipComponent;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightDeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.sql.Date;

public class PrintFlightDeliverySlipComponent
extends PrintDeliverySlipComponent<FlightLight, FlightLegComplete> {
    private static final long serialVersionUID = -3352292231967302369L;
    private final TransferObject<FlightLight> flight;
    private ReportFileComplete deliverySlip;

    public PrintFlightDeliverySlipComponent(TransferObject<FlightLight> transferObject, RDProvider provider) {
        super(provider, false);
        this.flight = transferObject;
        this.loadBeforeShowing(() -> {
            try {
                this.deliverySlip = (ReportFileComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightDeliverySlipReportFile(new FlightReference(this.flight.getDto().getId())).getValue();
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        });
    }

    @Override
    public void selectReport(String reportSelection) {
        String t = this.deliverySlip != null ? this.deliverySlip.getFileName() : reportSelection;
        for (RadioButton rb : this.reportTypeBox.getButtons()) {
            DefaultScrollablePrintPopup2.ReportSelection rs = (DefaultScrollablePrintPopup2.ReportSelection)rb;
            if (!rs.getUserObject().getFileName().equals(t)) continue;
            rs.setChecked(true);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintFlightDeliverySlipComponent.this.getSelectedReport();
                FlightDeliverySlipReportConfiguration config = new FlightDeliverySlipReportConfiguration(ReportTypeE.DELIVERYSLIP, ReportingOutputFormatE.PDF, file);
                PrintFlightDeliverySlipComponent.this.getConfig(config);
                if (PrintFlightDeliverySlipComponent.this.finalizeFlight != null) {
                    config.setFinalizeFlight(Boolean.valueOf(((CheckBox)PrintFlightDeliverySlipComponent.this.finalizeFlight.getElement()).isChecked()));
                }
                config.setDto((IDTO)PrintFlightDeliverySlipComponent.this.flight.getDto());
                config.setValidityDate(new Date(((FlightLight)PrintFlightDeliverySlipComponent.this.flight.getDto()).getStd().getTime()));
                if (file != null && file.getDescription().contains("Weisse Arena")) {
                    config = new FlightDeliverySlipReportConfiguration();
                    config.setDto((IDTO)new FlightReference(((FlightLight)PrintFlightDeliverySlipComponent.this.flight.getNode().getValue()).getId()));
                    config.setFormat(ReportingOutputFormatE.PDF);
                    config.setStylesheet(file);
                    config.setPrintBody(Boolean.valueOf(true));
                    config.setPrintTitlepage(Boolean.valueOf(false));
                    if (PrintFlightDeliverySlipComponent.this.cashBased != null) {
                        config.setCashDeliverySlip(Boolean.valueOf(((RadioButton)PrintFlightDeliverySlipComponent.this.cashBased.getElement()).isChecked()));
                    } else {
                        config.setCashDeliverySlip(Boolean.valueOf(false));
                    }
                    config.setIncludeTemperature(Boolean.valueOf(true));
                    config.setIncludeDrawers(Boolean.valueOf(true));
                }
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDeliverySlipReport((DeliverySlipReportConfiguration)config, new ListWrapper()).getValue();
                PrintFlightDeliverySlipComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightDeliverySlipComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void insertElements() {
        super.insertElements();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.finalizeFlight = new TitledItem<CheckBox>(new CheckBox(), Words.SET_PAX_TO_FINAL, TitledItem.TitledItemOrientation.EAST);
        this.finalizeFlight.getTitle().setForeground(fb);
        this.finalizeFlight.getTitle().setFont(f);
        if (Boolean.TRUE.equals(this.flight.getDto().getCustomer().getShowSendDeliverySlipOptionAtFlight())) {
            this.sendDeliverySlip = new TitledItem<CheckBox>(new CheckBox(), Words.SEND_DELIVERY_SLIP_BY_MAIL, TitledItem.TitledItemOrientation.EAST);
            this.sendDeliverySlip.getTitle().setForeground(fb);
            this.sendDeliverySlip.getTitle().setFont(f);
            this.getViewContainer().add(this.sendDeliverySlip);
        }
        this.getViewContainer().add(this.finalizeFlight);
    }

    @Override
    public String getTitleValue() {
        CustomerConverter c1 = (CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class);
        return c1.convert(this.flight.getDto().getCustomer(), null, new Object[0]) + " " + this.flight.getDto().getOutboundCode();
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.flight.getNode();
    }
}

