/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration;

import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils.CreditCardRangesTable;
import ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils.SobCurrencyConfigurationTable;
import ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils.SobCurrencySequenceTable;
import ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils.SpecsDetailsPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CustomerAccess;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyExchangeComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SobCustomerConfigurationSubModule
extends SubModuleScreenInsert<CustomerLight> {
    private static final long serialVersionUID = 1L;
    private SpecsDetailsPanel<CustomerLight> specs;
    private CreditCardRangesTable ranges;
    private SobCurrencyConfigurationTable currencyTable;
    private SobCurrencySequenceTable sequenceTable;
    private Node<CustomerComplete> customer;
    private CustomerLight customerDTO;

    public SobCustomerConfigurationSubModule() {
        this.setOpaque(false);
    }

    public boolean isChargeBased() {
        return true;
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.specs);
        CheckedListAdder.addToList(a, this.ranges);
        CheckedListAdder.addToList(a, this.currencyTable);
        CheckedListAdder.addToList(a, this.sequenceTable);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public String getScreenTitle() {
        return CustomerAccess.TOOL_CUSTOMER_SOB_CONFIGURATION.getDisplayName();
    }

    public void init() {
        this.ranges = new CreditCardRangesTable();
        this.currencyTable = new SobCurrencyConfigurationTable();
        this.sequenceTable = new SobCurrencySequenceTable(this.currencyTable);
        this.specs = new SpecsDetailsPanel();
        this.setLayout(new Layout());
        this.add(this.specs);
        this.add(this.ranges);
        this.add(this.currencyTable);
        this.add(this.sequenceTable);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        boolean b = false;
        if (this.currentState == 5) {
            CustomerComplete c = (CustomerComplete)node.getValue(CustomerComplete.class);
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
            this.ranges.getModel().setNode(n.getChildNamed(new String[]{"creditCardRanges"}));
            this.sequenceTable.getModel().setNode(n.getChildNamed(new String[]{"sobCurrencies"}));
            this.sequenceTable.setCustomer(this.customerDTO);
            this.specs.setNode(n);
            b = false;
            this.ranges.hideLoadingAnimation();
        } else if (this.currentState == 11) {
            this.cancelDocument();
        } else {
            b = this.currentState == 7 ? false : false;
        }
        if (!b) {
            this.ranges.hideLoadingAnimation();
            this.setEnabled(true);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.ranges.hideLoadingAnimation();
        super.errorOccurred(exception);
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void saveAndBackDocument() {
        this.currentState = 11;
        this.ranges.showLoadingAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    @Override
    public void saveDocument() {
        this.currentState = 7;
        this.ranges.showLoadingAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    private void doSaveDocument() {
        List<ScreenValidationObject> a = this.sequenceTable.validateTable();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to save Sob Currency Configuration", (Component)this.currencyTable);
            this.ranges.hideLoadingAnimation();
        } else {
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SobCustomerConfigurationSubModule.this.customer.commit(CustomerComplete.class);
                    CustomerComplete c = (CustomerComplete)SobCustomerConfigurationSubModule.this.customer.getValue(CustomerComplete.class);
                    for (SobCurrencyComplete sc : c.getSobCurrencies()) {
                        for (SobCurrencyExchangeComplete v : sc.getVariants()) {
                            v.setValidityPeriod(new PeriodComplete(v.getValidityPeriod().getStartDate(), v.getValidityPeriod().getEndDate()));
                        }
                    }
                    c = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateCustomer((CustomerReference)c).getValue();
                    ViewNode n = new ViewNode("");
                    n.setValue((Object)c, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return SobCustomerConfigurationSubModule.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private void doLoadDocument() {
        this.setEnabled(false);
        this.currentState = 5;
        this.ranges.showLoadingAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomerComplete c = null;
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CreditCardTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                StaticEnumServiceManager.getAllCreditCardValidity();
                c = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer((CustomerReference)SobCustomerConfigurationSubModule.this.customerDTO).getValue();
                if (c != null) {
                    SobCustomerConfigurationSubModule.this.customer = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)c, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SobCustomerConfigurationSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.doLoadDocument();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.ranges.setEnabled(isEnabled);
        this.currencyTable.setEnabled(isEnabled);
        this.specs.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.ranges != null) {
            this.ranges.kill();
        }
        this.ranges = null;
        if (this.currencyTable != null) {
            this.currencyTable.kill();
        }
        this.currencyTable = null;
        if (this.sequenceTable != null) {
            this.sequenceTable.kill();
        }
        this.sequenceTable = null;
        if (this.specs != null) {
            this.specs.kill();
        }
        this.specs = null;
    }

    @Override
    public void setRowAttributes(RowTransferObject<CustomerLight> o) {
        this.setRow(o.getFakeRow());
        this.customerDTO = (CustomerLight)o.getDto();
        this.init();
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return CustomerAccess.getSubModuleDefinition((SubModuleAccessDefinition)CustomerAccess.TOOL_CUSTOMER_SOB_CONFIGURATION);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = SobCustomerConfigurationSubModule.this.layoutTitle(parent);
            int border = 10;
            y = SobCustomerConfigurationSubModule.this.layoutTitleBar(y, parent.getWidth());
            SobCustomerConfigurationSubModule.this.specs.setLocation(0, y + border);
            SobCustomerConfigurationSubModule.this.specs.setSize((int)((double)parent.getWidth() * 0.3), (parent.getHeight() - (y + border * 3)) / 2);
            SobCustomerConfigurationSubModule.this.ranges.setLocation(SobCustomerConfigurationSubModule.this.specs.getX() + SobCustomerConfigurationSubModule.this.specs.getWidth() + border, SobCustomerConfigurationSubModule.this.specs.getY());
            SobCustomerConfigurationSubModule.this.ranges.setSize(parent.getWidth() - SobCustomerConfigurationSubModule.this.ranges.getX(), (parent.getHeight() - (y + border * 3)) / 2);
            SobCustomerConfigurationSubModule.this.sequenceTable.setLocation(0, SobCustomerConfigurationSubModule.this.ranges.getY() + SobCustomerConfigurationSubModule.this.ranges.getHeight() + border);
            SobCustomerConfigurationSubModule.this.sequenceTable.setSize(210, SobCustomerConfigurationSubModule.this.ranges.getHeight());
            SobCustomerConfigurationSubModule.this.currencyTable.setLocation(SobCustomerConfigurationSubModule.this.sequenceTable.getX() + SobCustomerConfigurationSubModule.this.sequenceTable.getWidth(), SobCustomerConfigurationSubModule.this.ranges.getY() + SobCustomerConfigurationSubModule.this.ranges.getHeight() + border);
            SobCustomerConfigurationSubModule.this.currencyTable.setSize(parent.getWidth() - SobCustomerConfigurationSubModule.this.sequenceTable.getWidth(), SobCustomerConfigurationSubModule.this.ranges.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

