/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.AbstractGalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.BoxInfoButton;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.EditLabelButton;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.JoinBoxButton;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.buttons.SplitBoxButton;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ResizeHandler;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class GalleyBoxEditor
extends AbstractGalleyBoxEditor
implements ButtonListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int currentState = -1;
    private EditLabelButton editLabel;
    private JoinBoxButton join;
    private SplitBoxButton split;
    private BoxInfoButton infoIcon;
    private ResizeHandler northResizer;
    private ResizeHandler eastResizer;
    private ResizeHandler southResizer;
    private ResizeHandler westResizer;
    private boolean isResizerActiv;
    private Point oldPosition;
    private Dimension oldDimension;
    private Point backupPoint;
    private Point backupPosition;
    private Dimension backDimension;
    private Dimension boxOffset;
    private GalleyBox currentBox;
    private boolean isDragging = false;
    private boolean isOver;
    private boolean isSubGalley = false;

    public GalleyBoxEditor(PegasusSubModule peg, boolean isSub) {
        this.pegasus = peg;
        this.isSubGalley = isSub;
        this.getFader().setPermanent(true);
        this.mover = new Mover<GalleyBoxEditor>(this);
        this.resizer = new Resizer<GalleyBoxEditor>(this);
        this.setOpaque(false);
        this.setLayout(new Layouter());
        if (!isSub) {
            this.editLabel = new EditLabelButton();
        } else {
            this.editLabel = new EditLabelButton(SizedSkin1Field.SkinSize.SMALL);
            this.editLabel.addButtonListener(this);
            this.ensureInfoButton(true);
        }
        if (this.editLabel != null) {
            this.editLabel.setVisible(false);
        }
        this.join = new JoinBoxButton();
        this.join.setVisible(false);
        this.split = new SplitBoxButton();
        this.split.setVisible(false);
        this.currentIcon = this.join;
        this.setProgress(0.0f);
        if (this.editLabel != null) {
            this.editLabel.getFader().setPermanent(true);
        }
        this.join.getFader().setPermanent(true);
        this.split.getFader().setPermanent(true);
        if (this.editLabel != null) {
            this.add(this.editLabel);
        }
        this.add(this.join);
        this.add(this.split);
        if (isSub) {
            this.setState(11);
        } else {
            this.setState(3);
        }
    }

    public void ensureInfoButton(boolean show) {
        if (show && this.infoIcon == null) {
            this.infoIcon = new BoxInfoButton(this.isSubGalley ? SizedSkin1Field.SkinSize.SMALL : SizedSkin1Field.SkinSize.MEDIUM);
            this.infoIcon.addButtonListener(this);
            this.infoIcon.getFader().setPermanent(true);
            this.add(this.infoIcon);
        } else if (!show && this.infoIcon != null) {
            this.infoIcon.kill();
            this.infoIcon = null;
        }
    }

    public void setCurrentGalleyBox(GalleyBox box) {
        this.currentBox = box;
        Node n = this.currentBox.getBoxNode();
        Boolean d = false;
        if (n.getChildNamed(new String[]{"labelConfiguration-display"}) != null) {
            d = (Boolean)n.getChildNamed(new String[]{"labelConfiguration-display"}).getValue();
        }
        if (this.editLabel != null) {
            this.editLabel.setVisible(d);
        }
    }

    public void setResizerActiv(boolean isActiv) {
        this.isResizerActiv = isActiv;
        if (this.isResizerActiv) {
            if (this.northResizer == null) {
                this.northResizer = new ResizeHandler(Button.ButtonState.VERTICAL);
                this.northResizer.addMouseListener(this);
                this.northResizer.addMouseMotionListener(this);
                this.add(this.northResizer);
            }
            if (this.eastResizer == null) {
                this.eastResizer = new ResizeHandler(Button.ButtonState.HORIZONTAL);
                this.eastResizer.addMouseListener(this);
                this.eastResizer.addMouseMotionListener(this);
                this.add(this.eastResizer);
            }
            if (this.southResizer == null) {
                this.southResizer = new ResizeHandler(Button.ButtonState.VERTICAL);
                this.southResizer.addMouseListener(this);
                this.southResizer.addMouseMotionListener(this);
                this.add(this.southResizer);
            }
            if (this.westResizer == null) {
                this.westResizer = new ResizeHandler(Button.ButtonState.HORIZONTAL);
                this.westResizer.addMouseListener(this);
                this.westResizer.addMouseMotionListener(this);
                this.add(this.westResizer);
            }
        } else {
            if (this.northResizer != null) {
                this.northResizer.removeMouseListener(this);
                this.northResizer.removeMouseMotionListener(this);
                this.northResizer.kill();
                this.remove(this.northResizer);
                this.northResizer = null;
            }
            if (this.eastResizer != null) {
                this.eastResizer.removeMouseListener(this);
                this.eastResizer.removeMouseMotionListener(this);
                this.eastResizer.kill();
                this.remove(this.eastResizer);
                this.eastResizer = null;
            }
            if (this.southResizer != null) {
                this.southResizer.removeMouseListener(this);
                this.southResizer.removeMouseMotionListener(this);
                this.southResizer.kill();
                this.remove(this.southResizer);
                this.southResizer = null;
            }
            if (this.westResizer != null) {
                this.westResizer.removeMouseListener(this);
                this.westResizer.removeMouseMotionListener(this);
                this.westResizer.kill();
                this.remove(this.westResizer);
                this.westResizer = null;
            }
        }
    }

    @Override
    public int getHalfIconWidth() {
        if (this.isSubGalley) {
            return this.infoIcon.getWidth() / 2;
        }
        if (this.editLabel != null) {
            return this.editLabel.getWidth() / 2;
        }
        if (this.join != null) {
            return this.join.getWidth() / 2;
        }
        if (this.split != null) {
            return this.split.getWidth() / 2;
        }
        return 0;
    }

    @Override
    public int getXOffset() {
        if (this.isSubGalley) {
            return this.infoIcon.getWidth() / 2;
        }
        if (this.currentIcon != null) {
            return this.currentIcon.getWidth() / 2;
        }
        if (this.isResizerActiv) {
            return (int)(this.westResizer.getPreferredSize().getWidth() / 2.0);
        }
        return this.join.getWidth() / 2;
    }

    @Override
    public int getXEndOffset() {
        if (this.isResizerActiv) {
            return (int)(this.eastResizer.getPreferredSize().getHeight() / 2.0);
        }
        return 0;
    }

    @Override
    public int getYOffset() {
        if (this.isSubGalley && this.isResizerActiv) {
            return (int)(this.southResizer.getPreferredSize().getHeight() / 2.0);
        }
        if (this.currentIcon != null) {
            return this.currentIcon.getHeight() / 2;
        }
        return this.join.getHeight() / 2;
    }

    @Override
    public int getYEndOffset() {
        if (this.isSubGalley) {
            return this.infoIcon.getHeight() / 2;
        }
        if (this.isResizerActiv) {
            return (int)(this.southResizer.getPreferredSize().getWidth() / 2.0);
        }
        return 0;
    }

    protected int getDIconHeight() {
        return this.join.getHeight() / 2;
    }

    protected int getDIconWidth() {
        return this.join.getWidth() / 2;
    }

    @Override
    public void setState(int state) {
        if (this.currentIcon != null) {
            this.currentIcon.removeButtonListener(this);
            this.currentIcon.setVisible(false);
        }
        switch (state) {
            case 3: {
                if (this.editLabel != null) {
                    this.currentIcon = this.editLabel;
                    break;
                }
                this.currentIcon = null;
                state = 11;
                break;
            }
            case 5: {
                this.currentIcon = this.join;
                break;
            }
            case 7: {
                this.currentIcon = this.split;
                break;
            }
            case 11: {
                this.currentIcon = null;
            }
        }
        this.currentState = state;
        if (this.currentIcon != null) {
            this.currentIcon.setVisible(true);
            this.currentIcon.addButtonListener(this);
        }
        this.repaint(32L);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.northResizer != null) {
            this.northResizer.kill();
        }
        this.northResizer = null;
        if (this.eastResizer != null) {
            this.eastResizer.kill();
        }
        this.eastResizer = null;
        if (this.southResizer != null) {
            this.southResizer.kill();
        }
        this.southResizer = null;
        if (this.westResizer != null) {
            this.westResizer.kill();
        }
        this.westResizer = null;
        this.currentBox = null;
        if (this.editLabel != null && this.editLabel.getFader() != null) {
            this.editLabel.getFader().setPermanent(false);
        }
        if (this.join.getFader() != null) {
            this.join.getFader().setPermanent(false);
        }
        if (this.split.getFader() != null) {
            this.split.getFader().setPermanent(false);
        }
        if (this.infoIcon != null && this.infoIcon.getFader() != null) {
            this.infoIcon.getFader().setPermanent(false);
        }
        if (this.infoIcon != null) {
            this.infoIcon.kill();
        }
        if (this.editLabel != null) {
            this.editLabel.kill();
        }
        this.join.kill();
        this.split.kill();
        if (this.infoIcon != null) {
            this.infoIcon.removeButtonListener(this);
        }
        if (this.editLabel != null) {
            this.editLabel.removeButtonListener(this);
        }
        this.join.removeButtonListener(this);
        this.split.removeButtonListener(this);
        this.infoIcon = null;
        this.editLabel = null;
        this.join = null;
        this.split = null;
    }

    @Override
    public Mover<?> getMover() {
        return this.mover;
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    @Override
    public Resizer<?> getResizer() {
        return this.resizer;
    }

    @Override
    public void setSizeSmooth(int w, int h) {
        int uw = w;
        int uh = h;
        if (w < this.getHalfIconWidth() * 2) {
            uw = this.getHalfIconWidth() * 2;
        }
        if (h < this.getHalfIconWidth() * 2 + 1) {
            uh = this.getHalfIconWidth() * 2 + 1;
            this.setInnerOffset(1);
        }
        this.resizer.setSizeSmooth(uw, uh);
    }

    @Override
    public void setSize(int w, int h) {
        int uw = w;
        int uh = h;
        if (w < this.getHalfIconWidth() * 2) {
            uw = this.getHalfIconWidth() * 2;
        }
        if (h < this.getHalfIconWidth() * 2 + 1) {
            uh = this.getHalfIconWidth() * 2 + 1;
            this.setInnerOffset(1);
        }
        super.setSize(uw, uh);
    }

    private int parentWidth(Container parent) {
        if (this.currentIcon == null) {
            return parent.getWidth();
        }
        return (int)((double)parent.getWidth() - this.currentIcon.getPreferredSize().getWidth() / 2.0);
    }

    private int parentHeight(Container parent) {
        if (this.currentIcon == null) {
            return parent.getHeight();
        }
        return (int)((double)parent.getHeight() - this.currentIcon.getPreferredSize().getHeight() / 2.0);
    }

    private int xoffset() {
        if (this.infoIcon != null) {
            return this.infoIcon.getWidth() / 2;
        }
        if (this.currentIcon == null) {
            return 0;
        }
        return this.currentIcon.getWidth() / 2;
    }

    private int yoffset() {
        if (this.infoIcon != null) {
            return this.infoIcon.getHeight() / 2;
        }
        if (this.currentIcon == null) {
            return 0;
        }
        return this.currentIcon.getHeight() / 2;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.infoIcon) {
            this.pegasus.showEquipmentConfigPanel(x, y, source);
        } else {
            if (source == this.editLabel) {
                this.pegasus.showLabel(true, this.currentBox != null ? this.currentBox.getBoxNode() : null);
                return;
            }
            switch (this.currentState) {
                case 3: {
                    this.pegasus.showLabel(true, this.currentBox != null ? this.currentBox.getBoxNode() : null);
                    break;
                }
                case 5: {
                    this.pegasus.joinCurrentBox();
                    break;
                }
                case 7: {
                    this.pegasus.splitCurrentBox(x, y, source);
                }
            }
        }
    }

    @Override
    public void setLabelActive(Boolean value) {
        if (this.editLabel != null) {
            if (!value.booleanValue()) {
                this.editLabel.setVisible(false);
            } else {
                this.editLabel.setVisible(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isOver = true;
        if (!this.isDragging) {
            if (e.getSource() == this.northResizer) {
                this.setNewCursor(new Cursor(8));
            } else if (e.getSource() == this.eastResizer) {
                this.setNewCursor(new Cursor(11));
            } else if (e.getSource() == this.southResizer) {
                this.setNewCursor(new Cursor(8));
            } else if (e.getSource() == this.westResizer) {
                this.setNewCursor(new Cursor(11));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isOver = false;
        if (!this.isDragging) {
            this.setNewCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.currentBox == null) {
            return;
        }
        if (e.getSource() == this.northResizer) {
            this.currentBox.setResizeState(1);
        } else if (e.getSource() == this.eastResizer) {
            this.currentBox.setResizeState(3);
        } else if (e.getSource() == this.southResizer) {
            this.currentBox.setResizeState(5);
        } else if (e.getSource() == this.westResizer) {
            this.currentBox.setResizeState(7);
        }
        this.oldPosition = new Point(this.getX(), this.getY());
        this.oldDimension = new Dimension(this.getWidth(), this.getHeight());
        this.boxOffset = new Dimension(this.getWidth() - this.currentBox.getWidth(), this.getHeight() - this.currentBox.getHeight());
        this.backDimension = new Dimension(this.currentBox.getWidth(), this.currentBox.getHeight());
        this.backupPoint = new Point(e.getX(), e.getY());
        this.backupPosition = new Point(this.currentBox.getX(), this.currentBox.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDragging) {
            this.isDragging = false;
            if (this.currentBox != null && this.currentBox.getGalley() != null) {
                if (this.currentBox.getGalley().getGrid() != null && this.currentBox.getGalley().getGrid().isHighLighted()) {
                    this.currentBox.stopResizing();
                    Point p = SwingUtilities.convertPoint(this.currentBox.getParent(), this.currentBox.getLocation(), this.getParent());
                    this.setLocation((int)(p.getX() - (double)this.getXOffset()), (int)(p.getY() - (double)this.getYOffset()));
                    int w1 = this.getXOffset() + this.currentBox.getWidth() + this.getXEndOffset();
                    int h1 = this.getYOffset() + this.currentBox.getHeight() + this.getYEndOffset();
                    this.setSize(w1, h1);
                } else {
                    this.currentBox.stopResizing();
                    this.setLocation(this.oldPosition);
                    this.setSize(this.oldDimension);
                    this.revalidate();
                }
                this.oldDimension = null;
                this.oldPosition = null;
                this.backupPoint = null;
                this.backDimension = null;
                this.backupPosition = null;
                if (!this.isOver) {
                    this.setNewCursor(new Cursor(0));
                }
                this.currentBox.getGalley().highlightGrid(-1, -1);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isDragging) {
            this.isDragging = true;
            this.currentBox.initResizing();
        } else {
            if (this.backupPoint == null) {
                return;
            }
            double dy = this.backupPoint.getY() - (double)e.getY();
            double dx = this.backupPoint.getX() - (double)e.getX();
            if (e.getSource() == this.northResizer) {
                if (this.currentBox.processDragging(this.backDimension, this.backupPoint, this.backupPosition, this.boxOffset, e)) {
                    this.setLocation(this.getX(), (int)((double)this.getY() - dy));
                    this.setSize(this.getWidth(), (int)((double)this.getHeight() + dy));
                }
            } else if (e.getSource() == this.eastResizer) {
                if (this.currentBox.processDragging(new Dimension((int)((double)this.getWidth() - dx - this.boxOffset.getWidth()), (int)this.backDimension.getHeight()), this.backupPoint, this.backupPosition, this.boxOffset, e)) {
                    this.setSize((int)((double)this.getWidth() - dx), this.getHeight());
                }
            } else if (e.getSource() == this.southResizer) {
                if (this.currentBox.processDragging(new Dimension((int)this.backDimension.getWidth(), (int)((double)this.getHeight() - dy - this.boxOffset.getHeight())), this.backupPoint, this.backupPosition, this.boxOffset, e)) {
                    this.setSize(this.getWidth(), (int)((double)this.getHeight() - dy));
                }
            } else if (e.getSource() == this.westResizer && this.currentBox.processDragging(this.backDimension, this.backupPoint, this.backupPosition, this.boxOffset, e)) {
                this.setLocation((int)((double)this.getX() - dx), this.getY());
                this.setSize((int)((double)this.getWidth() + dx), this.getHeight());
            }
            this.getParent().repaint(32L);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void setNewCursor(Cursor c) {
        Container c1 = this;
        while (c1.getParent() != null) {
            c1 = c1.getParent();
        }
        c1.setCursor(c);
    }

    private class Layouter
    extends DefaultLayout {
        private Layouter() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (GalleyBoxEditor.this.currentState == 3) {
                if (GalleyBoxEditor.this.currentIcon != null) {
                    if (GalleyBoxEditor.this.isSplitUse) {
                        if (GalleyBoxEditor.this.isUpperSelect) {
                            GalleyBoxEditor.this.currentIcon.setLocation(0, 0);
                        } else {
                            GalleyBoxEditor.this.currentIcon.setLocation((int)((double)parent.getWidth() - GalleyBoxEditor.this.currentIcon.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - GalleyBoxEditor.this.currentIcon.getPreferredSize().getHeight()));
                        }
                    } else {
                        GalleyBoxEditor.this.currentIcon.setLocation(0, 0);
                    }
                }
            } else {
                if (GalleyBoxEditor.this.currentIcon != null) {
                    GalleyBoxEditor.this.currentIcon.setLocation((int)((double)parent.getWidth() - GalleyBoxEditor.this.currentIcon.getPreferredSize().getWidth()), 0);
                }
                if (GalleyBoxEditor.this.infoIcon != null) {
                    GalleyBoxEditor.this.infoIcon.setLocation(0, parent.getHeight() - GalleyBoxEditor.this.infoIcon.getHeight());
                    GalleyBoxEditor.this.infoIcon.setSize(GalleyBoxEditor.this.infoIcon.getPreferredSize());
                }
            }
            if (GalleyBoxEditor.this.isSubGalley && GalleyBoxEditor.this.isResizerActiv) {
                if (GalleyBoxEditor.this.northResizer != null) {
                    GalleyBoxEditor.this.northResizer.setLocation((int)((double)GalleyBoxEditor.this.parentWidth(parent) - GalleyBoxEditor.this.northResizer.getPreferredSize().getWidth()) / 2, 0);
                    GalleyBoxEditor.this.northResizer.setSize(GalleyBoxEditor.this.northResizer.getPreferredSize());
                }
                if (GalleyBoxEditor.this.eastResizer != null) {
                    GalleyBoxEditor.this.eastResizer.setLocation((int)((double)GalleyBoxEditor.this.parentWidth(parent) - GalleyBoxEditor.this.eastResizer.getPreferredSize().getWidth()), (int)(((double)GalleyBoxEditor.this.parentHeight(parent) - GalleyBoxEditor.this.eastResizer.getPreferredSize().getHeight()) / 2.0));
                    GalleyBoxEditor.this.eastResizer.setSize(GalleyBoxEditor.this.eastResizer.getPreferredSize());
                }
                if (GalleyBoxEditor.this.southResizer != null) {
                    GalleyBoxEditor.this.southResizer.setLocation((int)((double)GalleyBoxEditor.this.parentWidth(parent) - GalleyBoxEditor.this.southResizer.getPreferredSize().getWidth()) / 2, (int)((double)GalleyBoxEditor.this.parentHeight(parent) - ((double)GalleyBoxEditor.this.yoffset() + GalleyBoxEditor.this.southResizer.getPreferredSize().getHeight() / 2.0)));
                    GalleyBoxEditor.this.southResizer.setSize(GalleyBoxEditor.this.southResizer.getPreferredSize());
                }
                if (GalleyBoxEditor.this.westResizer != null) {
                    GalleyBoxEditor.this.westResizer.setLocation((int)((double)GalleyBoxEditor.this.xoffset() - GalleyBoxEditor.this.westResizer.getPreferredSize().getWidth() / 2.0) + 1, (int)(((double)GalleyBoxEditor.this.parentHeight(parent) - GalleyBoxEditor.this.westResizer.getPreferredSize().getHeight()) / 2.0));
                    GalleyBoxEditor.this.westResizer.setSize(GalleyBoxEditor.this.westResizer.getPreferredSize());
                }
            }
            if (GalleyBoxEditor.this.currentIcon != null) {
                GalleyBoxEditor.this.currentIcon.setSize(GalleyBoxEditor.this.currentIcon.getPreferredSize());
            }
            if (GalleyBoxEditor.this.infoIcon != null) {
                GalleyBoxEditor.this.infoIcon.setLocation(0, parent.getHeight() - GalleyBoxEditor.this.infoIcon.getHeight());
                GalleyBoxEditor.this.infoIcon.setSize(GalleyBoxEditor.this.infoIcon.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

