/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.converter.LegListStringConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLegComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.MealPlanToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceSpecificationDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private TitledItem<MultiLegComboBox> leg;
    private TitledItem<SearchComboBox> serviceType;
    private TitledItem<SearchComboBox> cabinClass;
    private final Node<MealPlanLight> mPNode;
    private TitledPeriodEditor validityPeriod;
    private TitledItem<CheckBox> expire;
    private TitledItem<CheckBox> replaceExpired;
    private TextLabel currentCycle;
    private Node<?> currentNode;

    public ServiceSpecificationDetailsPanel(RowEditor<T> editor, Node<MealPlanLight> mealPlanNode) {
        super(editor, null);
        this.mPNode = mealPlanNode;
        this.setTitleText(Words.SPECIFICATION);
        Node n = mealPlanNode.getChildNamed(MealPlanLight_.legs);
        this.leg = new TitledItem(new MultiLegComboBox(n, ConverterRegistry.getConverter(LegListStringConverter2.class)), Words.LEGS, TitledItem.TitledItemOrientation.NORTH);
        this.serviceType = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCateringServiceTypeSearchField(true, null), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.cabinClass = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCabinClassSearchField(true, null), Words.CABIN_CLASS, TitledItem.TitledItemOrientation.NORTH);
        this.validityPeriod = new TitledPeriodEditor(null, null, true, this.provider, "period");
        this.validityPeriod.enableInfinity(false, true);
        this.currentCycle = new TextLabel();
        this.expire = new TitledItem<CheckBox>(new CheckBox(), Words.EXPIRE, TitledItem.TitledItemOrientation.EAST);
        this.replaceExpired = new TitledItem<CheckBox>(new CheckBox(), Words.REPLACE_EXPIRED, TitledItem.TitledItemOrientation.EAST);
        this.leg.setProgress(1.0f);
        this.serviceType.setProgress(1.0f);
        this.cabinClass.setProgress(1.0f);
        this.validityPeriod.setProgress(1.0f);
        this.currentCycle.setProgress(1.0f);
        this.expire.setProgress(1.0f);
        this.replaceExpired.setProgress(1.0f);
        this.setCustomLayouter(new Layout());
        this.addToView(this.leg);
        this.addToView(this.serviceType);
        this.addToView(this.cabinClass);
        this.addToView(this.validityPeriod);
        this.addToView(this.currentCycle);
        this.addToView(this.expire);
        this.addToView(this.replaceExpired);
    }

    private void loadCycleText(Node<?> node) {
        if (node == null) {
            this.currentCycle.setText(Phrase.getPhrase((String)Phrase.CURRENT_CYCLE_IS, (Object[])new Object[]{"-"}));
        } else {
            try {
                Integer cycle = MealPlanToolkit.getCurrentCycle(node, (Timestamp)new Timestamp(System.currentTimeMillis()));
                if (cycle == null) {
                    this.currentCycle.setText(Phrase.getPhrase((String)Phrase.CURRENT_CYCLE_IS, (Object[])new Object[]{"-"}));
                } else {
                    this.currentCycle.setText(Phrase.getPhrase((String)Phrase.CURRENT_CYCLE_IS, (Object[])new Object[]{cycle.toString()}));
                }
            }
            catch (Exception e) {
                this.currentCycle.setText(Phrase.getPhrase((String)Phrase.CURRENT_CYCLE_IS, (Object[])new Object[]{"-"}));
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.leg.kill();
        this.serviceType.kill();
        this.cabinClass.kill();
        this.validityPeriod.kill();
        this.currentCycle.kill();
        this.expire.kill();
        this.replaceExpired.kill();
        this.leg = null;
        this.serviceType = null;
        this.cabinClass = null;
        this.validityPeriod = null;
        this.currentCycle = null;
        this.expire = null;
        this.replaceExpired = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        this.loadCycleText(node);
        if (NodeToolkit.getAffixNamed((String)"plegs") != null) {
            NodeToolkit.removeAffixNamed((String)"plegs");
        }
        Node r = this.mPNode.getChildNamed(MealPlanLight_.legs);
        ViewNode n = new ViewNode("plegs");
        Iterator it = r.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            n.addChild(nn, 0L);
        }
        NodeToolkit.addAffix((Node)n);
        this.leg.getElement().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.legs));
        this.serviceType.getElement().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.type));
        this.cabinClass.getElement().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.cabinClass));
        this.validityPeriod.setStartDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.period, PeriodComplete_.startDate}));
        this.validityPeriod.setEndDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.period, PeriodComplete_.endDate}));
        this.replaceExpired.getElement().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.replaceExpired));
        this.expire.getElement().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.expire));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.leg);
        CheckedListAdder.addToList(a, this.serviceType);
        CheckedListAdder.addToList(a, this.cabinClass);
        CheckedListAdder.addToList(a, this.validityPeriod);
        CheckedListAdder.addToList(a, this.expire);
        CheckedListAdder.addToList(a, this.replaceExpired);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.leg.setEnabled(shouldEnable);
        this.serviceType.setEnabled(shouldEnable);
        this.cabinClass.setEnabled(shouldEnable);
        this.validityPeriod.setEnabled(shouldEnable);
        this.currentCycle.setEnabled(shouldEnable);
        this.expire.setEnabled(isEnabled);
        this.replaceExpired.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (!this.leg.getElement().validateSelection()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please select a Leg before saving."));
        }
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.leg.requestFocusInWindowNow();
    }

    @Override
    public boolean isRemoteValidation() {
        return true;
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
        if (!EjbContextFactory.getInstance().getUseWebServices()) {
            Iterator it = this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.loadingGroups).getFailSafeChildIterator();
            ArrayList<Object> loadingGroups = new ArrayList<Object>();
            while (it.hasNext()) {
                Node next = (Node)it.next();
                next.commitThis(LoadingGroupTemplateComplete.class);
                loadingGroups.add(next.getValue(LoadingGroupTemplateComplete.class));
            }
            this.currentNode.commitThis();
            this.editor.getModel().getNode().commitThis();
            CateringServiceScheduleVariantComplete service = (CateringServiceScheduleVariantComplete)this.currentNode.getValue();
            CateringServiceScheduleComplete schedule = (CateringServiceScheduleComplete)this.editor.getModel().getNode().getValue();
            service.setBase(schedule);
            List warnings = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).validateLoadingGroupConfiguration(schedule, service, new ListWrapper(loadingGroups)).getList();
            warnings.forEach(s -> callBack.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, s)));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ServiceSpecificationDetailsPanel.this.leg.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.verticalBorder);
            ServiceSpecificationDetailsPanel.this.leg.setSize((parent.getWidth() - (2 * ServiceSpecificationDetailsPanel.this.horizontalBorder + ServiceSpecificationDetailsPanel.this.inner_horizontalBorder)) / 2, (int)ServiceSpecificationDetailsPanel.this.leg.getPreferredSize().getHeight());
            ServiceSpecificationDetailsPanel.this.serviceType.setLocation(ServiceSpecificationDetailsPanel.this.leg.getX() + ServiceSpecificationDetailsPanel.this.leg.getWidth() + ServiceSpecificationDetailsPanel.this.inner_horizontalBorder, ServiceSpecificationDetailsPanel.this.verticalBorder);
            ServiceSpecificationDetailsPanel.this.serviceType.setSize(ServiceSpecificationDetailsPanel.this.leg.getWidth(), (int)ServiceSpecificationDetailsPanel.this.serviceType.getPreferredSize().getHeight());
            ServiceSpecificationDetailsPanel.this.cabinClass.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.leg.getY() + ServiceSpecificationDetailsPanel.this.leg.getHeight() + ServiceSpecificationDetailsPanel.this.inner_verticalBorder);
            ServiceSpecificationDetailsPanel.this.cabinClass.setSize(ServiceSpecificationDetailsPanel.this.leg.getWidth(), (int)ServiceSpecificationDetailsPanel.this.cabinClass.getPreferredSize().getHeight());
            ServiceSpecificationDetailsPanel.this.validityPeriod.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.cabinClass.getY() + ServiceSpecificationDetailsPanel.this.cabinClass.getHeight() + ServiceSpecificationDetailsPanel.this.inner_verticalBorder);
            ServiceSpecificationDetailsPanel.this.validityPeriod.setSize(ServiceSpecificationDetailsPanel.this.validityPeriod.getPreferredSize());
            ServiceSpecificationDetailsPanel.this.expire.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.validityPeriod.getY() + ServiceSpecificationDetailsPanel.this.validityPeriod.getHeight() + ServiceSpecificationDetailsPanel.this.verticalBorder);
            ServiceSpecificationDetailsPanel.this.expire.setSize(ServiceSpecificationDetailsPanel.this.expire.getPreferredSize());
            ServiceSpecificationDetailsPanel.this.replaceExpired.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.expire.getY() + ServiceSpecificationDetailsPanel.this.expire.getHeight() + ServiceSpecificationDetailsPanel.this.inner_verticalBorder);
            ServiceSpecificationDetailsPanel.this.replaceExpired.setSize(ServiceSpecificationDetailsPanel.this.replaceExpired.getPreferredSize());
            ServiceSpecificationDetailsPanel.this.currentCycle.setLocation(ServiceSpecificationDetailsPanel.this.horizontalBorder, ServiceSpecificationDetailsPanel.this.replaceExpired.getY() + ServiceSpecificationDetailsPanel.this.replaceExpired.getHeight() + ServiceSpecificationDetailsPanel.this.verticalBorder);
            ServiceSpecificationDetailsPanel.this.currentCycle.setSize(ServiceSpecificationDetailsPanel.this.currentCycle.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ServiceSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.leg.getPreferredSize().getHeight());
            h += ServiceSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.cabinClass.getPreferredSize().getHeight());
            h += ServiceSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.validityPeriod.getPreferredSize().getHeight());
            h += ServiceSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.expire.getPreferredSize().getHeight());
            h += ServiceSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.replaceExpired.getPreferredSize().getHeight());
            h += ServiceSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ServiceSpecificationDetailsPanel.this.currentCycle.getPreferredSize().getHeight());
            return new Dimension(0, h += ServiceSpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

