/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.tableui;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class StorePositionChangePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> department;
    private TitledItem<StorePositionSearchBox> searchBox;

    public StorePositionChangePopupInsert(Node<StorePositionLight> node, TransactionType type, boolean useRestrictions) {
        this(node, null, false, type, useRestrictions);
    }

    public StorePositionChangePopupInsert(Node<StorePositionLight> node, Node<InternalCostCenterComplete> departmentNode, boolean showDepartment, TransactionType type, boolean useRestrictions) {
        if (showDepartment) {
            this.department = new TitledItem<ComboBox>(new ComboBox(departmentNode, NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(DepartmentConverter.class), true, true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.searchBox = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(), Words.STORE_POSITION, TitledItem.TitledItemOrientation.NORTH);
        if ((type == TransactionType.REQUISITION_RECEIVE || type == TransactionType.PURCHASE_RECEIVE) && useRestrictions) {
            this.searchBox.getElement().setStoreFilter(StoreEntryTypeE.IN);
        }
        this.searchBox.getElement().setNode(node);
        this.searchBox.getElement().setFilter(type);
        this.setLayout(new Layout());
        this.add(this.searchBox);
        if (showDepartment) {
            this.add(this.department);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.searchBox.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.department != null) {
            return this.department.isInnerComponent(c);
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.searchBox.kill();
        this.searchBox = null;
        if (this.department != null) {
            this.department.kill();
            this.department = null;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (StorePositionChangePopupInsert.this.department != null) {
                return new Dimension(0, (int)(StorePositionChangePopupInsert.this.searchBox.getPreferredSize().getHeight() + StorePositionChangePopupInsert.this.department.getPreferredSize().getHeight() + 30.0));
            }
            return new Dimension(0, (int)(StorePositionChangePopupInsert.this.searchBox.getPreferredSize().getHeight() + 20.0));
        }

        @Override
        public void layoutContainer(Container parent) {
            StorePositionChangePopupInsert.this.searchBox.setLocation(10, 10);
            StorePositionChangePopupInsert.this.searchBox.setSize(parent.getWidth() - 20, (int)StorePositionChangePopupInsert.this.searchBox.getPreferredSize().getHeight());
            if (StorePositionChangePopupInsert.this.department != null) {
                StorePositionChangePopupInsert.this.department.setLocation(10, StorePositionChangePopupInsert.this.searchBox.getY() + StorePositionChangePopupInsert.this.searchBox.getHeight() + 10);
                StorePositionChangePopupInsert.this.department.setSize(parent.getWidth() - 20, (int)StorePositionChangePopupInsert.this.searchBox.getPreferredSize().getHeight());
            }
        }
    }
}

