/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils;

import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.IInventoryCountImportUtil;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeBatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.search.StoreContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryCountImportUtil {
    private IInventoryCountImportUtil component;
    private List<Tuple<Integer, String>> notOkList = new ArrayList<Tuple<Integer, String>>();
    private boolean chargeBased;
    private final Logger log = LoggerFactory.getLogger(IInventoryCountImportUtil.class);

    public InventoryCountImportUtil(IInventoryCountImportUtil component, boolean chargeBased) {
        this.component = component;
        this.chargeBased = chargeBased;
    }

    /*
     * WARNING - void declaration
     */
    public List<Tuple<Integer, String>> importRows(List<ExcelRow> rows, StoreComplete store) throws ServiceException {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Boolean showStorePosition = settings.getShowStorePositionOnInventoryWorkSheet();
        HashMap unitIndex = new HashMap();
        UnitToolkit.loadUnits();
        ((List)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(UnitComplete.class).getValue()).forEach(unitComplete -> unitIndex.put(unitComplete.getShortName().toLowerCase(), unitComplete));
        HashMap storePositionIndex = new HashMap();
        store.getPositions().forEach(s -> storePositionIndex.put(s.getName(), s));
        ArrayList successList = new ArrayList();
        int maxRow = rows.size();
        int currentRow = 1;
        boolean firstRow = true;
        HashMap<String, Integer> titles = new HashMap<String, Integer>();
        int noIndex = 0;
        int storeIndex = 0;
        int positionIndex = 0;
        int uomIndex = 0;
        int countedIndex = 0;
        int chargeIndex = 0;
        Iterator<ExcelRow> iterator = rows.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            void var26_31;
            UnitComplete unitComplete2;
            Object message;
            boolean doRemove = true;
            ExcelRow row = iterator.next();
            ++j;
            this.component.showLoadingAnimation(currentRow, maxRow);
            ++currentRow;
            if (firstRow) {
                boolean position;
                int i = 0;
                for (Object cell : row.getCells()) {
                    titles.put(cell.toString().toLowerCase(), i);
                    ++i;
                }
                String headerCheckInfo = "";
                if (!showStorePosition.booleanValue()) {
                    position = false;
                    if (titles.containsKey("position")) {
                        headerCheckInfo = this.chargeBased ? "Excel must contain columns 'No', 'Store', 'UoM', 'Charge' and 'Counted' => no store position allowed" : "Excel must contain columns 'No', 'Store', 'UoM' and 'Counted' => no store position allowed";
                        this.component.openErrorDialog(headerCheckInfo);
                        return null;
                    }
                } else {
                    position = true;
                    if (!titles.containsKey("position")) {
                        headerCheckInfo = this.chargeBased ? "Excel must contain columns 'No', 'Store', 'Position', 'UoM', 'Charge' and 'Counted' => Ensure Store Position" : "Excel must contain columns 'No', 'Store', 'Position', 'UoM' and 'Counted' => Ensure Store Position";
                        this.component.openErrorDialog(headerCheckInfo);
                        return null;
                    }
                }
                if (!(titles.containsKey("no") && titles.containsKey("uom") && titles.containsKey("store") && titles.containsKey("counted"))) {
                    headerCheckInfo = this.chargeBased ? "Excel must contain columns 'No', 'Store', 'Position', 'UoM', 'Charge' and 'Counted'" : "Excel must contain columns 'No', 'Store', 'Position', 'UoM' and 'Counted'";
                    this.component.openErrorDialog(headerCheckInfo);
                    return null;
                }
                noIndex = (Integer)titles.get("no");
                storeIndex = (Integer)titles.get("store");
                if (showStorePosition.booleanValue()) {
                    positionIndex = (Integer)titles.get("position");
                }
                uomIndex = (Integer)titles.get("uom");
                countedIndex = (Integer)titles.get("counted");
                if (this.chargeBased) {
                    if (!titles.containsKey("charge")) {
                        this.component.openErrorDialog(headerCheckInfo);
                        return null;
                    }
                    chargeIndex = (Integer)titles.get("charge");
                } else if (titles.containsKey("charge")) {
                    this.component.openErrorDialog(headerCheckInfo);
                    return null;
                }
                firstRow = false;
                continue;
            }
            Integer artNo = ExcelToolkit.readAsInteger((ExcelRow)row, (int)noIndex);
            if (artNo == null) {
                String message2 = "No valid Article Number in row " + j;
                this.addToNotOkList(0, message2);
                row.addCell((Object)message2, new String[0]);
                continue;
            }
            String storeString = ExcelToolkit.readAsString((ExcelRow)row, (int)storeIndex);
            if (storeString == null || !store.getCode().trim().toLowerCase().equals(storeString.trim().toLowerCase())) {
                if (StringUtil.isBlank((String)storeString)) {
                    String message3 = "No store is set";
                    this.addToNotOkList(artNo, message3);
                    row.addCell((Object)message3, new String[0]);
                    continue;
                }
                String message4 = "Wrong Store set [" + storeString + " instead of " + store.getCode() + "]";
                this.addToNotOkList(artNo, message4);
                row.addCell((Object)message4, new String[0]);
                continue;
            }
            String position = "";
            if (showStorePosition.booleanValue()) {
                position = ExcelToolkit.readAsString((ExcelRow)row, (int)positionIndex);
                if (StringUtil.isBlank((String)position)) {
                    message = "No Store Position set";
                    this.addToNotOkList(artNo, (String)message);
                    row.addCell(message, new String[0]);
                    continue;
                }
            } else if (storePositionIndex.size() == 1) {
                for (Map.Entry entry : storePositionIndex.entrySet()) {
                    position = (String)entry.getKey();
                }
            } else {
                message = "Multiple possible Store Positions exist";
                this.addToNotOkList(artNo, (String)message);
                row.addCell(message, new String[0]);
                continue;
            }
            String uom = ExcelToolkit.readAsString((ExcelRow)row, (int)uomIndex);
            Double d = ExcelToolkit.readAsDouble((ExcelRow)row, (int)countedIndex);
            if (d == null) {
                Double d2 = 0.0;
            }
            if ((unitComplete2 = (UnitComplete)unitIndex.get(uom.toLowerCase())) == null) {
                String message5 = "No Unit found (" + uom + ")";
                this.addToNotOkList(artNo, message5);
                row.addCell((Object)message5, new String[0]);
                continue;
            }
            if (this.chargeBased) {
                String chargeNumber = ExcelToolkit.readAsInteger((ExcelRow)row, (int)chargeIndex).toString();
                Integer chargeAsInt = ExcelToolkit.readAsInteger((ExcelRow)row, (int)chargeIndex);
                ArticleChargeBatchSearchConfiguration articleSearch3 = new ArticleChargeBatchSearchConfiguration();
                articleSearch3.setArticleChargeNumber(chargeNumber);
                articleSearch3.setCurrentStore((StoreLight)store);
                articleSearch3.setStorePositionName(position);
                SearchResultIterator sri3 = new SearchResultIterator((ASearchConfiguration)articleSearch3);
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (sri3.hasNext()) {
                    ArticleChargeBatchComplete next = (ArticleChargeBatchComplete)sri3.next();
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(next.getCharge().getBasicArticle().getId())).getValue();
                    if (!UnitCalculator.isUnitInArticlesPackagingTableAtTime((IBasicArticle)artC, (IUnit)unitComplete2, (Timestamp)now)) {
                        String message2 = "Unit " + unitComplete2.getShortName() + " not found in conversion";
                        List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)now);
                        String conversionString = UnitConversionToolkit.formatConversion((List)conversion);
                        this.addToNotOkList(artNo, message2);
                        row.addCell((Object)(message2 + " - Article Conversion: " + conversionString), new String[0]);
                        doRemove = false;
                    }
                    String already_counted = this.component.getDuplicationText();
                    if (!this.component.addToLower(next, new QuantityComplete((Double)var26_31, unitComplete2))) {
                        this.addToNotOkList(artNo, already_counted);
                        row.addCell((Object)already_counted, new String[0]);
                        doRemove = false;
                    }
                } else {
                    ArticleChargeSearchConfiguration chargeSearch = new ArticleChargeSearchConfiguration();
                    chargeSearch.setNumber(chargeAsInt);
                    SearchResultIterator sri4 = new SearchResultIterator((ASearchConfiguration)chargeSearch);
                    if (sri4.hasNext()) {
                        ArticleChargeLight charge = (ArticleChargeLight)sri4.next();
                        ArticleChargeComplete articleCharge = (ArticleChargeComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getArticleCharge(new ArticleChargeReference(charge.getId())).getValue();
                        ArticleChargeBatchComplete batch = new ArticleChargeBatchComplete();
                        batch.setClientOId(Long.valueOf(ADTO.getNextId()));
                        batch.setCharge(articleCharge);
                        batch.getCharge().getBatches().add(batch);
                        for (StorePositionComplete positionComplete : store.getPositions()) {
                            if (!positionComplete.getName().equals(position)) continue;
                            batch.setPosition((StorePositionLight)positionComplete);
                        }
                        String already_counted = this.component.getDuplicationText();
                        if (!this.component.addToLower(batch, new QuantityComplete((Double)var26_31, unitComplete2))) {
                            this.addToNotOkList(artNo, already_counted);
                            row.addCell((Object)already_counted, new String[0]);
                            doRemove = false;
                        }
                    } else {
                        String message6 = "No Charge found for " + chargeNumber + " on " + position;
                        this.addToNotOkList(artNo, message6);
                        row.addCell((Object)message6, new String[0]);
                        doRemove = false;
                    }
                }
            } else {
                BasicArticleSearchConfiguration articleSearch3 = new BasicArticleSearchConfiguration();
                articleSearch3.setSearchType(BasicArticleSearchTypeE.ARTICLE_NUMBER);
                articleSearch3.setNumber(artNo);
                SearchResultIterator sri3 = new SearchResultIterator((ASearchConfiguration)articleSearch3);
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (sri3.hasNext()) {
                    BasicArticleLight next = (BasicArticleLight)sri3.next();
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(next.getId())).getValue();
                    if (!UnitCalculator.isUnitInArticlesPackagingTableAtTime((IBasicArticle)artC, (IUnit)unitComplete2, (Timestamp)now)) {
                        String message7 = "Unit " + unitComplete2.getShortName() + " not found in conversion";
                        List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)now);
                        String conversionString = UnitConversionToolkit.formatConversion((List)conversion);
                        this.addToNotOkList(artNo, message7);
                        row.addCell((Object)(message7 + " - Article Conversion: " + conversionString), new String[0]);
                        continue;
                    }
                }
                StoreContentSearchConfiguration c = new StoreContentSearchConfiguration();
                c.setArticleNumber(artNo);
                c.setStore(new StoreReference(store.getId()));
                c.setStorePositionName(position);
                SearchResult b = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).searchStoreContents(c);
                String already_counted = this.component.getDuplicationText();
                if (!b.getResults().isEmpty()) {
                    for (StorePositionContentComplete storePositionContentComplete : b.getResults()) {
                        if (this.component.addToLower(storePositionContentComplete, new QuantityComplete((Double)var26_31, unitComplete2))) continue;
                        this.addToNotOkList(artNo, already_counted);
                        row.addCell((Object)already_counted, new String[0]);
                        doRemove = false;
                    }
                } else {
                    BasicArticleSearchConfiguration articleSearch = new BasicArticleSearchConfiguration();
                    articleSearch.setSearchType(BasicArticleSearchTypeE.ARTICLE_NUMBER);
                    articleSearch.setNumber(artNo);
                    SearchResultIterator sri2 = new SearchResultIterator((ASearchConfiguration)articleSearch);
                    if (sri2.hasNext()) {
                        BasicArticleLight next = (BasicArticleLight)sri2.next();
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(next.getId())).getValue();
                        InventoryCheckinComplete sccc = new InventoryCheckinComplete();
                        sccc.setCorrectStock(Boolean.valueOf(true));
                        sccc.setClientOId(Long.valueOf(ADTO.getNextId()));
                        QuantityComplete quantityComplete = new QuantityComplete((Double)var26_31, unitComplete2);
                        List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)now);
                        if (!UnitCalculator.isConvertible((IBasicArticle)artC, (IUnit)artC.getBaseUnit(), (List)conversion, (IUnit)unitComplete2, (List)conversion)) {
                            String message8 = "Conversion not valid";
                            this.addToNotOkList(artNo, message8);
                            row.addCell((Object)message8, new String[0]);
                            continue;
                        }
                        StoreQuantityComplete storeQuantity = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)artC, (List)conversion, (IQuantity)quantityComplete);
                        sccc.setAmount(storeQuantity);
                        sccc.setArticle((BasicArticleLight)artC);
                        PriceComplete brutto = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)artC, (Timestamp)now, null, (boolean)false);
                        sccc.setPrice(brutto);
                        sccc.setPriceUnit(artC.getPriceUnit());
                        StorePositionComplete storePositionComplete = (StorePositionComplete)storePositionIndex.get(position);
                        if (storePositionComplete == null) {
                            String message9 = "No Store Position found (" + position + ")";
                            this.addToNotOkList(artNo, message9);
                            row.addCell((Object)message9, new String[0]);
                            continue;
                        }
                        sccc.setStorePosition((StorePositionLight)storePositionComplete);
                        doRemove = this.component.checkForDuplicationsInLower(artNo, sccc);
                        if (!doRemove) {
                            row.addCell((Object)already_counted, new String[0]);
                        }
                    } else {
                        String message10 = "Article not found";
                        this.addToNotOkList(artNo, message10 + " (" + artNo + ")");
                        row.addCell((Object)message10, new String[0]);
                        continue;
                    }
                }
            }
            if (!doRemove) continue;
            row.addCell((Object)"ok", new String[0]);
        }
        return this.notOkList;
    }

    public File createExcelWithErrors(List<ExcelRow> excelRows) throws IOException {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        boolean isFirst = true;
        for (ExcelRow excelRow : excelRows) {
            if (isFirst) {
                excelRow.addCell((Object)Words.MESSAGE, new String[0]);
                isFirst = false;
            }
            rows.add(excelRow);
        }
        File tempFile = File.createTempFile("CATIT_Export", ".xlsx");
        try {
            ExcelToolkit.writeWorkBook((File)tempFile, rows, (String)"Import Summary");
        }
        catch (ExcelToolkitException e) {
            this.log.error("Unable to generate Excel File", (Throwable)e);
        }
        return tempFile;
    }

    private void addToNotOkList(Integer artNo, String message) {
        this.notOkList.add((Tuple<Integer, String>)new Tuple((Object)artNo, (Object)message));
    }
}

