/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.smartaccess.popup;

import ch.icit.pegasus.client.gui.table.smartaccess.popup.SmartScreenAccessPopupInsert;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.SubModuleNameConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.util.DebugToolkit;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class Entry
extends Button
implements ButtonListener {
    private final SmartScreenAccessPopupInsert smartScreenAccessPopupEntry;
    private static final long serialVersionUID = 1L;
    private Skin1Field icon;
    private TextLabel name;
    private final SubModuleNameConverter converter;
    private SubModuleAccessRightComplete object;
    private boolean isClicked = false;

    public Entry(SmartScreenAccessPopupInsert smartScreenAccessPopupInsert, SubModuleAccessRightComplete o, SubModuleNameConverter converter) {
        super(false);
        this.smartScreenAccessPopupEntry = smartScreenAccessPopupInsert;
        this.converter = converter;
        this.name = new TextLabel(this.converter.convert(o));
        DefaultSkins skinClass = HUDToolkit.getSmartScreenButtonIconClassForInvokerName(o.getModule().getInvokingName());
        if (skinClass != null) {
            this.icon = (Skin1Field)skinClass.createDynamicSkin();
        }
        this.object = o;
        this.setLayout(new InnerLayout());
        this.addButtonListener(this);
        this.name.setDelegateComponent(this);
        this.add(this.name);
    }

    @Override
    public Object getUserObject() {
        return this.object;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.icon = null;
        this.name.kill();
        this.name = null;
        this.isClicked = false;
    }

    public SubModuleAccessRightComplete getScreenObject() {
        return this.object;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isClicked) {
            g2.setColor(new Color(0, 0, 0, 60));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            switch (this.state) {
                case OVER: {
                    g2.setColor(new Color(0, 0, 0, 30));
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case DOWN: {
                    g2.setColor(new Color(0, 0, 0, 60));
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case DISABLED: 
                case UP: {
                    break;
                }
                case HORIZONTAL: 
                case LEFT: 
                case RIGHT: 
                case STATE_COLAPSED_OVER: 
                case STATE_COLAPSED_UP: 
                case ERROR: 
                case STATE_EXPANDED: 
                case FOCUS: 
                case STATE_FOCUS_LEFT: 
                case STATE_FOCUS_RIGHT: 
                case STATE_NOTSELECTED: 
                case STATE_SELECTED: 
                case STATE_WARRNING: 
                case VERTICAL: {
                    DebugToolkit.unsupportedStateException(this.getClass(), "unknown", (Object)this.state, "paint");
                }
            }
        }
        if (this.icon != null) {
            if (this.icon instanceof SizedSkin1Field) {
                ((SizedSkin1Field)this.icon).paint(g2, 10, (this.getHeight() - this.icon.getImage(Button.ButtonState.UP).getHeight()) / 2, Button.ButtonState.UP, SizedSkin1Field.SkinSize.SMALL);
            } else {
                this.icon.paint(g2, 10, (this.getHeight() - this.icon.getImage(Button.ButtonState.UP).getHeight()) / 2, Button.ButtonState.UP);
            }
        }
        this.paintChildren(g2);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this) {
            this.isClicked = true;
            this.smartScreenAccessPopupEntry.getInnerPopUp().setBlocking(true);
            this.smartScreenAccessPopupEntry.loadScreen(this.object, x, y, this);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (Entry.this.icon == null) {
                Entry.this.name.setLocation(10, (int)(((double)parent.getHeight() - Entry.this.name.getPreferredSize().getHeight()) / 2.0));
            } else {
                Entry.this.name.setLocation(10 + Entry.this.icon.getImage(Button.ButtonState.UP).getWidth() + 10, (int)(((double)parent.getHeight() - Entry.this.name.getPreferredSize().getHeight()) / 2.0));
            }
            Entry.this.name.setSize(parent.getWidth() - (Entry.this.name.getX() + 10), (int)Entry.this.name.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 30);
        }
    }
}

