/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.filterChain.TableFilterChain;
import ch.icit.pegasus.client.gui.table2.filterChain.TableFilterChainListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TableSearchStateListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanel;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanelListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class PageableTable2
extends Table2
implements TableFilterChainListener,
PaginationPanelListener {
    private static final long serialVersionUID = 1L;
    private ASearchConfiguration<? extends ADTO, ? extends Enum<?>> lastSearch;
    protected PaginationPanel pagination;
    protected HorizontalSeparator sep1;
    private Button footerButton;
    private Button footerButtonSecond;
    private Button footerButtonThird;
    private Button footerButtonFourth;
    private boolean firstSearchDone;
    protected int numberOfShownResults = AttributesConverter.getInteger4String(ApplicationSettingsLoader.getLoader().getAttribute("number_of_shown_results"));
    protected TableFilterChain filterChain;
    private boolean showFilterChain;
    private Integer lastUsedPage = 0;
    private List<TableSearchStateListener> listeners = new ArrayList<TableSearchStateListener>();

    public PageableTable2(String titleText, boolean withFilterChain, boolean hasBackground, boolean hasTitle) {
        super(false, "", hasBackground, hasTitle);
        this.showFilterChain = withFilterChain;
        this.init(withFilterChain);
        this.setTableText(titleText);
    }

    public void addTableSearchStateListener(TableSearchStateListener t) {
        this.listeners.add(t);
    }

    public void notifyTableSearchListeners(boolean start) {
        for (TableSearchStateListener listener : this.listeners) {
            if (listener == null) continue;
            if (start) {
                listener.searchStarted();
                continue;
            }
            listener.searchFinished();
        }
    }

    public PageableTable2(String titleText, boolean withFilterChain) {
        this(titleText, withFilterChain, true, true);
    }

    public PageableTable2(String titleText) {
        this(titleText, false);
    }

    public PageableTable2() {
        super(false, "", false, false);
        this.init(true);
    }

    private void init(boolean withFilterChain) {
        this.setScrollDownOnAdd(false);
        if (withFilterChain) {
            this.filterChain = new TableFilterChain();
            this.filterChain.addTableFilterChainListener(this);
        }
        this.sep1 = new HorizontalSeparator();
        this.pagination = new PaginationPanel();
        this.pagination.setWithBorders(false);
        this.pagination.addPaginationListener(this);
        if (withFilterChain) {
            this.fillFilterChain();
        }
        if (this.filterChain != null) {
            this.add(this.filterChain);
            this.filterChain.fadeInAllComponents();
        }
        this.add(this.pagination);
        this.add(this.sep1);
    }

    public Enum<?> getSortedColumn() {
        int i = ((Table2HeaderPanel)this.headerRow).getSortedColumn();
        if (i == -1) {
            return null;
        }
        TableColumnInfo t = this.model.getColumn(i);
        return t.getColumnAttribute();
    }

    public TableFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.filterChain != null) {
            this.filterChain.setEnabled(isEnabled);
        }
        this.pagination.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.filterChain != null) {
            this.filterChain.kill();
        }
        this.pagination.kill();
        this.sep1.kill();
        this.filterChain = null;
        this.pagination = null;
        this.sep1 = null;
    }

    @Override
    public LayoutManager2 getTableLayouter() {
        return new TableLayout();
    }

    public abstract void fillFilterChain();

    public abstract ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String var1, Object var2);

    public abstract SearchAlgorithm getSearchAlgorithm();

    public String isPageSwitchReady() {
        return null;
    }

    @Override
    public void pageChanged(PaginationPanel source, int currentPage) {
        String msg = this.isPageSwitchReady();
        if (msg == null) {
            this.valueChanged("", "", source);
        } else {
            this.pagination.setCurrentPage(this.lastUsedPage);
            InnerPopupFactory.showErrorDialog("Unable to switch Page", (Component)source);
        }
    }

    @Override
    public void valueChanged(String id, Object value, Component component) {
        ASearchConfiguration<? extends ADTO, ? extends Enum<?>> c = this.filterValueChanged(id, value);
        c.setPageNumber(this.pagination.getCurrentPage() - 1);
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        if (this.getIsSearchToggled()) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (ThreadSafeLoader.isOperationFinished()) {
            boolean goNow = false;
            if (!this.showFilterChain) {
                goNow = true;
            } else if (this.getFilterChain() != null && (this.getFilterChain().getSearchButton() == null || this.getFilterChain().getSearchButton() == component)) {
                goNow = true;
            }
            if (goNow) {
                this.doSearch(c, component);
            }
        } else {
            if (!this.firstSearchDone) {
                return;
            }
            this.lastSearch = c;
        }
    }

    public void invokeDefaultSearch() {
        ASearchConfiguration<? extends ADTO, ? extends Enum<?>> c = this.filterValueChanged(null, null);
        c.setPageNumber(this.lastUsedPage.intValue());
        this.doSearch(c, this);
    }

    public void newResultsFound() {
    }

    private void doSearch(final ASearchConfiguration<? extends ADTO, ? extends Enum<?>> c, final Component source) {
        if (source instanceof SearchTextField) {
            ((SearchTextField)source).startAnimation();
        }
        this.notifyTableSearchListeners(true);
        this.lastUsedPage = c.getPageNumber();
        this.showLoadingAnimation("Search");
        this.revalidate();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ViewNode nn = PageableTable2.this.getSearchAlgorithm().search(c);
                if (nn.getValue() instanceof SearchResult) {
                    final SearchResult res = (SearchResult)nn.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (PageableTable2.this.pagination != null && res != null) {
                                PageableTable2.this.pagination.setMinMaxPages(1, (int)((res.getNumberOfResults() != null ? res.getNumberOfResults() : 1L) / (long)(res.getPageSize() != null ? res.getPageSize() : 1)) + 1);
                                PageableTable2.this.pagination.setCurrentPage((res.getPageNumber() != null ? res.getPageNumber() : 0) + 1);
                            }
                        }
                    });
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PageableTable2.this.firstSearchDone = true;
                        if (PageableTable2.this.getSearchAlgorithm() != null && PageableTable2.this != null && PageableTable2.this.getModel() != null) {
                            if (node.getValue() instanceof SearchResult) {
                                PageableTable2.this.getSearchAlgorithm().mergeValues(PageableTable2.this.getModel().getNode(), ((SearchResult)node.getValue()).getResults());
                            } else {
                                PageableTable2.this.getSearchAlgorithm().mergeValues(PageableTable2.this.getModel().getNode(), (List)node.getValue());
                            }
                            PageableTable2.this.revalidate();
                            if (PageableTable2.this.lastSearch != null) {
                                ASearchConfiguration x = PageableTable2.this.lastSearch;
                                PageableTable2.this.lastSearch = null;
                                PageableTable2.this.doSearch(x, source);
                            } else {
                                if (source instanceof SearchTextField) {
                                    ((SearchTextField)source).stopAnimation();
                                }
                                PageableTable2.this.hideLoadingAnimation();
                                PageableTable2.this.notifyTableSearchListeners(false);
                                PageableTable2.this.newResultsFound();
                            }
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        PageableTable2.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected void searchFinished() {
    }

    public PaginationPanel getPagination() {
        return this.pagination;
    }

    public int getNumberOfResults() {
        return this.numberOfShownResults;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.pagination.isInnerComponent(c)) {
            return true;
        }
        return this.filterChain != null && this.filterChain.isInnerComponent(c);
    }

    public void addFooterButton(Button button) {
        this.footerButton = button;
        this.add(this.footerButton);
    }

    public void addFooterButtonSecond(Button button) {
        this.footerButtonSecond = button;
        this.add(this.footerButtonSecond);
    }

    public void addFooterButtonThird(Button button) {
        this.footerButtonThird = button;
        this.add(this.footerButtonThird);
    }

    public void addFooterButtonFourth(Button getTemplate) {
        this.footerButtonFourth = getTemplate;
        this.add(this.footerButtonFourth);
    }

    private class TableLayout
    extends DefaultLayout {
        private TableLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int currentX = 0;
            int currentY = 0;
            int endAdded = 0;
            PageableTable2.this.layoutTitle(parent);
            if (PageableTable2.this.hasSkin) {
                if (PageableTable2.this.hasTitle) {
                    currentX = 1;
                    endAdded = 1;
                    currentY += PageableTable2.this.getTitleHeight();
                } else {
                    currentX = 2;
                    endAdded = 2;
                    currentY = 2;
                }
            }
            if (PageableTable2.this.filterChain != null) {
                PageableTable2.this.filterChain.setLocation(currentX, currentY);
                PageableTable2.this.filterChain.setSize(parent.getWidth() - 2 * currentX, (int)PageableTable2.this.filterChain.getPreferredSize().getHeight());
                currentY += PageableTable2.this.filterChain.getHeight();
            }
            if (PageableTable2.this.headerRow != null) {
                PageableTable2.this.headerRow.setLocation(currentX, currentY);
                if (PageableTable2.this.headerRow.isPrefSizeSet()) {
                    PageableTable2.this.headerRow.setSize(w - 2 * currentX, (int)PageableTable2.this.headerRow.getPreferredSize().getHeight());
                } else {
                    PageableTable2.this.headerRow.setSize(w - 2 * currentX, PageableTable2.this.headerHeight);
                }
                currentY += PageableTable2.this.headerRow.getHeight();
            }
            if (PageableTable2.this.footerPanel != null) {
                PageableTable2.this.footerPanel.setLocation(0, (int)((double)parent.getHeight() - PageableTable2.this.footerPanel.getPreferredSize().getHeight()));
                PageableTable2.this.footerPanel.setSize(parent.getWidth(), (int)PageableTable2.this.footerPanel.getPreferredSize().getHeight());
                endAdded += PageableTable2.this.footerPanel.getHeight();
            }
            PageableTable2.this.sep1.setLocation(0, (int)((double)parent.getHeight() - (PageableTable2.this.pagination.getPreferredSize().getHeight() + PageableTable2.this.sep1.getPreferredSize().getHeight() + (double)endAdded)));
            PageableTable2.this.sep1.setSize(parent.getWidth(), (int)PageableTable2.this.sep1.getPreferredSize().getHeight());
            PageableTable2.this.pagination.setLocation((int)((double)parent.getWidth() - (PageableTable2.this.pagination.getPreferredSize().getWidth() + (double)currentX)), PageableTable2.this.sep1.getY() + PageableTable2.this.sep1.getHeight());
            PageableTable2.this.pagination.setSize(PageableTable2.this.pagination.getPreferredSize());
            endAdded += PageableTable2.this.pagination.getHeight() + 5;
            if (PageableTable2.this.footerButton != null) {
                PageableTable2.this.footerButton.setLocation((int)((double)PageableTable2.this.pagination.getX() - (PageableTable2.this.footerButton.getPreferredSize().getWidth() + 5.0)), PageableTable2.this.pagination.getY() + 2);
                PageableTable2.this.footerButton.setSize(PageableTable2.this.footerButton.getPreferredSize());
                if (PageableTable2.this.footerButtonSecond != null) {
                    PageableTable2.this.footerButtonSecond.setLocation((int)((double)PageableTable2.this.footerButton.getX() - (PageableTable2.this.footerButtonSecond.getPreferredSize().getWidth() + 5.0)), PageableTable2.this.pagination.getY() + 2);
                    PageableTable2.this.footerButtonSecond.setSize(PageableTable2.this.footerButtonSecond.getPreferredSize());
                    if (PageableTable2.this.footerButtonThird != null) {
                        PageableTable2.this.footerButtonThird.setLocation((int)((double)PageableTable2.this.footerButtonSecond.getX() - (PageableTable2.this.footerButtonThird.getPreferredSize().getWidth() + 5.0)), PageableTable2.this.pagination.getY() + 2);
                        PageableTable2.this.footerButtonThird.setSize(PageableTable2.this.footerButtonThird.getPreferredSize());
                        if (PageableTable2.this.footerButtonFourth != null) {
                            PageableTable2.this.footerButtonFourth.setLocation((int)((double)PageableTable2.this.footerButtonThird.getX() - (PageableTable2.this.footerButtonFourth.getPreferredSize().getWidth() + 5.0)), PageableTable2.this.pagination.getY() + 2);
                            PageableTable2.this.footerButtonFourth.setSize(PageableTable2.this.footerButtonFourth.getPreferredSize());
                        }
                    }
                }
            }
            PageableTable2.this.scrollPane.setLocation(currentX, currentY);
            PageableTable2.this.scrollPane.setSize(w - 2 * currentX, h - (currentY + endAdded));
            if (PageableTable2.this.loadingAnimation != null) {
                PageableTable2.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - PageableTable2.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - PageableTable2.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                PageableTable2.this.loadingAnimation.setSize(PageableTable2.this.loadingAnimation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = null;
            int usedHeight = PageableTable2.this.getDefaultRowHeight();
            if (PageableTable2.this.maxRows != -1 && PageableTable2.this.fixHeight) {
                d = new Dimension(30, PageableTable2.this.maxRows * usedHeight + PageableTable2.this.headerHeight);
            } else {
                int h = 0;
                for (Table2RowPanel p : PageableTable2.this.rows) {
                    h = (int)((double)h + p.getPreferredSize().getHeight());
                    if (!p.isExpanded() || !p.isLayoutInnerChildsSelf()) continue;
                    for (Table2RowPanel p1 : p.getChildren()) {
                        h = (int)((double)h + p1.getPreferredSize().getHeight());
                    }
                }
                if (PageableTable2.this.filterChain != null) {
                    h = (int)((double)h + PageableTable2.this.filterChain.getPreferredSize().getHeight());
                }
                d = new Dimension(30, h + PageableTable2.this.headerHeight + 4);
                if (PageableTable2.this.addButton != null) {
                    d.setSize(30.0, d.getHeight() + PageableTable2.this.addButton.getPreferredSize().getHeight() + (double)(2 * PageableTable2.this.cellPadding));
                }
            }
            return d;
        }
    }
}

