/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table2;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class Table2HeaderPanel
extends Table2RowPanel
implements LafListener {
    private static final long serialVersionUID = 1L;
    protected ArrayList<JComponent> headerValues = new ArrayList();
    public static final int STYLE_DEFAULT = 3;
    public static final int STYLE_WITHOUT_OUTLINE = 5;
    public static final int STYLE_BACK_COLOR = 7;
    private static Color gradient_color_start;
    private static Color gradient_color_end;
    private ToggleSkin1Field sortSkin;
    private int currentSortedColumn = -1;
    private boolean isSortable = true;
    private boolean ignoreLineOverTitle;
    private boolean printLastLine;

    public Table2HeaderPanel(Table2RowModel m, int style, int alignment) {
        super(m);
        this.style = style;
        this.sortSkin = (ToggleSkin1Field)DefaultSkins.TableSortIcon.createDynamicSkin();
        this.setLayout(new TableHeaderPanelLayout());
        this.updateHeaderValues(alignment);
        this.addMouseListener(this);
        this.lafAttributeChanged("All attribues changed");
    }

    public void setIgnoreLineOverTitle(boolean ignoreLineOverTitle) {
        this.ignoreLineOverTitle = ignoreLineOverTitle;
    }

    public void setPrintLastLine(boolean printLastLine) {
        this.printLastLine = printLastLine;
    }

    public void updateHeaderValues(int alignment) {
        for (JComponent l : this.headerValues) {
            if (!(l instanceof Killable)) continue;
            ((Killable)((Object)l)).kill();
        }
        this.headerValues.clear();
        for (int i = 0; i < this.model.getParentModel().getColumnCount(); ++i) {
            String name = this.model.getParentModel().getColumnName(i);
            TextLabel l = new TextLabel(name);
            l.setAlignment(alignment);
            this.headerValues.add(l);
            this.add(l);
            l.setProgress(1.0f);
        }
        this.lafAttributeChanged("All attribues changed");
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (JComponent l : this.headerValues) {
            if (l != c) continue;
            return true;
        }
        return super.isInnerComponent(c);
    }

    public void setSortable(boolean isSortable) {
        this.isSortable = isSortable;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TableColumnInfo t;
        super.mouseClicked(e);
        if (!this.isSortable) {
            return;
        }
        int count = 0;
        int c = -1;
        for (JComponent l : this.headerValues) {
            if (e.getX() > l.getX() - this.getCellPadding() && e.getX() < l.getX() + l.getWidth() + 2 * this.getCellPadding()) {
                c = count;
            }
            ++count;
        }
        if (!(c == -1 || (t = this.model.getParentModel().getColumn(c)).getColumnAttribute() == null && this.model.getParentModel().getTable() instanceof PageableTable2)) {
            this.model.getParentModel().getTable().setSortedColumn(c);
            if (this.model.getParentModel().getTable() instanceof PageableTable2) {
                ((PageableTable2)this.model.getParentModel().getTable()).valueChanged(null, null, null);
            }
        }
    }

    @Override
    public final Object getObject4Column(int column) {
        return null;
    }

    public Table2HeaderPanel(Table2RowModel m, int style) {
        this(m, style, 2);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.style) {
            case 7: {
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, gradient_color_start, 0.0f, this.getHeight(), gradient_color_end, true);
                g2.setPaint(gradient);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            case 3: {
                g2.setColor(this.model.getParentModel().getTable().getLineColor());
                int currentX = 0;
                if (this.ignoreLineOverTitle) {
                    if (this.printLastLine) {
                        g2.drawLine(this.getWidth() - 1, this.getLineStart(), this.getWidth() - 1, this.getHeight());
                    }
                } else {
                    for (int i = 0; i < (!this.printLastLine ? this.model.getParentModel().getColumnCount() - 1 : this.model.getParentModel().getColumnCount()); ++i) {
                        currentX += this.model.getParentModel().getColumnWidth(i);
                        boolean fatLine = false;
                        if (this.model.getParentModel().getTable().getFatLines() != null && this.model.getParentModel().getTable().getFatLines().contains(i)) {
                            fatLine = true;
                            g2.drawLine(currentX + 1, 0, currentX + 1, this.getHeight());
                            g2.drawLine(currentX - 1, 0, currentX - 1, this.getHeight());
                        }
                        g2.drawLine(currentX, fatLine ? 0 : this.getLineStart(), currentX, this.getHeight());
                    }
                }
                if (this.model.getParentModel().getTable().getType() != 3) break;
                g2.drawLine(0, 0, this.getWidth() - 1, 0);
                break;
            }
        }
        if (this.currentSortedColumn != -1) {
            int currentX = 0;
            for (int c = 0; c <= this.currentSortedColumn; ++c) {
                currentX += this.model.getParentModel().getColumnWidth(c);
            }
            this.sortSkin.paint(g2, currentX - (5 + this.sortSkin.getImage(Button.ButtonState.UP).getHeight()), (this.getHeight() - this.sortSkin.getImage(Button.ButtonState.UP).getHeight()) / 2, Button.ButtonState.UP, !this.model.getParentModel().getTable().getIsSearchToggled());
        }
        this.paintChildren(g2);
    }

    public int getLineStart() {
        return 0;
    }

    public void setSortedColumn(int c) {
        this.currentSortedColumn = c;
        this.repaint(32L);
    }

    public int getSortedColumn() {
        return this.currentSortedColumn;
    }

    public void setGradientColors(Color start, Color end) {
        gradient_color_start = start;
        gradient_color_end = end;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void lafAttributeChanged(String att) {
        Font f = null;
        Color ff = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground"));
        f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_table_header_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        this.setGradientColors(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_header_background_gradient_color_start")), AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_header_background_gradient_color_end")));
        for (JComponent l : this.headerValues) {
            l.setFont(f);
            l.setForeground(ff);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (JComponent l : this.headerValues) {
            l.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (JComponent l : this.headerValues) {
            if (l instanceof Killable) {
                ((Killable)((Object)l)).kill();
            }
            Object var2_2 = null;
        }
        this.headerValues.clear();
    }

    private class TableHeaderPanelLayout
    extends DefaultLayout {
        private TableHeaderPanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentIndex = 0;
            int currentWidth = 0;
            int h = parent.getHeight();
            for (JComponent l : Table2HeaderPanel.this.headerValues) {
                int w = Table2HeaderPanel.this.model.getParentModel().getColumnWidth(currentIndex);
                l.setLocation(currentWidth + Table2HeaderPanel.this.getCellPadding(), (int)(((double)h - l.getPreferredSize().getHeight()) / 2.0));
                l.setSize(w - (Table2HeaderPanel.this.getCellPadding() + Table2HeaderPanel.this.getCellPadding()), (int)l.getPreferredSize().getHeight());
                currentWidth += w;
                ++currentIndex;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

