/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.panels.DarkenPanel;
import ch.icit.pegasus.client.gui.utils.popup.PopupContainer;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class MainFrameContentPanel
extends JPanel
implements PopupContainer,
LafListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private boolean isLogin = true;
    private static BufferedImage imageCat;
    private static BufferedImage imageICIT;
    private boolean isDragging = false;
    private boolean isDraggAllowed = false;
    private Dimension minDimension = new Dimension(1024, 768);
    private MainFrame frameRef;
    private Point dragBackup;
    private Dimension backDimension;
    private DarkenPanel disablePanel;

    public MainFrameContentPanel(MainFrame frameRef) {
        this.frameRef = frameRef;
        this.lafAttributeChanged("All attribues changed");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isLogin) {
            Color c1 = new Color(62, 61, 64);
            Color c2 = new Color(100, 101, 103);
            Paint op = g2.getPaint();
            GradientPaint p = new GradientPaint(0.0f, 0.0f, c1, 0.0f, this.getHeight(), c2);
            g2.setPaint(p);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setPaint(op);
            if (imageCat != null) {
                g2.drawImage(imageCat, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, this.getHeight() - imageCat.getHeight()), null);
            }
            if (imageICIT != null) {
                g2.drawImage(imageICIT, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 322.0f, 82.0f), null);
            }
        } else {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        DrawToolkit.drawResizeCorner(g2, this, 0, 0);
        this.paintChildren(g2);
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    @Override
    public void lafAttributeChanged(String att) {
        if (imageCat == null) {
            imageCat = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("login_cat_logo"));
            imageICIT = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("login_icit_logo"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getX() > this.getWidth() - 18 && e.getX() < this.getWidth() && e.getY() > this.getHeight() - 18 && e.getY() < this.getHeight()) {
            if (this.dragBackup == null) {
                this.dragBackup = new Point();
            }
            this.dragBackup.setLocation(e.getX(), e.getY());
            if (this.backDimension == null) {
                this.backDimension = new Dimension();
            }
            this.backDimension.setSize(this.frameRef.getWidth(), this.frameRef.getHeight());
            this.isDraggAllowed = true;
        } else {
            this.isDraggAllowed = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
    }

    public boolean isIntersectingResizeHandler(int x, int y) {
        return x > this.getWidth() - 18 && y > this.getHeight() - 18;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isDraggAllowed) {
            return;
        }
        if (!this.isDragging) {
            this.isDragging = true;
            return;
        }
        double dw = this.dragBackup.getX() - (double)e.getX();
        double dh = this.dragBackup.getY() - (double)e.getY();
        int nw = (int)(this.backDimension.getWidth() - dw);
        int nh = (int)(this.backDimension.getHeight() - dh);
        if ((double)nw < this.minDimension.getWidth()) {
            nw = (int)this.minDimension.getWidth();
        }
        if ((double)nh < this.minDimension.getHeight()) {
            nh = (int)this.minDimension.getHeight();
        }
        this.frameRef.setSize(nw, nh);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void hideShadow() {
        if (this.disablePanel != null) {
            this.remove(this.disablePanel);
            this.disablePanel.fadeOut(true);
            this.disablePanel = null;
        }
    }

    @Override
    public void showShadow() {
        if (this.disablePanel == null) {
            this.disablePanel = new DarkenPanel();
            this.disablePanel.setLocation(0, 0);
            this.disablePanel.setSize(this.getWidth(), this.getHeight());
            this.add((Component)this.disablePanel, 0);
            this.disablePanel.fadeIn();
        }
    }
}

