/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectionManager {
    public static final int SELECTION_TYPE_FIRST = 3;
    public static final int SELECTION_TYPE_SECOND = 5;
    public static final int SELECTION_TYPE_NONE = 7;
    private List<Selectable> secondSelections = new ArrayList<Selectable>();
    private Selectable currentSelection;
    private static SelectionManager singleton;

    private SelectionManager() {
    }

    public static SelectionManager getSelectionManager() {
        if (singleton == null) {
            singleton = new SelectionManager();
        }
        return singleton;
    }

    public void focusGained(Component focusComponent) {
        Selectable s;
        if (focusComponent instanceof Selectable) {
            this.doSelection((Selectable)((Object)focusComponent));
            Component c = ((Selectable)((Object)focusComponent)).getFocusDelegationComponent();
            if (c != null) {
                c.requestFocusInWindow();
            }
        } else if (focusComponent instanceof Focusable && (s = ((Focusable)((Object)focusComponent)).getSelectDelegationComponent()) != null) {
            this.doSelection(s);
        }
    }

    private void doSelection(Selectable focusComponent) {
        if (focusComponent.isSelectable()) {
            if (this.currentSelection != null && focusComponent != this.currentSelection) {
                this.secondSelections.add(this.currentSelection);
            }
            if (focusComponent instanceof Table2RowPanel) {
                Table2RowPanel row = (Table2RowPanel)focusComponent;
                Iterator<Selectable> it = this.secondSelections.iterator();
                while (it.hasNext()) {
                    Table2RowPanel p;
                    Selectable s = it.next();
                    if (!(s instanceof Table2RowPanel) || (p = (Table2RowPanel)s).getModel() == null || p.getModel().getParentModel() == null || p.getModel().getParentModel().getTable() == null || row.getModel() == null || row.getModel().getParentModel() == null || row.getModel().getParentModel().getTable() == null) continue;
                    if (p.getModel().getParentModel().getTable() == row.getModel().getParentModel().getTable()) {
                        p.setSelected(7);
                        it.remove();
                        continue;
                    }
                    p.setSelected(5);
                }
            }
            if (focusComponent.isSelected() != 3) {
                focusComponent.setSelected(3);
            }
            this.currentSelection = focusComponent;
        }
    }
}

