/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.Skin3FieldButton_NEW;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public class TextButton
extends Skin3FieldButton_NEW
implements LafListener,
AttributeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected BUTTON_TYPES currentType = BUTTON_TYPES.OK;
    protected int textPosX;
    protected int textWidth;
    protected Font font;
    protected Color foregroundColor;
    protected Color disabledForegroundColor;
    protected int minimalWidth = 10;
    protected int default_horizontal_border;

    public TextButton() {
        this("");
    }

    public TextButton(DefaultSkins skin) {
        this(skin, "");
    }

    public TextButton(String text) {
        this(text, true);
    }

    public TextButton(DefaultSkins skin, String text) {
        this(skin, text, true);
    }

    public TextButton(String text, boolean focusable) {
        this(DefaultSkins.TextButtonTexture, text, focusable);
    }

    public TextButton(DefaultSkins skin, String text, boolean focusable) {
        super(skin, focusable);
        this.setText(text);
        this.init();
    }

    public TextButton(BUTTON_TYPES i) {
        this();
        this.changeType(i);
    }

    public TextButton(DefaultSkins skin, BUTTON_TYPES i) {
        this(skin);
        this.changeType(i);
    }

    public void changeType(BUTTON_TYPES i) {
        switch (i) {
            case ADD: {
                this.setText(Words.ADD);
                break;
            }
            case CANCEL: {
                this.setText(Words.CANCEL);
                break;
            }
            case CLEAR: {
                this.setText(Words.CLEAR);
                break;
            }
            case CLOSE: {
                this.setText(Words.CLOSE);
                break;
            }
            case OK: {
                this.setText(Words.OK);
                break;
            }
            case QUIT: {
                this.setText(Words.QUIT);
                break;
            }
            case SAVE: {
                this.setText(Words.SAVE);
            }
        }
        this.currentType = i;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.text = null;
        this.font = null;
        this.foregroundColor = null;
    }

    public void setMinimalWidth(int width) {
        if (width > 0) {
            this.minimalWidth = width;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    protected void init() {
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.addButtonListener(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.calculateTextPosX();
        this.repaint(32L);
    }

    protected void calculateTextPosX() {
        if (this.text != null && this.font != null) {
            FontMetrics fm = this.getFontMetrics(this.font);
            this.textWidth = fm.stringWidth(this.text);
            this.textPosX = (this.getWidth() - this.textWidth) / 2;
        }
    }

    @Override
    public void setSize(Dimension size) {
        this.setSize((int)size.getWidth(), (int)size.getHeight());
    }

    public void superSetSizeDelegate(int w, int h) {
        super.setSize(w, h);
    }

    @Override
    public void setSize(int w, int h) {
        int nh;
        int nw = w;
        if (nw < this.minimalWidth) {
            nw = this.minimalWidth;
        }
        if ((nh = h) < ((Skin3Field)this.getSkin()).getImageLeft(this.state).getHeight()) {
            nh = ((Skin3Field)this.getSkin()).getImageLeft(this.state).getHeight();
        }
        super.setSize(nw, nh);
        this.calculateTextPosX();
    }

    @Override
    public Dimension getPreferredSize() {
        int nw = this.default_horizontal_border * 2 + this.textWidth;
        if (nw < this.minimalWidth) {
            nw = this.minimalWidth;
        }
        if (this.getSkin() != null) {
            return new Dimension(nw, ((Skin3Field)this.getSkin()).getImageLeft(this.state).getHeight());
        }
        return new Dimension(nw, 15);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        ((Skin3Field)this.getSkin()).paint(g2, 0, 0, this.getWidth(), this.state);
        g2.setFont(this.font);
        if (this.state == Button.ButtonState.DISABLED) {
            g2.setColor(this.disabledForegroundColor);
        } else {
            g2.setColor(this.foregroundColor);
        }
        g2.drawString(this.text, this.textPosX, (this.getHeight() + this.font.getSize()) / 2 - 1);
    }

    @Override
    public void setForeground(Color forecolor1) {
        this.foregroundColor = forecolor1;
    }

    public void setBold() {
        this.setFont(this.font.deriveFont(1));
    }

    public void setItalic() {
        this.setFont(this.font.deriveFont(2));
    }

    public void setUnderlined() {
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.setFont(this.font.deriveFont(fontAttributes));
    }

    @Override
    public void setFont(Font font1) {
        this.font = font1;
        this.calculateTextPosX();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.foregroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("button_default_foreground_color"));
        this.disabledForegroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        this.loadFont();
    }

    protected void loadFont() {
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("button_default_font_size"), LafLoader.getLafLoader().getAttribute("button_default_font_type")));
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.default_horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("button_default_inner_horizontal_border"));
            this.minimalWidth = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("button_minimal_width"));
        }
    }

    public void setValid() {
        if (this.state != Button.ButtonState.DISABLED) {
            this.changeState(Button.ButtonState.UP);
        }
    }

    public void setInvalid() {
        if (this.state != Button.ButtonState.DISABLED) {
            this.changeState(Button.ButtonState.ERROR);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.state == Button.ButtonState.ERROR) {
            this.changeState(Button.ButtonState.DOWN);
        }
    }

    @Override
    public String toString() {
        return "TextButton[" + this.getSize() + "] Name is " + this.getText();
    }

    public static enum BUTTON_TYPES {
        OK(3),
        CANCEL(5),
        SAVE(7),
        QUIT(9),
        ADD(11),
        CLOSE(13),
        CLEAR(17);

        int i = 0;

        private BUTTON_TYPES(int t) {
            this.i = t;
        }

        public int getType() {
            return this.i;
        }
    }
}

