/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.filterchain;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.enums.DeleteStateE;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.ScheduledFadeIn;
import ch.icit.pegasus.client.gui.utils.animators.ScheduledFadeInListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDayTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainListener;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.layout.simple.FilterChainLayout;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepper;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepperListener;
import ch.icit.pegasus.client.gui.utils.panels.AnimationPanel;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.panels.HorizontalCombinedView;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.gui.utils.searchfield.NumberSearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.LoadingStateComponent;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain
extends BackgroundedContainer
implements DocumentListener,
ItemListener,
ButtonListener,
AttributeListener,
MouseListener,
AnimationContainer,
LoadingStateComponent,
ScheduledFadeInListener,
NodeListener,
NumericStepperListener,
LafListener,
DateChooserListener,
DateTimeChooserListener,
SearchTextFieldListener,
SearchTextField2Listener,
TitledPeriodListener,
StorePositionSearchBoxListener,
MutableFocusContainer,
MutableFocusContainerListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FilterChain.class);
    private List<FilterChainListener> listeners = new ArrayList<FilterChainListener>();
    private List<Component> components = new ArrayList<Component>();
    private final List<MutableFocusContainerListener> focusCycleListener = new ArrayList<MutableFocusContainerListener>();
    private AnimationPanel animationPanel;
    private boolean isErrorMessage;
    private TextButton resetButton;
    private Rectangle separator;
    private boolean isAnimating = false;
    private LoadingStateComponent nextLoader;
    private ScheduledFadeIn scheduledFader;
    private Color defaultSeparatorColor;
    private boolean isBlind;
    private CustomFocusCyclePolicy focusPolicy;
    private final Class<?> usingClazz;
    private boolean isKilled;
    private boolean isLoading;

    public FilterChain(Class<?> clazz) {
        this.usingClazz = clazz;
        this.addMouseListener(this);
        this.setFocusable(true);
        this.scheduledFader = new ScheduledFadeIn();
        this.scheduledFader.addScheduledFadeInListener(this);
        this.setName("filterChain");
        this.setLayout(new FilterChainLayout());
        this.getFilterChainLayout().setComponents(this.components);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
    }

    public FilterChainLayout getFilterChainLayout() {
        return (FilterChainLayout)this.getLayout();
    }

    public void setDefaultComboWidth(int w) {
        this.getFilterChainLayout().setDefaultComboBoxWidth(w);
    }

    public void setSearchTextField2Width(int w) {
        this.getFilterChainLayout().setDefaultSearchTextField2Width(w);
    }

    public void setNextLoader(LoadingStateComponent l) {
        this.nextLoader = l;
    }

    public void setErrorMessage() {
        this.isErrorMessage = true;
    }

    public boolean isBlind() {
        return this.isBlind;
    }

    public void setBlind(boolean isBlind) {
        this.isBlind = isBlind;
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        super.kill();
        this.listeners.clear();
        this.listeners = null;
        if (this.animationPanel != null) {
            this.animationPanel.kill();
            this.animationPanel = null;
        }
        if (this.resetButton != null) {
            this.resetButton.kill();
            this.resetButton = null;
        }
        if (this.separator != null) {
            this.separator = null;
        }
        if (this.nextLoader != null) {
            this.nextLoader = null;
        }
        if (this.scheduledFader != null) {
            this.scheduledFader.kill();
            this.scheduledFader = null;
        }
        if (this.focusPolicy != null) {
            this.focusPolicy.kill();
        }
        for (Component c : this.components) {
            boolean unable = false;
            if (c instanceof Killable) {
                ((Killable)((Object)c)).kill();
            } else {
                logger.debug("Found class which is not killable: " + c.getClass().getName());
                if (c instanceof TitledPeriodEditor) {
                    ((TitledPeriodEditor)c).getStartDateChooser().getNode().removeNodeListener((NodeListener)this);
                    ((TitledPeriodEditor)c).getEndDateChooser().getNode().removeNodeListener((NodeListener)this);
                }
                try {
                    Method killM = c.getClass().getDeclaredMethod("kill", new Class[0]);
                    killM.invoke((Object)c, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    unable = true;
                }
            }
            if (!unable) continue;
            logger.warn("Unable to kill FilterChain Component " + c.getClass().getName());
        }
        this.components.clear();
        this.components = null;
        this.defaultSeparatorColor = null;
        this.focusCycleListener.clear();
        this.separator = null;
        this.nextLoader = null;
        this.scheduledFader = null;
        this.focusPolicy = null;
    }

    @Override
    public void activateDataLoadingAnimation(String t, Integer a, Integer b) {
        this.animationPanel = new AnimationPanel();
        this.isAnimating = true;
        this.setEnabled(false);
        this.add((Component)this.animationPanel, 0);
        this.animationPanel.fadeIn();
        this.getFilterChainLayout().setAnimationPanel(this.animationPanel);
        this.validate();
    }

    @Override
    public void deactivateDataLoadingAnimation() {
        if (this.animationPanel != null && this.animationPanel.getFader() != null) {
            this.animationPanel.getFader().setAnimationContainer(this);
            this.animationPanel.fadeOut(true);
        }
        if (!this.isErrorMessage) {
            for (Component c : this.components) {
                if (!(c instanceof Fadable)) continue;
                this.scheduledFader.addItem((Fadable)((Object)c));
            }
            if (this.resetButton != null) {
                this.scheduledFader.addItem(this.resetButton);
            }
            this.scheduledFader.startFadeIn();
        }
    }

    public void addResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new TextButton(Words.RESET);
            this.getFilterChainLayout().setResetButton(this.resetButton);
        }
        this.separator = new Rectangle();
        this.getFilterChainLayout().setSeparator(this.separator);
        this.resetButton.addButtonListener(this);
        this.resetButton.setProgress(0.0f);
        this.add(this.resetButton);
        this.validate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (Component com : this.components) {
            com.setEnabled(isEnabled);
        }
        if (this.resetButton != null) {
            this.resetButton.setEnabled(isEnabled);
        }
        this.createFocusCycle();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.separator != null && !this.isAnimating) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.defaultSeparatorColor);
            g2.fill(this.separator);
        }
    }

    public void addSelectionComboBox(ComboBox box, String id, String title, Object defaultIndex) {
        this.addSelectionComboBox(box, this.getFilterChainLayout().getDefaultComboBoxWidth(), id, title, defaultIndex);
    }

    public void addSelectionComboBox(ComboBox box, int width, String id, String title, Object defaultIndex) {
        this.addSelectionComboBox(box, width, id, title, defaultIndex, true);
    }

    public void addSelectionComboBox(ComboBox box, String id, String title, Object defaultIndex, boolean shouldListen) {
        this.addSelectionComboBox(box, this.getFilterChainLayout().getDefaultComboBoxWidth(), id, title, defaultIndex, true);
    }

    public void addSelectionComboBox(ComboBox box, int width, String id, String title, Object defaultIndex, boolean shouldListen) {
        box.setID(id);
        box.setName(title);
        box.setDefaultIndex(defaultIndex);
        box.setProgress(1.0f);
        TitledItem<ComboBox> item = new TitledItem<ComboBox>(box, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        this.getFilterChainLayout().addWidthConstraint(item, width);
        item.setProgress(0.0f);
        this.add(item);
        if (shouldListen) {
            box.addItemListener(this);
        }
        this.validate();
    }

    public void addMultiSelection(MultiSelectionPanel<?> box, String id, String title) {
        box.setID(id);
        box.setName(title);
        box.setProgress(1.0f);
        TitledItem item = new TitledItem(box, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        box.addFocusCycleChangeListener(this);
        box.addItemListener(this);
        this.validate();
    }

    public void addCheckBox(String id, String title, boolean selected) {
        TitledItem<CheckBox> box = new TitledItem<CheckBox>(new CheckBox(), WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.EAST);
        box.getElement().setName(title);
        box.getElement().setID(id);
        box.getElement().setChecked(selected);
        box.getElement().setDefaultValue(selected);
        box.setInnerGap(5);
        box.setTitleFont(this.getFont());
        this.components.add(box);
        box.setProgress(0.0f);
        this.add(box);
        box.getElement().addButtonListener(this);
    }

    public void addCheckBox(String id, String title, String innerTitle, boolean selected) {
        HorizontalCombinedView h = new HorizontalCombinedView(new CheckBox(), new TextLabel(innerTitle));
        TitledItem<HorizontalCombinedView> box = new TitledItem<HorizontalCombinedView>(h, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        box.getElement().setName(title);
        ((CheckBox)box.getElement().getInnerComponent(0)).setID(id);
        h.setFixComp(0);
        h.setHorizontalBorder(5);
        box.setInnerGap(-2);
        box.setTitleFont(this.getFont());
        this.components.add(box);
        box.setProgress(0.0f);
        this.add(box);
        ((CheckBox)box.getElement().getInnerComponent(0)).addButtonListener(this);
    }

    public void addNumericStepper(String id, String title, Integer minValue, Integer maxValue, Integer defaultValue) {
        TitledItem<NumericStepper> stepper = new TitledItem<NumericStepper>(new NumericStepper(3), WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        stepper.getElement().setMinValue(minValue.intValue());
        stepper.getElement().setMaxValue(maxValue.intValue());
        stepper.getElement().setcId(id);
        stepper.getElement().setDefaultV(defaultValue);
        stepper.setProgress(0.0f);
        stepper.getElement().setInputNr(defaultValue);
        stepper.getElement().addNumericStepperListener(this);
        stepper.setTitleFont(this.getFont());
        stepper.setInnerGap(-2);
        this.components.add(stepper);
        this.add(stepper);
        this.validate();
    }

    public UIStateLoadable addDateSelection(String id, String title, java.sql.Date startDate) {
        ViewNode sD = new ViewNode("startDate");
        sD.setValue((Object)startDate, 0L);
        DateChooser a = new DateChooser((Node)sD);
        a.setCId(id);
        a.setDefaultDate(new java.sql.Date(startDate.getTime()));
        TitledItem<DateChooser> chooser = new TitledItem<DateChooser>(a, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        chooser.setInnerGap(-4);
        chooser.getElement().addDateChooserListener(this);
        this.components.add(chooser);
        chooser.setProgress(0.0f);
        this.add(chooser);
        this.validate();
        return chooser.getElement();
    }

    public DateTimeChooser addDateTimeSelection(String id, String title, java.sql.Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)ts, false, false);
        DateTimeChooser a = new DateTimeChooser((Node<Timestamp>)node);
        TitledItem<DateTimeChooser> chooser = new TitledItem<DateTimeChooser>(a, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        chooser.setInnerGap(-4);
        a.setCId(id);
        chooser.getElement().addDateTimeChooserListener(this);
        this.components.add(chooser);
        chooser.setProgress(0.0f);
        this.add(chooser);
        this.validate();
        return chooser.getElement();
    }

    public void addDeleteFilter(String filterDelete) {
        ComboBox box = ComboBoxFactory.getDeletedComboBox(true);
        this.addSelectionComboBox(box, 100, filterDelete, Words.DELETED_STATE, DeleteStateE.NOT_DELETED, true);
    }

    public TitledDayTimePeriodChooser addTimePeriodSelection(String id, String title, Time startTime, Time endTime) {
        Node sD = new Node();
        sD.setName("startTime");
        sD.setValue((Object)startTime, 0L);
        Node eD = new Node();
        eD.setName("endTime");
        eD.setValue((Object)endTime, 0L);
        TitledItem<TitledDayTimePeriodChooser> edit = new TitledItem<TitledDayTimePeriodChooser>(new TitledDayTimePeriodChooser((Node<java.sql.Date>)sD, (Node<java.sql.Date>)eD, "", WordsToolkit.toUpperCase((String)title), false), WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        edit.getElement().setId(id);
        sD.addNodeListener((NodeListener)this);
        eD.addNodeListener((NodeListener)this);
        edit.setTitleFont(this.getFont());
        edit.setInnerGap(-2);
        this.components.add(edit);
        edit.setProgress(0.0f);
        this.add(edit);
        this.validate();
        return edit.getElement();
    }

    public TitledPeriodEditor addPeriodSelection(String id, Date startDate, Date endDate, String title, boolean useDefaultTitle) {
        ViewNode sD = new ViewNode("startDate");
        sD.setValue((Object)startDate, 0L);
        ViewNode eD = new ViewNode("endDate");
        eD.setValue((Object)endDate, 0L);
        sD.addNodeListener((NodeListener)this);
        eD.addNodeListener((NodeListener)this);
        JPanelFadable edit = null;
        if (useDefaultTitle) {
            edit = new TitledPeriodEditor((Node<java.sql.Date>)sD, (Node<java.sql.Date>)eD, useDefaultTitle, null);
            ((TitledPeriodEditor)edit).setFilterChain(true);
            ((TitledPeriodEditor)edit).setId(id);
            ((TitledPeriodEditor)edit).setTitleFont(this.getFont());
            ((TitledPeriodEditor)edit).setTitleText(WordsToolkit.toUpperCase((String)Words.PERIOD_START), WordsToolkit.toUpperCase((String)Words.PERIOD_TO));
            ((TitledPeriodEditor)edit).getStartDateTitledItem().setInnerGap(-2);
            ((TitledPeriodEditor)edit).getEndDateTitledItem().setInnerGap(-2);
            ((TitledPeriodEditor)edit).setProgress(0.0f);
            ((TitledPeriodEditor)edit).addTitledPeriodListener(this);
            ((TitledPeriodEditor)edit).addFocusCycleChangeListener(this);
        } else {
            edit = new TitledItem<TitledPeriodEditor>(new TitledPeriodEditor((Node<java.sql.Date>)sD, (Node<java.sql.Date>)eD, false, null), WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).setFilterChain(true);
            ((TitledItem)edit).setTitleFont(this.getFont());
            ((TitledItem)edit).setInnerGap(-4);
            ((TitledItem)edit).setProgress(0.0f);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).setId(id);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).addTitledPeriodListener(this);
            ((TitledPeriodEditor)((TitledItem)edit).getElement()).addFocusCycleChangeListener(this);
        }
        this.components.add(edit);
        this.add(edit);
        this.validate();
        if (useDefaultTitle) {
            return (TitledPeriodEditor)edit;
        }
        return (TitledPeriodEditor)((TitledItem)edit).getElement();
    }

    public void addStore_StorePositionSearchField(String id) {
        StorePositionSearchBox s = new StorePositionSearchBox(true, null);
        s.setNode((Node<StorePositionLight>)new DTOProxyNode());
        s.setInnerId(id);
        s.setID(id);
        s.setName("STORE POSITION");
        TitledItem<StorePositionSearchBox> item = new TitledItem<StorePositionSearchBox>(s, WordsToolkit.toUpperCase((String)Words.STORE_POSITION), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        s.addSearchListener(this);
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        this.validate();
    }

    public void addSearchField(String id, String title, String defaultText) {
        SearchTextField searchField = new SearchTextField();
        searchField.setID(id);
        searchField.setName(title);
        searchField.setDefaultText(defaultText);
        searchField.addDocumentListener(this);
        TitledItem<SearchTextField> item = new TitledItem<SearchTextField>(searchField, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        this.validate();
    }

    public void addConfigurableSearchField(String id, String title, String defaultText, MiniComboBox combo) {
        ConfigurableSearchTextField configSearchField = new ConfigurableSearchTextField();
        configSearchField.setUseUpperCase(true);
        configSearchField.setMiniComboBox(combo);
        configSearchField.setID(id);
        configSearchField.setName(title);
        configSearchField.setDefaultText(defaultText);
        configSearchField.addSearchTextFieldListener(this);
        TitledItem<ConfigurableSearchTextField> item = new TitledItem<ConfigurableSearchTextField>(configSearchField, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        this.validate();
    }

    public void addNumberSearchField(String id, String title, String defaultText) {
        NumberSearchTextField searchField = new NumberSearchTextField();
        searchField.setID(id);
        searchField.setName(title);
        searchField.setDefaultText(defaultText);
        searchField.addSearchTextFieldListener(this);
        TitledItem<NumberSearchTextField> item = new TitledItem<NumberSearchTextField>(searchField, WordsToolkit.toUpperCase((String)title), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        this.add(item);
        this.validate();
    }

    public void addCustomerSearchField(String id) {
        SearchTextField2<CustomerLight> searchField = SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("Customer");
        TitledItem<SearchTextField2<CustomerLight>> item = new TitledItem<SearchTextField2<CustomerLight>>(searchField, WordsToolkit.toUpperCase((String)Words.CUSTOMER), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addRestaurantSearchField(String id) {
        SearchTextField2<RestaurantComplete> searchField = SearchTextField2Factory.getRestaurantSearch(true, (Node<RestaurantComplete>)new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("Restaurant");
        TitledItem<SearchTextField2<RestaurantComplete>> item = new TitledItem<SearchTextField2<RestaurantComplete>>(searchField, WordsToolkit.toUpperCase((String)Words.RESTAURANT), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addSalesPersonSearchField(String id) {
        SearchTextField2<SalesPersonComplete> searchField = SearchTextField2Factory.getSalesPersonSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("Sales Person");
        TitledItem<SearchTextField2<SalesPersonComplete>> item = new TitledItem<SearchTextField2<SalesPersonComplete>>(searchField, WordsToolkit.toUpperCase((String)Words.SALES_PERSON), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addAirportSearchField(String id) {
        SearchTextField2<AirportComplete> searchField = SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("Airport");
        TitledItem<SearchTextField2<AirportComplete>> item = new TitledItem<SearchTextField2<AirportComplete>>(searchField, WordsToolkit.toUpperCase((String)Words.DELIVERY_AIRPORT), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addStowingListTemplateField(String id) {
        SearchTextField2<StowingListTemplateComplete> searchField = SearchTextField2Factory.getStowingTemplateSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("StowingList");
        TitledItem<SearchTextField2<StowingListTemplateComplete>> item = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(searchField, WordsToolkit.toUpperCase((String)Words.STOWING_LIST), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addArticleSearchField(String id) {
        SearchTextField2<BasicArticleLight> searchField = SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode());
        searchField.setID(id);
        searchField.setIsFilterChain(true);
        searchField.setName("Article");
        TitledItem<SearchTextField2<BasicArticleLight>> item = new TitledItem<SearchTextField2<BasicArticleLight>>(searchField, WordsToolkit.toUpperCase((String)Words.ARTICLE), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addSupplierSearchField(String id) {
        SearchTextField2<SupplierLight> searchField = SearchTextField2Factory.getSupplierSearchField(true, new DTOProxyNode());
        searchField.setIsFilterChain(true);
        searchField.setID(id);
        searchField.setName("Supplier");
        TitledItem<SearchTextField2<SupplierLight>> item = new TitledItem<SearchTextField2<SupplierLight>>(searchField, WordsToolkit.toUpperCase((String)Words.SUPPLIER), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addStoreSearchField(String id) {
        SearchTextField2<StoreLight> searchField = SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode());
        searchField.setIsFilterChain(true);
        searchField.setID(id);
        searchField.setName("Store");
        TitledItem<SearchTextField2<StoreLight>> item = new TitledItem<SearchTextField2<StoreLight>>(searchField, WordsToolkit.toUpperCase((String)Words.STORE), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addStorePositionSearchField(String id) {
        SearchTextField2<StorePositionLight> searchField = SearchTextField2Factory.getStorePositionSearchField(true, new DTOProxyNode());
        searchField.setIsFilterChain(true);
        searchField.setID(id);
        searchField.setName("Store");
        TitledItem<SearchTextField2<StorePositionLight>> item = new TitledItem<SearchTextField2<StorePositionLight>>(searchField, WordsToolkit.toUpperCase((String)Words.STORE), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public SearchTextField2<ArticleChargeLight> addChargeSearchField(String id) {
        SearchTextField2<ArticleChargeLight> searchField = SearchTextField2Factory.getArticleChargeSearchField(true, new DTOProxyNode());
        searchField.setIsFilterChain(true);
        searchField.setID(id);
        searchField.setName("Charge");
        TitledItem<SearchTextField2<ArticleChargeLight>> item = new TitledItem<SearchTextField2<ArticleChargeLight>>(searchField, WordsToolkit.toUpperCase((String)Words.CHARGE), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
        return searchField;
    }

    public void addCustomsDocumentSearchField(String id) {
        SearchTextField2<CustomsDocumentTypeComplete> searchField = SearchTextField2Factory.getCustomsDocumentTypeSearchField(true, new DTOProxyNode());
        searchField.setIsFilterChain(true);
        searchField.setID(id);
        searchField.setName("CustomsDocumentType");
        TitledItem<SearchTextField2<CustomsDocumentTypeComplete>> item = new TitledItem<SearchTextField2<CustomsDocumentTypeComplete>>(searchField, WordsToolkit.toUpperCase((String)Words.CUSTOMS_DOCUMENT_TYPE), TitledItem.TitledItemOrientation.NORTH);
        item.setInnerGap(-2);
        item.setTitleFont(this.getFont());
        this.components.add(item);
        item.setProgress(0.0f);
        searchField.addSearchTextFieldListener(this);
        this.add(item);
        this.validate();
    }

    public void addFilterChainListener(FilterChainListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterChainListener(FilterChainListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(Object name, Object value, boolean isReset, Component source) {
        if (this.isBlind || this.isKilled) {
            return;
        }
        for (FilterChainListener listener : this.listeners) {
            listener.filterValueChanged(name, value, isReset, source);
        }
    }

    private void searchFieldValueChanged(DocumentEvent e) {
        for (Component comp : this.components) {
            SearchTextField sf;
            if (comp instanceof TitledItem && ((TitledItem)comp).getElement() instanceof ConfigurableSearchTextField && (sf = (ConfigurableSearchTextField)((TitledItem)comp).getElement()).getDocument() == e.getDocument()) {
                this.fireEvent(sf.getID(), sf.getText(), false, sf);
                return;
            }
            if (!(comp instanceof TitledItem) || !(((TitledItem)comp).getElement() instanceof SearchTextField) || (sf = (SearchTextField)((TitledItem)comp).getElement()).getDocument() != e.getDocument()) continue;
            this.fireEvent(sf.getID(), sf.getText(), false, sf);
            return;
        }
    }

    private void searchFieldValueChanged(SearchTextField source) {
        for (Component comp : this.components) {
            SearchTextField sf;
            if (comp instanceof TitledItem && ((TitledItem)comp).getElement() instanceof ConfigurableSearchTextField && (sf = (ConfigurableSearchTextField)((TitledItem)comp).getElement()) == source) {
                this.fireEvent(sf.getID(), sf.getText(), false, sf);
                return;
            }
            if (!(comp instanceof TitledItem) || !(((TitledItem)comp).getElement() instanceof SearchTextField) || (sf = (SearchTextField)((TitledItem)comp).getElement()) != source) continue;
            this.fireEvent(sf.getID(), sf.getText(), false, sf);
            return;
        }
    }

    @Override
    public void textChanged(String nText, SearchTextField source) {
        this.searchFieldValueChanged(source);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.searchFieldValueChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.searchFieldValueChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.searchFieldValueChanged(e);
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("filter_chain_inner_title_foreground")));
            this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("filter_chain_inner_title_font_size"), LafLoader.getLafLoader().getAttribute("filter_chain_inner_title_font_type")));
            for (Component c : this.components) {
                if (c instanceof TitledItem) {
                    TitledItem f = (TitledItem)c;
                    f.setTitleFont(this.getFont());
                    f.setItemFont(this.getFont());
                    f.setTitleForeground(this.getForeground());
                    f.setItemForeground(this.getForeground());
                    continue;
                }
                if (!(c instanceof TitledPeriodEditor)) continue;
                ((TitledPeriodEditor)c).setTitleFont(this.getFont());
            }
            this.defaultSeparatorColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("filter_chain_separator_color"));
            this.validate();
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.getFilterChainLayout().setHorizontalComponentsGap(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_horizontal_component_gap")));
            this.getFilterChainLayout().setDefaultSearchBoxWidth(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_searchbox_width")));
            this.getFilterChainLayout().setDefaultComboBoxWidth(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_combobox_width")));
            this.getFilterChainLayout().setDefaultResetButtonWidth(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_resetbutton_width")));
            this.getFilterChainLayout().setDefaultSeparatorWidth(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_separator_width")));
            this.getFilterChainLayout().setDefaultSeparatorY(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("filter_chain_separator_y")));
            this.validate();
        }
    }

    public void overrideDefaultSearchBoxWidth(int w) {
        this.getFilterChainLayout().setDefaultSearchBoxWidth(w);
    }

    public void overrideDefaultComboBoxWidth(int w) {
        this.getFilterChainLayout().setDefaultComboBoxWidth(w);
    }

    public void overrideDefaultSearchField2Width(int w) {
        this.getFilterChainLayout().setDefaultSearchTextField2Width(w);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() instanceof ComboBox) {
                ComboBox box = (ComboBox)e.getSource();
                this.fireEvent(box.getID(), box.getSelectedItem(), false, box);
            } else if (e.getSource() instanceof MultiSelectionComboBox) {
                MultiSelectionComboBox box = (MultiSelectionComboBox)e.getSource();
                this.fireEvent(box.getID(), box.getSelectedObjects(), false, box);
            } else if (e.getSource() instanceof MultiSelectionPanel) {
                MultiSelectionPanel box = (MultiSelectionPanel)e.getSource();
                this.fireEvent(box.getID(), e.getItem(), false, box);
            }
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.resetButton) {
            for (Component comp : this.components) {
                if (comp instanceof TitledItem) {
                    this.resetElement((TitledItem)comp);
                    continue;
                }
                if (!(comp instanceof TitledPeriodEditor)) continue;
                this.resetElement((TitledPeriodEditor)comp);
            }
            this.fireEvent(null, null, true, source);
        } else if (source instanceof CheckBox) {
            this.fireEvent(((CheckBox)source).getID(), ((CheckBox)source).isChecked(), false, source);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void removeScheduled(Fadable comp) {
        if (this.animationPanel != null) {
            this.animationPanel.kill();
        }
        if (!this.isKilled) {
            this.setEnabled(true);
        }
    }

    @Override
    public void allFadedIn() {
        Component c;
        this.isAnimating = false;
        if (this.focusPolicy != null && (c = this.focusPolicy.getFirstComponent(null)) != null) {
            c.requestFocusInWindow();
        }
        this.removeScheduled(null);
        if (this.nextLoader != null) {
            this.nextLoader.deactivateDataLoadingAnimation();
        }
    }

    public void stopAnimationImmediately() {
        this.scheduledFader.insertAllImmediately();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        TitledDayTimePeriodChooser t;
        if (node.getName().equals("startDate")) {
            TitledPeriodEditor t2 = this.getPeriodSelector4Node(node);
            if (t2 != null) {
                this.fireEvent(t2.getId(), t2, false, t2);
            }
        } else if (node.getName().equals("endDate")) {
            TitledPeriodEditor t3 = this.getPeriodSelector4Node(node);
            if (t3 != null) {
                this.fireEvent(t3.getId(), t3, false, t3);
            }
        } else if (node.getName().equals("startTime")) {
            TitledDayTimePeriodChooser t4 = this.getDayTimeSelection4Node(node);
            if (t4 != null) {
                this.fireEvent(t4.getId(), t4, false, t4);
            }
        } else if (node.getName().equals("endTime") && (t = this.getDayTimeSelection4Node(node)) != null) {
            this.fireEvent(t.getId(), t, false, t);
        }
    }

    private void resetElement(TitledPeriodEditor comp) {
        comp.setCheckBoxChecked(false);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        comp.getStartDateChooser().getNode().setValue((Object)p.getStartDate(), 0L);
        comp.getEndDateChooser().getNode().setValue((Object)p.getEndDate(), 0L);
    }

    private void resetElement(TitledItem<?> comp) {
        if (comp.getElement() instanceof SearchTextField) {
            ((SearchTextField)comp.getElement()).getDocument().removeDocumentListener(this);
            ((SearchTextField)comp.getElement()).setText(((SearchTextField)comp.getElement()).getDefaultText());
            ((SearchTextField)comp.getElement()).getDocument().addDocumentListener(this);
        }
        if (comp.getElement() instanceof ComboBox) {
            ((ComboBox)comp.getElement()).removeItemListener(this);
            ((ComboBox)comp.getElement()).setSelectedItem(((ComboBox)comp.getElement()).getDefaultObject());
            ((ComboBox)comp.getElement()).addItemListener(this);
        }
        if (comp.getElement() instanceof NumericStepper) {
            ((NumericStepper)comp.getElement()).removeNumericStepperListener(this);
            ((NumericStepper)comp.getElement()).setInputNr(((NumericStepper)comp.getElement()).getDefaultV());
            ((NumericStepper)comp.getElement()).addNumericStepperListener(this);
        }
        if (comp.getElement() instanceof DateChooser) {
            ((DateChooser)comp.getElement()).removeDateChooserListener(this);
            ((DateChooser)comp.getElement()).setSelectedDate(((DateChooser)comp.getElement()).getDefaultDate());
            ((DateChooser)comp.getElement()).addDateChooserListener(this);
        }
        if (comp.getElement() instanceof SearchTextField2) {
            ((SearchTextField2)comp.getElement()).removeSearchTextFieldListener(this);
            if (((SearchTextField2)comp.getElement()).getNode() != null) {
                ((SearchTextField2)comp.getElement()).getNode().setValue(null, 0L);
            } else {
                ((SearchTextField2)comp.getElement()).resetText();
            }
            ((SearchTextField2)comp.getElement()).addSearchTextFieldListener(this);
        }
        if (comp.getElement() instanceof CheckBox) {
            ((CheckBox)comp.getElement()).setChecked(((CheckBox)comp.getElement()).getDefaultValue());
        }
    }

    private TitledPeriodEditor getPeriodSelector4Node(Node node) {
        for (Component c : this.components) {
            TitledPeriodEditor p;
            if (c instanceof TitledPeriodEditor) {
                p = (TitledPeriodEditor)c;
                if (p.getStartDateChooser().getNode() == node) {
                    return p;
                }
                if (p.getEndDateChooser().getNode() != node) continue;
                return p;
            }
            if (!(c instanceof TitledItem) || !(((TitledItem)c).getElement() instanceof TitledPeriodEditor)) continue;
            p = (TitledPeriodEditor)((TitledItem)c).getElement();
            if (p.getStartDateChooser().getNode() == node) {
                return p;
            }
            if (p.getEndDateChooser().getNode() != node) continue;
            return p;
        }
        return null;
    }

    private TitledDayTimePeriodChooser getDayTimeSelection4Node(Node node) {
        for (Component c : this.components) {
            TitledDayTimePeriodChooser p;
            if (c instanceof TitledDayTimePeriodChooser) {
                p = (TitledDayTimePeriodChooser)c;
                if (p.getTimeStartNode() == node) {
                    return p;
                }
                if (p.getTimeEndNode() != node) continue;
                return p;
            }
            if (!(c instanceof TitledItem) || !(((TitledItem)c).getElement() instanceof TitledDayTimePeriodChooser)) continue;
            p = (TitledDayTimePeriodChooser)((TitledItem)c).getElement();
            if (p.getTimeStartNode() == node) {
                return p;
            }
            if (p.getTimeEndNode() != node) continue;
            return p;
        }
        return null;
    }

    @Override
    public void valueChanged(NumericStepper source) {
        this.fireEvent(source.getcId(), source.getInputNr(), false, source);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void dateChanged(DateChooser source, Date selectedDate) {
        this.fireEvent(source.getCId(), selectedDate, false, source);
    }

    @Override
    public void dateTimeChanged(DateTimeChooser source, Timestamp timestamp) {
        this.fireEvent(source.getCId(), timestamp, false, source);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.fireEvent(source.getID(), source.getNode().getValue(), false, source);
    }

    @Override
    public void newPeriodSelected(java.sql.Date start, java.sql.Date end, TitledPeriodEditor source) {
        TitledPeriodEditor t = source;
        if (t != null) {
            this.fireEvent(t.getId(), t, false, t);
        }
    }

    public void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component c : this.components) {
            List<Component> b;
            if (!(c instanceof Focusable) || (b = ((Focusable)((Object)c)).getFocusComponents()) == null) continue;
            a.addAll(b);
        }
        if (this.resetButton != null) {
            a.add(this.resetButton);
        }
        this.focusPolicy = (CustomFocusCyclePolicy)CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        this.setFocusCycleRoot(true);
    }

    @Override
    public void selectionChanged(SearchComboBox store, SearchTextField2 position) {
        Object value = null;
        value = position.getNode().getValue() == null ? store.getNode().getValue() : position.getNode().getValue();
        this.fireEvent(store.getID(), value, false, null);
    }

    public void updateElement(String key, String value) {
        for (Component comp : this.components) {
            if (comp instanceof TitledItem) {
                TitledItem item = (TitledItem)comp;
                if (item.getElement() instanceof UIStateLoadable) {
                    UIStateLoadable p = (UIStateLoadable)item.getElement();
                    if (!p.getID().equals(key) || !p.shouldPersist()) continue;
                    p.loadState(value, null);
                    return;
                }
                if (item.getElement() instanceof HorizontalCombinedView) {
                    HorizontalCombinedView hcv = (HorizontalCombinedView)item.getElement();
                    for (Component cc : hcv.getHorizontalComponents()) {
                        if (cc instanceof UIStateLoadable) {
                            if (!((UIStateLoadable)((Object)cc)).getID().equals(key) || !((UIStateLoadable)((Object)cc)).shouldPersist()) continue;
                            ((UIStateLoadable)((Object)cc)).loadState(value, null);
                            return;
                        }
                        logger.debug("Horizontal Component found, which is not persitable: " + cc.getClass().getName());
                    }
                    continue;
                }
                logger.debug("Titled Item found which is not persistable: " + item.getElement().getClass().getName());
                continue;
            }
            if (comp instanceof TitledPeriodEditor) {
                TitledPeriodEditor editor = (TitledPeriodEditor)comp;
                if (!editor.getId().equals(key) || !editor.shouldPersist()) continue;
                try {
                    editor.loadState(value, null);
                }
                catch (Exception e) {
                    editor.setCheckBoxChecked(false);
                }
                return;
            }
            logger.debug("Found a Item which is not implementing persistable: " + comp.getClass().getName());
        }
        logger.info("Unable to write all Filter Chain configs to Disk: (" + value + " :: " + key + ")");
    }

    public FilterChainConfiguration getCurrentConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        for (Component comp : this.components) {
            if (comp instanceof TitledItem) {
                Object p;
                TitledItem item = (TitledItem)comp;
                if (item.getElement() instanceof UIStateLoadable) {
                    p = (UIStateLoadable)item.getElement();
                    c.addProperty(p.getID(), p.getPersistString());
                    continue;
                }
                if (item.getElement() instanceof HorizontalCombinedView) {
                    p = (HorizontalCombinedView)item.getElement();
                    for (Component cc : ((HorizontalCombinedView)p).getHorizontalComponents()) {
                        if (cc instanceof UIStateLoadable) {
                            UIStateLoadable pp = (UIStateLoadable)((Object)cc);
                            c.addProperty(pp.getID(), ((UIStateLoadable)((Object)cc)).getPersistString());
                            continue;
                        }
                        logger.debug("Horizontal Component found, which is not persistable: " + cc.getClass().getName());
                    }
                    continue;
                }
                logger.debug("Titled Item found which is not persistable: " + item.getElement().getClass().getName());
                continue;
            }
            if (comp instanceof UIStateLoadable) {
                UIStateLoadable p = (UIStateLoadable)((Object)comp);
                c.addProperty(p.getID(), p.getPersistString());
                continue;
            }
            logger.debug("Found a Item which is not implementing persistable: " + comp.getClass().getName());
        }
        return c;
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void addModificationStateComboBox(String id) {
        ComboBox b = ComboBoxFactory.getModificationStateComboBox(true);
        this.addSelectionComboBox(b, 90, id, Words.STATE, Words.ALL);
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.remove(listener);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.add(listener);
    }

    protected void fireFocusCycleChanged(MutableFocusContainer target) {
        for (MutableFocusContainerListener l : this.focusCycleListener) {
            l.focusCycleChanged(target);
        }
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.fireFocusCycleChanged(container);
        this.createFocusCycle();
    }

    public void setResetButtonWidth(int width) {
        this.getFilterChainLayout().setDefaultResetButtonWidth(width);
    }
}

