/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image;

import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImagePreviewPainter;
import ch.icit.pegasus.client.gui.utils.image.ImagePreviewPopupInset;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;

public class ImagePanel
extends Button
implements Nodable {
    private Node<PegasusFileComplete> node;
    private File localFile;
    private ImagePreviewPainter painter;
    private BufferedImage currentImage;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private volatile boolean imageLoaded = false;
    private int fixSize = 60;
    private boolean fixSizeMode = true;
    private volatile boolean stopDownload = false;

    public ImagePanel() {
        this.painter = new ImagePreviewPainter();
        this.addButtonListener((source, x, y) -> this.showPopup(x, y));
    }

    private void showPopup(int x, int y) {
        if (this.imageLoaded) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this, true, true, Words.IMAGE_PREVIEW);
            popUp.hideCancelButton();
            popUp.setView(new ImagePreviewPopupInset(this.currentImage, null));
            popUp.showPopUp(x, y, 300, 300, null, this, PopupType.FRAMELESS);
        }
    }

    public void setFixSize(int fixSize) {
        this.fixSize = fixSize;
    }

    public void setStopDownload(boolean stopDownload) {
        this.stopDownload = stopDownload;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fixSizeMode) {
            return new Dimension(this.fixSize, this.fixSize);
        }
        if (this.imageLoaded) {
            double factorY;
            double factorX = (double)this.currentImage.getWidth() / (double)this.fixSize;
            if (factorX > (factorY = (double)this.currentImage.getHeight() / (double)this.fixSize)) {
                return new Dimension(60, (int)((double)this.currentImage.getHeight() / factorY));
            }
            return new Dimension((int)((double)this.currentImage.getWidth() / factorX), 60);
        }
        return new Dimension(0, 30);
    }

    private void ensureLocalFile() {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.painter.paint(g2, 0, 0, this.getWidth(), this.getHeight(), this.settings, this.currentImage, true);
        this.paintChildren(g2);
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (this.node != null && this.node.getValue() != null) {
            this.ensureLocalFile();
        }
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public void setFixSizeMode(boolean fixSizeMode) {
        this.fixSizeMode = fixSizeMode;
    }
}

