/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup;

import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import java.awt.Container;

public abstract class LoadablePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    protected LoadingAnimation loadingAnimation;
    protected MultiLineTextLabel message;

    public void showAnimation(String text) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        this.loadingAnimation.stateChanged(text);
    }

    public void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
    }

    public void showMessage(String t) {
        if (this.message == null) {
            this.message = new MultiLineTextLabel();
            this.add(this.message);
        }
        this.message.setText(t);
    }

    public void hideMessage() {
        if (this.message != null) {
            this.message.kill();
            this.message = null;
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        if (this.loadingAnimation != null) {
            this.hideAnimation();
        }
        super.kill();
    }

    protected void layoutAnimation(Container parent) {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.setLocation((int)(((double)parent.getWidth() - this.loadingAnimation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
            this.loadingAnimation.setSize(this.loadingAnimation.getPreferredSize());
        }
        if (this.message != null) {
            this.message.setLocation(this.border, this.border);
            this.message.setSize(parent.getSize());
        }
    }
}

