/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.SupplierConditionConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.panels.ArticlePackagingTable;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.myway.PopupInsert1;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ArticlePackagingTableWithSupplierConditionPopupInsert
extends PopupInsert1 {
    private final boolean showTable;
    private ArticlePackagingTable table;
    private HorizontalSeparator sep1;
    private TitledItem<CheckBox> overridePacking;
    private TitledItem<RDComboBox> supplierCondition;

    public ArticlePackagingTableWithSupplierConditionPopupInsert(Node<PurchaseOrderPositionComplete> node, SupplierLight supplier, Date validityDate, RDProvider provider) {
        this(node, supplier, validityDate, provider, true);
    }

    public ArticlePackagingTableWithSupplierConditionPopupInsert(Node<PurchaseOrderPositionComplete> node, SupplierLight supplier, Date validityDate, RDProvider provider, boolean showTable) {
        this.showTable = showTable;
        Node supplierConditionNode = node.getChildNamed(PurchaseOrderPositionComplete_.supplierCondition);
        if (showTable) {
            this.table = new ArticlePackagingTable(provider, SupplierConditionComplete_.packingQuantities, null);
            this.table.setNode((Node<List<PackagingQuantityComplete>>)supplierConditionNode.getChildNamed(SupplierConditionComplete_.packingQuantities));
            this.sep1 = new HorizontalSeparator();
            this.overridePacking = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierCondition, SupplierConditionComplete_.usePackingQuantity})), Words.USE_SEPARATE_PACKAGING_LIST, TitledItem.TitledItemOrientation.EAST);
            this.overridePacking.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        this.supplierCondition = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SupplierConditionConverter.class)), Words.SUPPLIER_CONFIGURATION, TitledItem.TitledItemOrientation.NORTH);
        this.supplierCondition.getElement().setNode(supplierConditionNode);
        this.supplierCondition.getElement().refreshPossibleValues(this.createSupplierConditionsList(node, supplier, validityDate));
        this.supplierCondition.getElement().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Node selectedCondition = (Node)e.getItem();
                if (showTable) {
                    this.table.setNode((Node<List<PackagingQuantityComplete>>)selectedCondition.getChildNamed(SupplierConditionComplete_.packingQuantities));
                    this.overridePacking.getElement().setNode(selectedCondition.getChildNamed(SupplierConditionComplete_.usePackingQuantity));
                }
            }
        });
        this.setLayout(new Layout());
        this.add(this.supplierCondition);
        if (showTable) {
            this.add(this.sep1);
            this.add(this.overridePacking);
            this.add(this.table);
        }
        this.setEnabled(this.isEnabled());
    }

    private Node createSupplierConditionsList(Node<PurchaseOrderPositionComplete> node, SupplierLight supplier, Date validityDate) {
        SupplierConditionComplete currentSelection = (SupplierConditionComplete)node.getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        BasicArticleComplete artC = (BasicArticleComplete)node.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        ArrayList<SupplierConditionComplete> conditions = new ArrayList<SupplierConditionComplete>();
        for (SupplierConditionBaseComplete supplierCond : artC.getSuppliers()) {
            if (!supplier.equals((Object)supplierCond.getSupplier())) continue;
            for (SupplierConditionCategoryComplete categoryComplete : supplierCond.getSupplierConditionCategory()) {
                for (SupplierConditionComplete supplierConditionComplete : categoryComplete.getConditions()) {
                    if (supplierConditionComplete.getValidity().getStartDate().getTime() > validityDate.getTime() || supplierConditionComplete.getValidity().getEndDate().getTime() < validityDate.getTime()) continue;
                    boolean alreadyAdded = false;
                    if (currentSelection.getValidity().getStartDate() != null && supplierConditionComplete.getValidity().getStartDate().getTime() == currentSelection.getValidity().getStartDate().getTime() && supplierConditionComplete.getValidity().getEndDate().getTime() == currentSelection.getValidity().getEndDate().getTime()) {
                        String categoryComment1 = currentSelection.getCategoryComment();
                        String categoryComment2 = supplierConditionComplete.getCategoryComment();
                        if (categoryComment1 == null) {
                            categoryComment1 = "";
                        }
                        if (categoryComment2 == null) {
                            categoryComment2 = "";
                        }
                        if (currentSelection.getCategoryTaxZone() != null && supplierConditionComplete.getCategoryTaxZone() != null) {
                            if (currentSelection.getCategoryTaxZone().equals((Object)supplierConditionComplete.getCategoryTaxZone()) && categoryComment1.equals(categoryComment2)) {
                                alreadyAdded = true;
                                conditions.add(currentSelection);
                            }
                        } else if (currentSelection.getCategoryTaxZone() == null && supplierConditionComplete.getCategoryTaxZone() == null && categoryComment1.equals(categoryComment2)) {
                            alreadyAdded = true;
                            conditions.add(currentSelection);
                        }
                    }
                    if (alreadyAdded) continue;
                    SupplierConditionComplete copiedCondition = CopyTemplateToolkit.copySupplierCondition(supplierConditionComplete);
                    conditions.add(copiedCondition);
                }
            }
        }
        Node nodes = INodeCreator.getDefaultImpl().createNodes(conditions, true);
        nodes.updateNode();
        return nodes;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.showTable) {
            this.table.setEnabled(enabled && this.overridePacking.getElement().isChecked());
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.supplierCondition);
        CheckedListAdder.addToList(focusList, this.overridePacking);
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{this.supplierCondition.getElement().getNode().getValue()};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean innerComponent = this.supplierCondition.getElement().isInnerComponent(c);
        if (innerComponent) {
            return innerComponent;
        }
        if (this.showTable) {
            return this.table.isInnerComponent(c);
        }
        return false;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ArticlePackagingTableWithSupplierConditionPopupInsert.this.border;
            h = (int)((double)h + ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.getPreferredSize().getHeight());
            h += ArticlePackagingTableWithSupplierConditionPopupInsert.this.border;
            if (ArticlePackagingTableWithSupplierConditionPopupInsert.this.showTable) {
                h = (int)((double)h + ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.getPreferredSize().getHeight());
                h += ArticlePackagingTableWithSupplierConditionPopupInsert.this.border;
                h = (int)((double)h + ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.getPreferredSize().getHeight());
                h += ArticlePackagingTableWithSupplierConditionPopupInsert.this.border / 2;
                h = (int)((double)h + ArticlePackagingTableWithSupplierConditionPopupInsert.this.table.getPreferredSize().getHeight());
                h += ArticlePackagingTableWithSupplierConditionPopupInsert.this.border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.setLocation(ArticlePackagingTableWithSupplierConditionPopupInsert.this.border, ArticlePackagingTableWithSupplierConditionPopupInsert.this.border);
            ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.setSize(parent.getWidth() - 2 * ArticlePackagingTableWithSupplierConditionPopupInsert.this.border, (int)ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.getPreferredSize().getHeight());
            if (ArticlePackagingTableWithSupplierConditionPopupInsert.this.showTable) {
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.setLocation(ArticlePackagingTableWithSupplierConditionPopupInsert.this.border, ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.getY() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.supplierCondition.getHeight() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.border);
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.setSize(parent.getWidth() - 2 * ArticlePackagingTableWithSupplierConditionPopupInsert.this.border, (int)ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.getPreferredSize().getHeight());
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.setLocation(ArticlePackagingTableWithSupplierConditionPopupInsert.this.border, ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.getY() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.sep1.getHeight() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.border);
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.setSize(ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.getPreferredSize());
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.table.setLocation(0, ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.getY() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.overridePacking.getHeight() + ArticlePackagingTableWithSupplierConditionPopupInsert.this.border / 2);
                ArticlePackagingTableWithSupplierConditionPopupInsert.this.table.setSize(parent.getWidth(), parent.getHeight() - ArticlePackagingTableWithSupplierConditionPopupInsert.this.table.getY());
            }
        }
    }
}

