/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AppSupport;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.icons.defaults.ImageIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class ExceptionPopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private final ImageIcon errorIcon;
    private final MultiLineTextLabel infoLabel;
    private final Throwable exception;
    private final UserComplete currentUser;
    private final int border = 10;

    public ExceptionPopupInsert(Throwable excThrowable, UserComplete user) {
        excThrowable.printStackTrace();
        this.exception = excThrowable;
        this.currentUser = user;
        FilterChainConfiguration.removeDefaultConfiguration((UserLight)user, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        this.errorIcon = new ImageIcon(DefaultSkins.PopupErrorIcon);
        this.infoLabel = new MultiLineTextLabel();
        this.infoLabel.setText("<html><b>Unexpected Error occured.<br/>CATIT needs to be restarted.</b><br/><br/>Do you want to send a Bug Report to ICIT?</html>");
        this.setLayout(new Layout());
        this.add(this.errorIcon);
        this.add(this.infoLabel);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enableOKButton(true);
        ip.enablePreviewButton("Bug Report", TextButton.BUTTON_TYPES.CANCEL);
        ip.setOkButtonText("Exit");
        ip.hideCancelButton();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    public static String stackTraceAsString(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter pw = new PrintWriter(result);
        t.printStackTrace(pw);
        return result.toString();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            AppSupport.closeApp();
        } else if (isOK == PopupAction.PREVIEW) {
            InnerPopupFactory.showSendBugReportPopup(new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        return;
                    }
                    String t = "";
                    t = xargs.length > 0 ? (String)xargs[0] : "no message";
                    AppSupport.sendReport(ExceptionPopupInsert.this.exception, ExceptionPopupInsert.this.currentUser, t);
                }
            }, this);
        } else {
            AppSupport.restartApp();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)ExceptionPopupInsert.this.errorIcon.getPreferredSize().getHeight();
            return new Dimension(200, 10 + h + 10);
        }

        @Override
        public void layoutContainer(Container parent) {
            ExceptionPopupInsert.this.errorIcon.setLocation(10, (int)(10.0 + ((double)parent.getHeight() - (20.0 + ExceptionPopupInsert.this.errorIcon.getPreferredSize().getHeight())) / 2.0));
            ExceptionPopupInsert.this.errorIcon.setSize(ExceptionPopupInsert.this.errorIcon.getPreferredSize());
            ExceptionPopupInsert.this.infoLabel.setLocation(ExceptionPopupInsert.this.errorIcon.getX() + ExceptionPopupInsert.this.errorIcon.getWidth() + 10, 10);
            ExceptionPopupInsert.this.infoLabel.setSize(parent.getWidth() - (ExceptionPopupInsert.this.infoLabel.getX() + 10), parent.getHeight() - 20);
        }
    }
}

