/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.priceanimation;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;

public class ReloadablePriceView
extends JPanelFadable
implements NodeListener,
Validatable {
    private static final long serialVersionUID = 1L;
    private QuantityRenderer quantityRenderer;
    private AsynchronLoaderAnimation animation;
    private CalculationRunnable currentRunnable = null;
    private Node persistInto;
    private boolean isLoading = false;
    private boolean isReload = false;
    private Object[] paras;
    private LoadingGroup loader;

    public ReloadablePriceView(LoadingGroup loader, Converter<?, ?> c) {
        this.loader = loader;
        this.quantityRenderer = new QuantityRenderer(null);
        this.quantityRenderer.setViewConverter(c);
        this.animation = new AsynchronLoaderAnimation();
        this.quantityRenderer.setProgress(1.0f);
        this.animation.setProgress(0.0f);
        this.animation.getFader().setPermanent(true);
        this.setProgress(1.0f);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.add(this.quantityRenderer);
        this.add(this.animation);
        this.setVisible(true);
    }

    public void setConverterParametes(Object ... paras) {
        this.paras = paras;
        this.quantityRenderer.setViewConverterAttributes(paras);
    }

    public ReloadablePriceView(LoadingGroup loader, Class viewConverterClass) {
        this(loader, ConverterRegistry.getConverter((Class)viewConverterClass));
    }

    public void setCommitInto(Node node) {
        this.persistInto = node;
    }

    public String getText() {
        return this.quantityRenderer.getText();
    }

    public QuantityRenderer getTextLabel() {
        return this.quantityRenderer;
    }

    public String getDisplayedText() {
        return this.quantityRenderer.getDisplayedText();
    }

    public void setQuantityRendererConverter(Class clazz) {
        this.quantityRenderer.setViewConverter(ConverterRegistry.getConverter((Class)clazz));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.quantityRenderer.kill();
        this.quantityRenderer = null;
        this.animation.kill();
        this.animation = null;
    }

    @Override
    public void setFont(Font f) {
        if (this.quantityRenderer != null) {
            this.quantityRenderer.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.quantityRenderer != null) {
            this.quantityRenderer.setEnabled(isEnabled);
        }
    }

    public void setNode(Node node) {
        if (this.quantityRenderer == null) {
            return;
        }
        if (this.quantityRenderer.getNode() != null) {
            this.quantityRenderer.getNode().removeNodeListener((NodeListener)this);
        }
        this.quantityRenderer.setNode(node);
        if (this.quantityRenderer != null && this.quantityRenderer.getNode() != null) {
            this.quantityRenderer.getNode().addNodeListener((NodeListener)this);
        }
    }

    public void writeDefaultValueIntoNode() {
        this.valueChanged(this.quantityRenderer.getNode());
    }

    public Node getNode() {
        if (this.quantityRenderer != null) {
            return this.quantityRenderer.getNode();
        }
        return null;
    }

    public void setRunnable(CalculationRunnable run) {
        this.currentRunnable = run;
    }

    public void updateString() {
        this.quantityRenderer.updateString();
    }

    public void load(boolean isInit) {
        if (!this.isLoading) {
            if (!this.isReload && this.animation != null) {
                this.animation.startAnimation();
                this.animation.fadeIn();
                this.quantityRenderer.setText("...");
            }
            if (isInit && this.loader != null) {
                this.isLoading = true;
                this.loader.updateMe(this);
            }
            this.invalidate();
            this.validate();
        } else {
            this.isReload = true;
        }
    }

    public void loaded() {
        this.isLoading = false;
        if (this.isReload) {
            this.load(true);
        } else {
            if (this.animation != null) {
                this.animation.stopAnimation();
                this.animation.fadeOut(false);
            }
            this.invalidate();
            this.validate();
        }
        this.isReload = false;
    }

    public CalculationRunnable getCurrentRunnable() {
        return this.currentRunnable;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        if (this.persistInto != null) {
            long id = System.currentTimeMillis();
            this.persistInto.setValue(node.getValue(), id);
            this.persistInto.updateNode();
        }
    }

    public void setViewParas(Object ... objects) {
        this.quantityRenderer.setViewConverterAttributes(objects);
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void setValid() {
        this.quantityRenderer.setValid();
    }

    @Override
    public void setInvalid() {
        this.quantityRenderer.setInvalid();
    }

    @Override
    public void setWarning() {
        this.quantityRenderer.setWarning();
    }

    public boolean isFieldValid() {
        return this.quantityRenderer.isFieldValid();
    }

    @Override
    public void setPermanent(boolean isPermantent) {
        this.quantityRenderer.setPermanent(isPermantent);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (ReloadablePriceView.this.isLoading) {
                tailing = (int)ReloadablePriceView.this.animation.getPreferredSize().getWidth();
                ReloadablePriceView.this.animation.setLocation(parent.getWidth() - tailing, (int)(((double)parent.getHeight() - ReloadablePriceView.this.animation.getPreferredSize().getHeight()) / 2.0));
                ReloadablePriceView.this.animation.setSize(ReloadablePriceView.this.animation.getPreferredSize());
                tailing += 5;
            } else {
                tailing = AsynchronLoaderAnimation.getPreferredWidth();
                tailing += 5;
            }
            ReloadablePriceView.this.quantityRenderer.setLocation(0, (int)(((double)parent.getHeight() - ReloadablePriceView.this.quantityRenderer.getPreferredSize().getHeight()) / 2.0));
            ReloadablePriceView.this.quantityRenderer.setSize(parent.getWidth() - tailing, (int)ReloadablePriceView.this.quantityRenderer.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (ReloadablePriceView.this.quantityRenderer == null) {
                return new Dimension(0, 0);
            }
            int h = (int)ReloadablePriceView.this.quantityRenderer.getPreferredSize().getHeight();
            if ((double)h < ReloadablePriceView.this.animation.getPreferredSize().getHeight()) {
                h = (int)ReloadablePriceView.this.animation.getPreferredSize().getHeight();
            }
            int w = (int)(ReloadablePriceView.this.quantityRenderer.getPreferredSize().getWidth() + (double)AsynchronLoaderAnimation.getPreferredWidth() + 5.0);
            return new Dimension(w, h);
        }
    }
}

