/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.store.customsdeadline.CustomsDeadlineEntryComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomsDeadlineEntryTable
extends Table2
implements Nodable {
    private static final long serialVersionUID = 1L;

    public CustomsDeadlineEntryTable() {
        super(true, Words.ADD, false, false, Words.CUSTOMS_DEADLINES);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomsDeadlineEntryTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CustomsDeadlineEntryComplete entry = new CustomsDeadlineEntryComplete();
                entry.setClientOId(Long.valueOf(ADTO.getNextId()));
                CustomsDeadlineEntryTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)entry, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.START_DATE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.END_DATE, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    @Override
    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    @Override
    public Node<?> getNode() {
        return this.getModel().getNode();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.startDate = new RDDateChooser(CustomsDeadlineEntryTable.this.getProvider());
            this.endDate = new RDDateChooser(CustomsDeadlineEntryTable.this.getProvider());
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return super.isInnerComponent(c);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.delete.kill();
            this.startDate = null;
            this.endDate = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(TableRowImpl.this.startDate.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(TableRowImpl.this.endDate.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

