/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RestoreButton;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StorePositionEditTable
extends Table2 {
    private Node<StoreLight> storeNode;

    public StorePositionEditTable() {
        super(true, Words.ADD, true, true, Words.POSITIONS);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                StorePositionComplete storeP = new StorePositionComplete();
                storeP.setClientOId(Long.valueOf(ADTO.getNextId()));
                storeP.setStore((StoreLight)StorePositionEditTable.this.storeNode.getValue(StoreLight.class));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)storeP, true, false);
                StorePositionEditTable.this.getModel().getNode().addChild(n, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("", null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo("Barcode", null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo("Halal", null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setStoreNode(Node<StoreLight> storeNode) {
        this.storeNode = storeNode;
        this.validateDefaultPosition();
    }

    private void validateDefaultPosition() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.getModel().getNode().getValue().equals(this.storeNode.getChildNamed(StoreLight_.defaultStorePosition).getValue())) {
                pp.setChecked(true);
                continue;
            }
            pp.setChecked(false);
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField code;
        private TextField barcode;
        private Button deleteButton;
        private RadioButton isDefaultPosition;
        private CheckBox halalPosition;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.code = new TextField(m.getNode().getChildNamed(StorePositionLight_.name));
            this.barcode = new TextField(m.getNode().getChildNamed(StorePositionLight_.barcode));
            this.halalPosition = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(StorePositionLight_.halalPosition));
            this.isDefaultPosition = new RadioButton();
            this.isDefaultPosition.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.ensureDeleteButton();
            this.add(this.code);
            this.add(this.barcode);
            this.add(this.isDefaultPosition);
            this.add(this.halalPosition);
        }

        private void ensureDeleteButton() {
            if (this.deleteButton != null) {
                this.deleteButton.kill();
                this.deleteButton = null;
            }
            this.deleteButton = Boolean.TRUE.equals(this.model.getNode().getChildNamed(StorePositionLight_.deleted).getValue()) ? new RestoreButton() : new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.deleteButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.barcode.kill();
            this.deleteButton.kill();
            this.isDefaultPosition.kill();
            this.halalPosition.kill();
            this.code = null;
            this.barcode = null;
            this.deleteButton = null;
            this.isDefaultPosition = null;
            this.halalPosition = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.isDefaultPosition);
            CheckedListAdder.addToList(focusList, this.code);
            CheckedListAdder.addToList(focusList, this.barcode);
            CheckedListAdder.addToList(focusList, this.halalPosition);
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.code.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.code != null) {
                this.code.setEnabled(isEnabled);
            }
            if (this.barcode != null) {
                this.barcode.setEnabled(isEnabled);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
            if (this.isDefaultPosition != null) {
                this.isDefaultPosition.setEnabled(isEnabled);
            }
            if (this.halalPosition != null) {
                this.halalPosition.setEnabled(isEnabled);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                Boolean oldValue = (Boolean)this.model.getNode().getChildNamed(StorePositionLight_.deleted).getValue();
                if (oldValue == null) {
                    oldValue = false;
                }
                oldValue = oldValue == false;
                this.model.getNode().getChildNamed(StorePositionLight_.deleted).setValue((Object)oldValue, 0L);
                this.ensureDeleteButton();
            } else if (source == this.isDefaultPosition) {
                StorePositionEditTable.this.storeNode.getChildNamed(StoreLight_.defaultStorePosition).setValue((Object)((StorePositionLight)this.getModel().getNode().getValue()), 0L);
                StorePositionEditTable.this.validateDefaultPosition();
            }
        }

        public boolean isChecked() {
            return this.isDefaultPosition.isChecked();
        }

        public void setChecked(boolean b) {
            this.isDefaultPosition.setChecked(b);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                if (TableRowImpl.this.isDefaultPosition != null) {
                    TableRowImpl.this.isDefaultPosition.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isDefaultPosition.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isDefaultPosition.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.isDefaultPosition.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.code.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.code.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.code.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.code.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.barcode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.barcode.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.barcode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.barcode.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.halalPosition.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.halalPosition.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.halalPosition.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.halalPosition.getPreferredSize().getHeight());
                    TableRowImpl.this.setControlsX(currentX += w);
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }
        }
    }
}

