/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDFileChooserPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SupplierSpecificationsTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public SupplierSpecificationsTable(RDProvider provider, Node<List<SupplierConditionSpecificationComplete>> node) {
        super(true, Words.ADD, false, false, Words.SPECIFICATION);
        this.setOverrideName("Supplier-" + SupplierConditionSpecificationComplete_.specFile.getFieldName());
        this.setProvider(provider);
        this.setUseWriteAccessRight(true);
        this.setUseAccessRight(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SupplierSpecificationsTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SupplierConditionSpecificationComplete spec = new SupplierConditionSpecificationComplete();
                spec.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)spec, true, false);
                SupplierSpecificationsTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SPECIFICATION, null, null, null, "", 40, 40, 40));
        int dw = 2 * this.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        columns.add(new TableColumnInfo(Words.VALIDITY_FROM, null, null, null, "", dw, dw, dw));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDFileChooserPanel fileChooser;
        private RDDateChooser dateChooser;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.fileChooser = new RDFileChooserPanel(SupplierSpecificationsTable.this.getProvider(), true);
            this.fileChooser.setOverrideName("Supplier-" + SupplierConditionSpecificationComplete_.specFile.getFieldName());
            this.fileChooser.setShowText(Words.PREVIEW);
            this.fileChooser.setChooseText(Words.CHOOSE);
            this.fileChooser.setEnableShowFile(true);
            this.fileChooser.setNode(m.getNode().getChildNamed(SupplierConditionSpecificationComplete_.specFile));
            this.dateChooser = new RDDateChooser(SupplierSpecificationsTable.this.getProvider());
            this.dateChooser.setOverrideName("Supplier-" + SupplierConditionSpecificationComplete_.specFile.getFieldName());
            this.dateChooser.setNode(m.getNode().getChildNamed(SupplierConditionSpecificationComplete_.validFrom));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.fileChooser);
            this.add(this.dateChooser);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.fileChooser.kill();
            this.delete.kill();
            this.dateChooser.kill();
            this.fileChooser = null;
            this.delete = null;
            this.dateChooser = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.fileChooser);
            CheckedListAdder.addToList(a, this.dateChooser);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.fileChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fileChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fileChooser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fileChooser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.dateChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.dateChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.dateChooser.setSize(TableRowImpl.this.dateChooser.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

