/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SPMLFormatEditor
extends DefaultPanel
implements Nodable,
TextFieldListener,
Validatable {
    private static final long serialVersionUID = 1L;
    private TextField text = new TextField();
    private InfoButton info;
    private Node<String> node;

    public SPMLFormatEditor() {
        this.text.addTextFieldListener(this);
        this.info = new InfoButton();
        this.info.installStringViewer(MealPlanToolkit.createSPMLNameConfigInfoText());
        this.setLayout(new Layout());
        this.add(this.text);
        this.add(this.info);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.text.getFocusComponents();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.text.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.text.setEnabled(isEnabled);
        this.info.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.text.kill();
        this.text = null;
        this.info.kill();
        this.info = null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (node.getValue() != null) {
            String t = this.convertToText((String)node.getValue());
            this.text.setText(t);
        }
    }

    private String convertToText(String nodeValue) {
        String t = "";
        String[] parts = nodeValue.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (!p.startsWith("{") || !p.endsWith("}")) continue;
            String v = p.substring(1, p.length() - 1);
            v = v.trim();
            if ((v = v.toLowerCase()).equals("0")) {
                t = t + "{leg},";
                continue;
            }
            if (v.equals("1")) {
                t = t + "{class},";
                continue;
            }
            if (v.equals("2")) {
                t = t + "{id},";
                continue;
            }
            if (v.equals("3")) {
                t = t + "{service},";
                continue;
            }
            if (!v.equals("4")) continue;
            t = t + "{spml},";
        }
        if (!t.isEmpty()) {
            t = t.substring(0, t.length() - 1);
        }
        return t;
    }

    private String convertToNodeValue(String textValue) {
        String t = "";
        String ut = textValue;
        if (ut == null || ut.isEmpty()) {
            ut = t = t + "{0},{1},{2},{3},{4},";
        }
        String[] parts = ut.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (!p.startsWith("{") || !p.endsWith("}")) continue;
            String v = p.substring(1, p.length() - 1);
            v = v.trim();
            if ((v = v.toLowerCase()).equals("leg")) {
                t = t + "{0},";
                continue;
            }
            if (v.equals("class")) {
                t = t + "{1},";
                continue;
            }
            if (v.equals("id")) {
                t = t + "{2},";
                continue;
            }
            if (v.equals("service")) {
                t = t + "{3},";
                continue;
            }
            if (!v.equals("spml")) continue;
            t = t + "{4},";
        }
        if (!t.isEmpty()) {
            t = t.substring(0, t.length() - 1);
        }
        return t;
    }

    public List<ScreenValidationObject> validateFormat() {
        ArrayList<ScreenValidationObject> errors = new ArrayList<ScreenValidationObject>();
        String nodeValue = this.text.getText();
        if (!nodeValue.isEmpty()) {
            String[] parts = nodeValue.split(",");
            for (int i = 0; i < parts.length; ++i) {
                String p = parts[i];
                if (!(p = p.trim()).startsWith("{")) {
                    errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Tag " + p + " must start with {"));
                }
                if (!p.endsWith("}")) {
                    errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Tag " + p + " must end with }"));
                }
                if (!errors.isEmpty()) continue;
                if (p.length() > 2) {
                    String v = p.substring(1, p.length() - 1);
                    v = v.trim();
                    if ((v = v.toLowerCase()).equals("leg") || v.equals("class") || v.equals("id") || v.equals("service") || v.equals("spml")) continue;
                    errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Tag " + p + " is not a valid identifier (check Info Button)"));
                    continue;
                }
                errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Tag " + p + " is not a valid identifier (check Info Button)"));
            }
        } else {
            String ut = nodeValue;
            if (this.text != null && this.text.getNode() != null && (ut == null || ut.isEmpty())) {
                ut = "{0},{1},{2},{3},{4},";
                this.text.getNode().setValue((Object)ut, 0L);
            }
        }
        return errors;
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        String t = field.getText();
        if (this.validateFormat().isEmpty()) {
            this.text.setValid();
            if (this.node != null) {
                String nv = (String)this.node.getValue();
                if (nv != null && nv.equals(t)) {
                    return;
                }
                nv = this.convertToNodeValue(t);
                this.node.setValue((Object)nv, 0L);
            }
        } else {
            this.text.setInvalid();
        }
    }

    @Override
    public void setValid() {
        this.text.setValid();
    }

    @Override
    public void setInvalid() {
        this.text.setInvalid();
    }

    @Override
    public void setWarning() {
        this.text.setWarning();
    }

    @Override
    public void setPermanent(boolean isPermantent) {
        this.text.setPermanent(isPermantent);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return SPMLFormatEditor.this.text.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            SPMLFormatEditor.this.text.setLocation(0, 0);
            SPMLFormatEditor.this.text.setSize((int)((double)parent.getWidth() - (3.0 + SPMLFormatEditor.this.info.getPreferredSize().getWidth())), (int)SPMLFormatEditor.this.text.getPreferredSize().getHeight());
            SPMLFormatEditor.this.info.setLocation(SPMLFormatEditor.this.text.getWidth() + 3, (int)(((double)parent.getHeight() - SPMLFormatEditor.this.info.getPreferredSize().getHeight()) / 2.0));
            SPMLFormatEditor.this.info.setSize(SPMLFormatEditor.this.info.getPreferredSize());
        }
    }
}

