/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.RecipeCategoryConverter;
import ch.icit.pegasus.client.converter.RecipeVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import java.sql.Date;
import java.util.Iterator;

public class RecipeScreenToolkit {
    public static final int YIELD = 3;
    public static final int STD_PRICE = 5;
    public static final int CATEGORY = 7;
    public static final int COMPONENTS = 11;
    public static final int WASTE = 13;

    public static Node filterList(Node list, Node currentNode) {
        ViewNode n = new ViewNode("Recipes");
        Iterator it = list.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            if (nn.getValue().equals(currentNode.getValue())) continue;
            n.addChild(nn, 0L);
        }
        return n;
    }

    public static String getRecipeInfoString(RecipeVariantLight recipe, CurrencyComplete targetCurrency, Date validityDate, int selection) {
        Converter category;
        String catText;
        String text = "";
        Converter co = ConverterRegistry.getConverter(RecipeVariantConverter.class);
        String tlop = (String)co.convert((Object)recipe, null, new Object[0]);
        if (tlop != null && !tlop.isEmpty()) {
            text = text + "<b>" + tlop + "</b><br/><hr/><br/>";
        }
        if (selection % 3 == 0) {
            QuantityComplete yield = recipe.getYield();
            yield = new QuantityComplete(yield);
            QuantityConverter1Decimal conv = (QuantityConverter1Decimal)ConverterRegistry.getConverter(QuantityConverter1Decimal.class);
            text = text + "<b>Yield</b><ul>";
            text = text + "<li>" + conv.convert((Object)yield, null, new Object[0]) + "</li></ul>";
        }
        if (selection % 5 == 0) {
            Converter priceConverter = ConverterRegistry.getConverter(PriceConverter3.class);
            PriceComplete p1 = null;
            if (recipe.getPrice() == null) {
                p1 = new PriceComplete(targetCurrency, Double.valueOf(0.0));
                double d = p1.getPrice() / recipe.getYield().getQuantity();
                p1.setPrice(Double.valueOf(d));
            } else {
                p1 = recipe.getPrice();
            }
            text = text + "<b>Standart Price</b><ul>";
            text = text + "<li>" + (String)priceConverter.convert((Object)p1, null, new Object[0]) + "/" + recipe.getYield().getUnit().getShortName() + "</li></ul>";
        }
        if (selection % 7 == 0 && (catText = (String)(category = ConverterRegistry.getConverter(RecipeCategoryConverter.class)).convert((Object)recipe.getCategory(), null, new Object[0])) != null && !catText.equals("")) {
            text = text + "<b>Category</b><ul><li>" + catText + "</li></ul>";
        }
        if (selection % 13 == 0) {
            FormattedDoubleConverter2Decimals converter = (FormattedDoubleConverter2Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            double waste2 = ArticlePriceCalculationToolkit.getRecipeGroupTenderCookingWaste((RecipeVariantLight)recipe, (Date)validityDate);
            text = text + "<b>Tender Waste</b><ul><li>" + converter.convert((Number)waste2, null, new Object[0]) + "%</li></ul>";
            waste2 = ArticlePriceCalculationToolkit.getRecipeGroupProductiveCookingWaste((RecipeVariantLight)recipe, (Date)validityDate);
            text = text + "<b>Productive Waste</b><ul><li>" + converter.convert((Number)waste2, null, new Object[0]) + "%</li></ul>";
        }
        return text;
    }

    public static int getAllTypes() {
        return 15015;
    }
}

