/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.hud.HistoryObject;
import ch.icit.pegasus.client.gui.hud.externopentool.SmartExternOpenTool;
import ch.icit.pegasus.client.gui.hud.smartscreen.AnalysisSmartScreen;
import ch.icit.pegasus.client.gui.hud.smartscreen.DtoSmartScreen;
import ch.icit.pegasus.client.gui.hud.smartscreen.MasterDataSmartScreen;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.hud.smartscreen.SmartScreen;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.AnalysisSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.DtoSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.MasterDataSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.RowSubModuleProvider;
import ch.icit.pegasus.client.gui.modules.nullscreen.EmptySpace;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenViewProvider {
    private static final Logger logger = LoggerFactory.getLogger(ScreenViewProvider.class);
    private static Stack<HistoryObject> screenHistory = new Stack();
    private static HistoryObject currentScreen;
    private static ScreenInsert currentScreenView;

    public static void pushScreen(String screenClass, String title) {
        if (currentScreen != null) {
            Iterator it = screenHistory.iterator();
            while (it.hasNext()) {
                HistoryObject o = (HistoryObject)it.next();
                if (!o.getClassName().equals(currentScreen.getClassName())) continue;
                it.remove();
            }
            screenHistory.push(currentScreen);
        }
        currentScreen = new HistoryObject(screenClass, title);
    }

    public static ModuleDefinitionComplete getCurrentModuleDefinition() {
        return (ModuleDefinitionComplete)HUDToolkit.getModuleDefinitionForInvoker(HUDToolkit.getInvokerNameForTopScreenClass(ScreenViewProvider.getCurrentScreenClass()), ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    public static JPanel getCurrentScreenView() {
        return currentScreenView;
    }

    public static HistoryObject getPreviousScreen() {
        if (screenHistory.isEmpty()) {
            return null;
        }
        return screenHistory.pop();
    }

    public static Object forName(HistoryObject h, MainFrame initiator) {
        return ScreenViewProvider.forName(h, initiator, true);
    }

    public static Object forName(HistoryObject h, MainFrame initiator, boolean historize) {
        return ScreenViewProvider.forName(h.getClassName(), initiator, h.getHudButtonTitle(), null, historize, null, null);
    }

    public static HistoryObject getCurrentScreenObject() {
        return currentScreen;
    }

    public static String getCurrentScreenClass() {
        return currentScreen.getClassName();
    }

    public static Object forName(String classname, MainFrame initiator, String title, Screen oldScreen, Node dtoToSelect, CustomerLight customer) {
        return ScreenViewProvider.forName(classname, initiator, title, oldScreen, true, dtoToSelect, customer);
    }

    public static Object forName(String classname, MainFrame initiator, String title, Screen oldScreen, Node dtoToSelect) {
        return ScreenViewProvider.forName(classname, initiator, title, oldScreen, true, dtoToSelect, null);
    }

    public static Object forName(String classname, MainFrame initiator, String title, Screen oldScreen) {
        return ScreenViewProvider.forName(classname, initiator, title, oldScreen, true, null, null);
    }

    public static boolean isScreenInsert(String classname) {
        try {
            Class<?> c = Class.forName(classname);
            return ScreenInsert.class.isAssignableFrom(c);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to find Screen Class " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
            return false;
        }
    }

    public static boolean isSmartScreen(String classname) {
        try {
            Class<?> c = Class.forName(classname);
            return SmartScreen.class.isAssignableFrom(c);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to find Screen Class " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
            return false;
        }
    }

    public static boolean isSmartExternOpenTool(String classname) {
        try {
            Class<?> c = Class.forName(classname);
            return SmartExternOpenTool.class.isAssignableFrom(c);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to find Screen Class " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
            return false;
        }
    }

    public static Object forName(String classname, MainFrame initiator, String title, Screen oldScreen, boolean historize, Node itemToSelect, CustomerLight overrideCustomer) {
        try {
            Class<?> c = Class.forName(classname);
            Object o = c.newInstance();
            Method b = c.getMethod("setMainFrame", MainFrame.class);
            b.invoke(o, initiator);
            if (o instanceof SmartScreen && oldScreen != null) {
                TransferObject op;
                ScreenInsert view = oldScreen.getView();
                if (view instanceof RowSubModuleProvider && o instanceof RowSmartScreen) {
                    op = ((RowSubModuleProvider)((Object)view)).getRowTransferObject();
                    if (itemToSelect != null) {
                        op.setNode(itemToSelect);
                        if (itemToSelect.getValue() instanceof ADTO) {
                            op.setDto(itemToSelect.getValue());
                        }
                    }
                    if (overrideCustomer != null) {
                        ((RowTransferObject)op).setCustomer(overrideCustomer);
                    }
                    ((RowSmartScreen)o).setRowAttributes(op);
                }
                if (view instanceof AnalysisSubModuleProvider && o instanceof AnalysisSmartScreen) {
                    ((AnalysisSmartScreen)o).setEmptySearchConfiguration(((AnalysisSubModuleProvider)((Object)view)).getEmptySearchConfiguration());
                    ((AnalysisSmartScreen)o).setCurrentRDProvider(((AnalysisSubModuleProvider)((Object)view)).getCurrentProvider());
                    ((AnalysisSmartScreen)o).setFilteredSearchConfiguration(((AnalysisSubModuleProvider)((Object)view)).getFilteredSearchConfiguration());
                    ((AnalysisSmartScreen)o).setPageNumber(((AnalysisSubModuleProvider)((Object)view)).getPageNumber());
                }
                if (view instanceof MasterDataSubModuleProvider && o instanceof MasterDataSmartScreen) {
                    ((MasterDataSmartScreen)o).setSubModuleProvider((MasterDataSubModuleProvider)((Object)view));
                }
                if (view instanceof DtoSubModuleProvider && o instanceof DtoSmartScreen) {
                    op = ((DtoSubModuleProvider)((Object)view)).getDtoTransferObject();
                    if (op == null) {
                        return null;
                    }
                    if (itemToSelect != null) {
                        op.setNode(itemToSelect);
                        if (itemToSelect.getValue() instanceof ADTO) {
                            op.setDto(itemToSelect.getValue());
                        }
                    }
                    ((DtoSmartScreen)o).setDtoAttributes(op);
                }
                if (o instanceof SmartExternOpenTool) {
                    initiator.setCurrentScreenClass(classname);
                    return o;
                }
            }
            if (initiator != null) {
                initiator.setCurrentScreenClass(classname);
            }
            if (historize) {
                ScreenViewProvider.pushScreen(classname, title);
            }
            currentScreenView = (ScreenInsert)o;
            return new Screen((ScreenInsert)o);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to find Screen Class " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (InstantiationException e) {
            logger.error("Unable to initiate Screen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (IllegalAccessException e) {
            logger.error("Illegal Access for initiate Screen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (SecurityException e) {
            logger.error("Unable to access method setMainFrame while initiating Sceen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (NoSuchMethodException e) {
            logger.error("Unable to find method setMainFrame while initation Screen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (IllegalArgumentException e) {
            logger.error("Illegal Arguments while initation Screen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        catch (InvocationTargetException e) {
            logger.error("Invocation of method setMainFrame failed while initating Screen " + classname + ": " + e.getMessage());
            e.printStackTrace();
            ScreenViewProvider.showError();
        }
        return ScreenViewProvider.forName(EmptySpace.class.getName(), initiator, "Module not found", oldScreen);
    }

    private static void showError() {
        ErrorSupport.showExceptionWindow((String)"Unable to Load Screen");
    }
}

