/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.attributes;

import ch.icit.pegasus.server.core.util.ResourcesLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolTipLoader {
    private static final Logger logger = LoggerFactory.getLogger(ToolTipLoader.class);
    private static ToolTipLoader singltonTooltipLoader;
    private Properties properties;

    private ToolTipLoader() {
        InputStream in = ResourcesLoader.getResourceAsStream((String)"tooltip.properties");
        this.load(in);
    }

    public void load(InputStream in) {
        this.properties = new Properties();
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            logger.error("Unable to load Tooltip Properties: " + e.getMessage());
        }
    }

    public static ToolTipLoader getLanguageStringLoader() {
        if (singltonTooltipLoader == null) {
            singltonTooltipLoader = new ToolTipLoader();
        }
        return singltonTooltipLoader;
    }

    public String getLanguageString(String name) {
        return (String)this.properties.get(name);
    }
}

