/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.converter.AirportConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DTODataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocationsInsert
extends DTODataInsert<LocationComplete>
implements FileTransferListener {
    private static final long serialVersionUID = 1L;

    public LocationsInsert() {
        super((MasterDataModule)null);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public LocationComplete getNewObject() {
        return new LocationComplete();
    }

    @Override
    public Class<? extends LocationComplete> getMasterDataClass() {
        return LocationComplete.class;
    }

    @Override
    public DetailsPanel getDetails() {
        return new LocationInsertPanelConfig();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node r = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return r;
            }

            @Override
            public RemoteLoader getInvoker() {
                return LocationsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = LocationsInsert.this.masterDataTable.getModel().getNode().getChilds();
                ArrayList<ClientServerCallException> errors = new ArrayList<ClientServerCallException>();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.commit(LocationComplete.class);
                    LocationComplete d = (LocationComplete)n.getValue(LocationComplete.class);
                    try {
                        d = d.getId() == null ? (LocationComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).createLocation(d).getValue() : (LocationComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateLocation(d).getValue();
                    }
                    catch (ClientServerCallException e) {
                        errors.add(e);
                    }
                    n.removeExistingValues();
                    n.setValue((Object)d, 0L);
                    n.updateNode();
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection(Words.UNABLE_TO_LOAD_ALL_LOCATIONS, errors);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return LocationsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void statusChanged(File file, FileTransferState state) {
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public String getInsertName() {
        return Words.LOCATIONS;
    }

    private class LocationInsertPanelConfig
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private Node<?> node;
        private TitledItem<SearchTextField2> airport;

        public LocationInsertPanelConfig() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.airport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(false, null), Words.AIRPORT, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.airport);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.airport.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.airport.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.airport.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.airport != null) {
                this.airport.kill();
            }
            this.airport = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            this.airport.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(AirportConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.node = node;
            this.airport.getElement().setNode(node.getChildNamed(LocationComplete_.homeBase));
            this.revalidate();
            LocationsInsert.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return LocationComplete_.homeBase;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                LocationInsertPanelConfig.this.airport.setLocation(LocationsInsert.this.masterDataTable.getCellPadding(), LocationsInsert.this.masterDataTable.getCellPadding());
                LocationInsertPanelConfig.this.airport.setSize(250, (int)LocationInsertPanelConfig.this.airport.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

