/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class GroupedLoader
implements LoadingGroup,
RemoteLoader {
    private ReloadablePriceView weightedPrice;
    private List<ReloadablePriceView> factors;
    private ReloadablePriceView totalPrice;
    private PriorityBlockingQueue<ReloadablePriceView> loadingQueue;
    private boolean isRunning = false;
    private Component c;

    public GroupedLoader(Component c) {
        this.c = c;
        this.factors = new ArrayList<ReloadablePriceView>();
        this.loadingQueue = new PriorityBlockingQueue<ReloadablePriceView>(10, new ReloadablePriceComparator());
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        switch (this.getViewType(rpv)) {
            case 5: {
                this.loadingQueue.addAll(this.factors);
                this.loadingQueue.add(this.totalPrice);
                this.runMe();
                break;
            }
            case 6: {
                this.weightedPrice.load(false);
                this.loadingQueue.add(this.weightedPrice);
                this.runMe();
                break;
            }
            case 8: {
                this.totalPrice.load(false);
                this.loadingQueue.add(this.totalPrice);
                this.runMe();
                break;
            }
            case 7: {
                rpv.load(false);
                this.loadingQueue.add(rpv);
                this.totalPrice.load(false);
                this.loadingQueue.add(this.totalPrice);
                this.runMe();
            }
        }
    }

    private int getViewType(ReloadablePriceView view) {
        if (view == this.weightedPrice) {
            return 6;
        }
        if (view == this.totalPrice) {
            return 8;
        }
        if (this.factors.contains(view)) {
            return 7;
        }
        if (view == null) {
            return 5;
        }
        return -1;
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void setWeightedPrice(ReloadablePriceView wP) {
        this.weightedPrice = wP;
    }

    public void addFactor(ReloadablePriceView f) {
        this.factors.add(f);
    }

    public void removeFactor(ReloadablePriceView f) {
        this.factors.remove(f);
    }

    public void setTotalView(ReloadablePriceView total) {
        this.totalPrice = total;
    }

    private void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!GroupedLoader.this.loadingQueue.isEmpty()) {
                    ReloadablePriceView r = (ReloadablePriceView)GroupedLoader.this.loadingQueue.poll();
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (runing == null || !runing.isAlive()) continue;
                    runing.run();
                    r.loaded();
                }
                GroupedLoader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupedLoader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, this.c);
    }

    private class ReloadablePriceComparator
    implements Comparator<ReloadablePriceView> {
        private ReloadablePriceComparator() {
        }

        @Override
        public int compare(ReloadablePriceView o1, ReloadablePriceView o2) {
            Integer t1 = GroupedLoader.this.getViewType(o1);
            Integer t2 = GroupedLoader.this.getViewType(o2);
            return t1.compareTo(t2);
        }
    }
}

