/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotificationmanager.details;

import ch.icit.pegasus.client.converter.ChangeNotificationStateEConverter;
import ch.icit.pegasus.client.converter.ChangeNotificationTypeEConverter;
import ch.icit.pegasus.client.converter.FlightConverter;
import ch.icit.pegasus.client.converter.FlightStdConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ChangeNotificationSpecificationPanel
extends DefaultDetailsPanel<ChangeNotificationLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> state;
    private TitledItem<TextLabel> type;
    private TitledItem<TextLabel> flight;
    private TitledItem<TextLabel> flightStd;

    public ChangeNotificationSpecificationPanel(RowEditor<ChangeNotificationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.state = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(ChangeNotificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.state.getElement().setReadOnlyTextField(true);
        this.type = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(ChangeNotificationTypeEConverter.class)), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().setReadOnlyTextField(true);
        this.flight = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(FlightConverter.class)), Words.FLIGHT, TitledItem.TitledItemOrientation.NORTH);
        this.flight.getElement().setReadOnlyTextField(true);
        this.flightStd = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(FlightStdConverter.class)), Words.STD, TitledItem.TitledItemOrientation.NORTH);
        this.flightStd.getElement().setReadOnlyTextField(true);
        this.addToView(this.state);
        this.addToView(this.type);
        this.addToView(this.flight);
        this.addToView(this.flightStd);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ChangeNotificationComplete dto = (ChangeNotificationComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.state.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.state));
        this.type.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.type));
        this.flight.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.flight));
        this.flightStd.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.flight));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.state.setEnabled(isEnabled);
        this.type.setEnabled(isEnabled);
        this.flight.setEnabled(isEnabled);
        this.flightStd.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.type);
        CheckedListAdder.addToList(focusList, this.flight);
        CheckedListAdder.addToList(focusList, this.flightStd);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.state.kill();
        this.type.kill();
        this.flight.kill();
        this.flightStd.kill();
        this.state = null;
        this.type = null;
        this.flight = null;
        this.flightStd = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.state.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 2 * ChangeNotificationSpecificationPanel.this.horizontalBorder;
            ChangeNotificationSpecificationPanel.this.state.setLocation(ChangeNotificationSpecificationPanel.this.horizontalBorder, ChangeNotificationSpecificationPanel.this.verticalBorder);
            ChangeNotificationSpecificationPanel.this.state.setSize((w -= ChangeNotificationSpecificationPanel.this.inner_horizontalBorder / 2) + ChangeNotificationSpecificationPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationSpecificationPanel.this.state.getPreferredSize().getHeight());
            ChangeNotificationSpecificationPanel.this.type.setLocation(ChangeNotificationSpecificationPanel.this.horizontalBorder, ChangeNotificationSpecificationPanel.this.state.getY() + ChangeNotificationSpecificationPanel.this.state.getHeight() + ChangeNotificationSpecificationPanel.this.inner_verticalBorder);
            ChangeNotificationSpecificationPanel.this.type.setSize(w + ChangeNotificationSpecificationPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationSpecificationPanel.this.type.getPreferredSize().getHeight());
            ChangeNotificationSpecificationPanel.this.flight.setLocation(ChangeNotificationSpecificationPanel.this.horizontalBorder, ChangeNotificationSpecificationPanel.this.type.getY() + ChangeNotificationSpecificationPanel.this.type.getHeight() + ChangeNotificationSpecificationPanel.this.inner_verticalBorder);
            ChangeNotificationSpecificationPanel.this.flight.setSize(w + ChangeNotificationSpecificationPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationSpecificationPanel.this.flight.getPreferredSize().getHeight());
            ChangeNotificationSpecificationPanel.this.flightStd.setLocation(ChangeNotificationSpecificationPanel.this.horizontalBorder, ChangeNotificationSpecificationPanel.this.flight.getY() + ChangeNotificationSpecificationPanel.this.flight.getHeight() + ChangeNotificationSpecificationPanel.this.inner_verticalBorder);
            ChangeNotificationSpecificationPanel.this.flightStd.setSize(w + ChangeNotificationSpecificationPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationSpecificationPanel.this.flightStd.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ChangeNotificationSpecificationPanel.this.verticalBorder;
            currentY += ChangeNotificationSpecificationPanel.this.state.getHeight() + ChangeNotificationSpecificationPanel.this.verticalBorder;
            currentY += ChangeNotificationSpecificationPanel.this.type.getHeight() + ChangeNotificationSpecificationPanel.this.verticalBorder;
            currentY += ChangeNotificationSpecificationPanel.this.flight.getHeight() + ChangeNotificationSpecificationPanel.this.verticalBorder;
            return new Dimension(260, currentY += ChangeNotificationSpecificationPanel.this.flightStd.getHeight() + ChangeNotificationSpecificationPanel.this.verticalBorder);
        }
    }
}

