/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking.details.utils;

import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomDocumentsReadOnlyPopUp
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private boolean isEditable = true;

    public CustomDocumentsReadOnlyPopUp(Node docs, RDProvider provider, boolean isEditable) {
        this.isEditable = isEditable;
        this.table = new Table2(isEditable, Words.ADD, false, false);
        this.table.setOverrideName("documents");
        this.table.setProvider(provider);
        this.table.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DOC_TYPE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.DOC_ID, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CUSTOM_OFFICE, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(docs);
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel id;
        private TextLabel customOffice;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.type = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentType), ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class));
            this.id = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId));
            this.customOffice = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customOffice));
            this.type.setProgress(1.0f);
            this.add(this.type);
            this.add(this.id);
            this.add(this.customOffice);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return true;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.id.setEnabled(isEnabled);
            this.customOffice.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.id.kill();
            this.customOffice.kill();
            this.type = null;
            this.id = null;
            this.customOffice = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.id.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.id.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.id.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.id.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customOffice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customOffice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customOffice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customOffice.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 450);
        }

        @Override
        public void layoutContainer(Container parent) {
            CustomDocumentsReadOnlyPopUp.this.table.setLocation(0, 0);
            CustomDocumentsReadOnlyPopUp.this.table.setSize(parent.getSize());
        }
    }
}

