/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.ArticleConsumptionInterfaceExportListTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleConsumptionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.ArticleConsumptionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.ArticleConsumptionSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ArticleConsumptionInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useArticleConsumptionSync;
    private TitledItem<CheckBox> useDailyGenerator;
    private TitledItem<CheckBox> useWeeklyGenerator;
    private TitledItem<CheckBox> useMonthlyGenerator;
    private ArticleConsumptionInterfaceExportListTable history;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<ArticleConsumptionSettingsComplete> settings;
    protected ArticleConsumptionSettingsComplete arisc;
    private Node articleConsumptionData = new ViewNode("consumptions");

    public ArticleConsumptionInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useArticleConsumptionSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ArticleConsumptionSettingsComplete_.useArticleConsumptionInterface)), Words.ENABLE_ARTICLE_CONSUMPTION, TitledItem.TitledItemOrientation.EAST);
        this.useArticleConsumptionSync.getElement().addButtonListener(this);
        this.useDailyGenerator = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ArticleConsumptionSettingsComplete_.useDaily)), Words.ENABLE_DAILY, TitledItem.TitledItemOrientation.EAST);
        this.useWeeklyGenerator = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ArticleConsumptionSettingsComplete_.useWeekly)), Words.ENABLE_WEEKLY, TitledItem.TitledItemOrientation.EAST);
        this.useMonthlyGenerator = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ArticleConsumptionSettingsComplete_.useMonthly)), Words.ENABLE_MONTHLY, TitledItem.TitledItemOrientation.EAST);
        this.history = new ArticleConsumptionInterfaceExportListTable();
        this.history.setNode(this.articleConsumptionData);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useArticleConsumptionSync);
        this.configPanel.add(this.useDailyGenerator);
        this.configPanel.add(this.useWeeklyGenerator);
        this.configPanel.add(this.useMonthlyGenerator);
        this.configPanel.add(this.saveButton);
        this.sendPanel.add(this.history);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                try {
                    ArticleConsumptionInsert.this.arisc = (ArticleConsumptionSettingsComplete)((ArticleConsumptionServiceManager)ServiceManagerRegistry.getService(ArticleConsumptionServiceManager.class)).getArticleConsumptionSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ArticleConsumptionInsert.this.arisc == null) {
                    ArticleConsumptionSettingsComplete s = new ArticleConsumptionSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    ArticleConsumptionInsert.this.arisc = s;
                }
                ArticleConsumptionInsert.this.arisc.setDailyTimerSettings(ArticleConsumptionInsert.this.createDailyTimerService());
                ArticleConsumptionInsert.this.arisc.setDailyTimerSettings(ArticleConsumptionInsert.this.createWeeklyTimerService());
                ArticleConsumptionInsert.this.arisc.setDailyTimerSettings(ArticleConsumptionInsert.this.createMonthlyTimerService());
                ArticleConsumptionInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)ArticleConsumptionInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleConsumptionInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createMonthlyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.FIRST, Integer.valueOf(1), Integer.valueOf(50), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createWeeklyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(DayOfWeekE.MONDAY, Integer.valueOf(1), Integer.valueOf(10), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useArticleConsumptionSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useArticleConsumptionSync.getElement().isChecked();
            this.useDailyGenerator.setEnabled(b);
            this.useWeeklyGenerator.setEnabled(b);
            this.useMonthlyGenerator.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.history.kill();
            this.saveButton.kill();
            this.useArticleConsumptionSync.kill();
            this.useDailyGenerator.kill();
            this.useWeeklyGenerator.kill();
            this.useMonthlyGenerator.kill();
        }
        this.useDailyGenerator = null;
        this.useWeeklyGenerator = null;
        this.useMonthlyGenerator = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.history = null;
        this.saveButton = null;
        this.useArticleConsumptionSync = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_CONSUMPTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateArticleConsumptionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleConsumptionInsert.this.settings.commit(ArticleConsumptionSettingsComplete.class);
                ArticleConsumptionSettingsComplete arisc = (ArticleConsumptionSettingsComplete)ArticleConsumptionInsert.this.settings.getValue();
                if (Boolean.TRUE.equals(arisc.getUseArticleConsumptionInterface())) {
                    TimerServiceSettingsComplete ts;
                    if (Boolean.TRUE.equals(arisc.getUseDaily())) {
                        arisc.setDailyTimerSettings(ArticleConsumptionInsert.this.createDailyTimerService());
                        ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getDailyTimerSettings()).getValue();
                        arisc.setDailyTimerSettings(ts);
                        arisc = (ArticleConsumptionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_DAILY, true, ts, -1L);
                    } else {
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_DAILY);
                    }
                    if (Boolean.TRUE.equals(arisc.getUseWeekly())) {
                        arisc.setWeeklyTimerSettings(ArticleConsumptionInsert.this.createWeeklyTimerService());
                        ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getWeeklyTimerSettings()).getValue();
                        arisc.setWeeklyTimerSettings(ts);
                        arisc = (ArticleConsumptionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_WEEKLY, true, ts, -1L);
                    } else {
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_WEEKLY);
                    }
                    if (Boolean.TRUE.equals(arisc.getUseMonthly())) {
                        arisc.setMonthlyTimerSettings(ArticleConsumptionInsert.this.createMonthlyTimerService());
                        ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getMonthlyTimerSettings()).getValue();
                        arisc.setMonthlyTimerSettings(ts);
                        arisc = (ArticleConsumptionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_MONTHLY, true, ts, -1L);
                    } else {
                        ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_MONTHLY);
                    }
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                    ArticleConsumptionInsert.this.history.setNode(ArticleConsumptionInsert.this.articleConsumptionData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_DAILY);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_WEEKLY);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ARTICLE_CONSUMPTION_MONTHLY);
                    arisc = (ArticleConsumptionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                    ArticleConsumptionInsert.this.history.setNode(ArticleConsumptionInsert.this.articleConsumptionData);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ArticleConsumptionInsert.this.hideAnimation();
                        ArticleConsumptionInsert.this.module.ended();
                        ArticleConsumptionInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ArticleConsumptionInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticleConsumptionInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            ArticleConsumptionInsert.this.useArticleConsumptionSync.setLocation(border, border + ArticleConsumptionInsert.this.configPanel.getTitleHeight());
            ArticleConsumptionInsert.this.useArticleConsumptionSync.setSize(ArticleConsumptionInsert.this.useArticleConsumptionSync.getPreferredSize());
            ArticleConsumptionInsert.this.useDailyGenerator.setLocation(ArticleConsumptionInsert.this.useArticleConsumptionSync.getX(), ArticleConsumptionInsert.this.useArticleConsumptionSync.getY() + ArticleConsumptionInsert.this.useArticleConsumptionSync.getHeight() + border * 2);
            ArticleConsumptionInsert.this.useDailyGenerator.setSize(ArticleConsumptionInsert.this.useDailyGenerator.getPreferredSize());
            ArticleConsumptionInsert.this.useWeeklyGenerator.setLocation(ArticleConsumptionInsert.this.useArticleConsumptionSync.getX(), ArticleConsumptionInsert.this.useDailyGenerator.getY() + ArticleConsumptionInsert.this.useDailyGenerator.getHeight() + border);
            ArticleConsumptionInsert.this.useWeeklyGenerator.setSize(ArticleConsumptionInsert.this.useWeeklyGenerator.getPreferredSize());
            ArticleConsumptionInsert.this.useMonthlyGenerator.setLocation(ArticleConsumptionInsert.this.useArticleConsumptionSync.getX(), ArticleConsumptionInsert.this.useWeeklyGenerator.getY() + ArticleConsumptionInsert.this.useWeeklyGenerator.getHeight() + border);
            ArticleConsumptionInsert.this.useMonthlyGenerator.setSize(ArticleConsumptionInsert.this.useMonthlyGenerator.getPreferredSize());
            ArticleConsumptionInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - ArticleConsumptionInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + ArticleConsumptionInsert.this.saveButton.getPreferredSize().getHeight())));
            ArticleConsumptionInsert.this.saveButton.setSize(ArticleConsumptionInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticleConsumptionInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            ArticleConsumptionInsert.this.history.setLocation(0, ArticleConsumptionInsert.this.sendPanel.getTitleHeight());
            ArticleConsumptionInsert.this.history.setSize(parent.getWidth(), ArticleConsumptionInsert.this.sendPanel.getHeight() - (border + ArticleConsumptionInsert.this.sendPanel.getTitleHeight() + 100));
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (ArticleConsumptionInsert.this.animation != null) {
                ArticleConsumptionInsert.this.animation.setLocation((int)((double)parent.getWidth() - ArticleConsumptionInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ArticleConsumptionInsert.this.animation.getPreferredSize().getHeight()) / 2);
                ArticleConsumptionInsert.this.animation.setSize(ArticleConsumptionInsert.this.animation.getPreferredSize());
            }
            if (ArticleConsumptionInsert.this.isInserted) {
                ArticleConsumptionInsert.this.configPanel.setLocation(border, border);
                ArticleConsumptionInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                ArticleConsumptionInsert.this.sendPanel.setLocation(ArticleConsumptionInsert.this.configPanel.getX() + ArticleConsumptionInsert.this.configPanel.getWidth() + border, border);
                ArticleConsumptionInsert.this.sendPanel.setSize(ArticleConsumptionInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

