/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataValidationCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataValidationCheckSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DataValidationCheckExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private JPanelKillable contentPane;
    private TitledItem<CheckBox> useStockLevelCheck;
    private TitledItem<CheckBox> useInventoryRealDateCheck;
    private TitledItem<CheckBox> useChargesWithoutBatchesCheck;
    private TitledItem<CheckBox> useChargesWithOnlyIRBatchesCheck;
    private TablePanelAddSaveButton generateReportStockLevel;
    private TablePanelAddSaveButton generateReportInventoryDate;
    private TablePanelAddSaveButton generateReportChargeWithoutBatches;
    private TablePanelAddSaveButton generateReportChargeWithOnlyIRBatches;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<DataValidationCheckSettingsComplete> settings;
    protected DataValidationCheckSettingsComplete edsc;

    public DataValidationCheckExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.contentPane = new JPanelKillable();
        this.contentPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.setViewportView(this.contentPane);
        this.useStockLevelCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DataValidationCheckSettingsComplete_.useStockLevelCheck)), "Use Stock Level Check", TitledItem.TitledItemOrientation.EAST);
        this.useStockLevelCheck.getElement().addButtonListener(this);
        this.useInventoryRealDateCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DataValidationCheckSettingsComplete_.useInventoryRealDateCheck)), "Use Inventory Real Date Check", TitledItem.TitledItemOrientation.EAST);
        this.useInventoryRealDateCheck.getElement().addButtonListener(this);
        this.useChargesWithoutBatchesCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DataValidationCheckSettingsComplete_.useUnconsumedChargeWithoutBatches)), "Use Charge without Batches Check", TitledItem.TitledItemOrientation.EAST);
        this.useChargesWithoutBatchesCheck.getElement().addButtonListener(this);
        this.useChargesWithOnlyIRBatchesCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DataValidationCheckSettingsComplete_.useUnconsumedChargeWithOnlyIRBatches)), "Use Charge with only IR Batches Check", TitledItem.TitledItemOrientation.EAST);
        this.useChargesWithOnlyIRBatchesCheck.getElement().addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("Save");
        this.sendPanel.setHasBackground(true);
        this.generateReportStockLevel = new TablePanelAddSaveButton();
        this.generateReportStockLevel.setText("Stock Level");
        this.generateReportStockLevel.addButtonListener(this);
        this.generateReportChargeWithoutBatches = new TablePanelAddSaveButton();
        this.generateReportChargeWithoutBatches.setText("Charge w/o Batches");
        this.generateReportChargeWithoutBatches.addButtonListener(this);
        this.generateReportChargeWithOnlyIRBatches = new TablePanelAddSaveButton();
        this.generateReportChargeWithOnlyIRBatches.setText("Charge w IR Batches");
        this.generateReportChargeWithOnlyIRBatches.addButtonListener(this);
        this.generateReportInventoryDate = new TablePanelAddSaveButton();
        this.generateReportInventoryDate.setText("Inventory Date");
        this.generateReportInventoryDate.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.contentPane.setLayout(new ConfigLayout());
        this.configPanel.setLayout(new ScrollPaneLayout());
        this.contentPane.add(this.useStockLevelCheck);
        this.contentPane.add(this.useInventoryRealDateCheck);
        this.contentPane.add(this.useChargesWithoutBatchesCheck);
        this.contentPane.add(this.useChargesWithOnlyIRBatchesCheck);
        this.configPanel.add(this.scrollPane);
        this.sendPanel.add(this.saveButton);
        this.sendPanel.add(this.generateReportStockLevel);
        this.sendPanel.add(this.generateReportInventoryDate);
        this.sendPanel.add(this.generateReportChargeWithoutBatches);
        this.sendPanel.add(this.generateReportChargeWithOnlyIRBatches);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    DataValidationCheckExchangeInsert.this.edsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockLevelCheckSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataValidationCheckExchangeInsert.this.edsc.setTimerServiceSettingsStockLevel(DataValidationCheckExchangeInsert.this.createTimerServiceStockLevel());
                DataValidationCheckExchangeInsert.this.edsc.setTimerServiceSettingsInventoryRealDate(DataValidationCheckExchangeInsert.this.createTimerServiceInventoryRealDate());
                DataValidationCheckExchangeInsert.this.edsc.setTimerServiceSettingsChargeWithoutBatches(DataValidationCheckExchangeInsert.this.createTimerServiceChargeWithoutBatches());
                DataValidationCheckExchangeInsert.this.edsc.setTimerServiceSettingsChargeWithOnlyIRBatches(DataValidationCheckExchangeInsert.this.createTimerServiceChargeWithOnlyIRBatches());
                DataValidationCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)DataValidationCheckExchangeInsert.this.edsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return DataValidationCheckExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useStockLevelCheck.setEnabled(isEnabled);
            this.useInventoryRealDateCheck.setEnabled(isEnabled);
            this.useChargesWithoutBatchesCheck.setEnabled(isEnabled);
            this.useChargesWithOnlyIRBatchesCheck.setEnabled(isEnabled);
            this.generateReportStockLevel.setEnabled(isEnabled);
            this.generateReportChargeWithoutBatches.setEnabled(isEnabled);
            this.generateReportChargeWithOnlyIRBatches.setEnabled(isEnabled);
            this.generateReportInventoryDate.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.scrollPane.kill();
            this.saveButton.kill();
            this.useStockLevelCheck.kill();
            this.useInventoryRealDateCheck.kill();
            this.useChargesWithoutBatchesCheck.kill();
            this.useChargesWithOnlyIRBatchesCheck.kill();
            this.scrollPane = null;
            this.saveButton = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.useStockLevelCheck = null;
        this.useInventoryRealDateCheck = null;
        this.useChargesWithoutBatchesCheck = null;
        this.useChargesWithOnlyIRBatchesCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Data Validation Checker";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.generateReportStockLevel) {
            this.setEnabled(false);
            this.ensureAnimation("Check Stock Level Validation");
            this.processFiles(0);
            this.module.started();
            return;
        }
        if (source == this.generateReportInventoryDate) {
            this.setEnabled(false);
            this.ensureAnimation("Check Inventory without Real Date");
            this.processFiles(1);
            this.module.started();
            return;
        }
        if (source == this.generateReportChargeWithoutBatches) {
            this.setEnabled(false);
            this.ensureAnimation("Check Charges without Batches");
            this.processFiles(2);
            this.module.started();
            return;
        }
        if (source == this.generateReportChargeWithOnlyIRBatches) {
            this.setEnabled(false);
            this.ensureAnimation("Check Charges with only IR Batches");
            this.processFiles(3);
            this.module.started();
            return;
        }
        if (source != this.saveButton) {
            this.setEnabled(this.isEnabled());
            return;
        }
        List<ScreenValidationObject> a = this.validateLevelCheck();
        if (a.isEmpty()) {
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            return;
        }
        InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
        this.setEnabled(true);
    }

    private List<ScreenValidationObject> validateLevelCheck() {
        return new ArrayList<ScreenValidationObject>();
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                TimerServiceSettingsComplete ts;
                DataValidationCheckExchangeInsert.this.settings.commit(DataValidationCheckSettingsComplete.class);
                DataValidationCheckSettingsComplete rimsc = (DataValidationCheckSettingsComplete)DataValidationCheckExchangeInsert.this.settings.getValue();
                rimsc.setTimerServiceSettingsStockLevel(DataValidationCheckExchangeInsert.this.createTimerServiceStockLevel());
                rimsc.setTimerServiceSettingsInventoryRealDate(DataValidationCheckExchangeInsert.this.createTimerServiceInventoryRealDate());
                rimsc.setTimerServiceSettingsChargeWithoutBatches(DataValidationCheckExchangeInsert.this.createTimerServiceChargeWithoutBatches());
                if (Boolean.TRUE.equals(rimsc.getUseStockLevelCheck())) {
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceSettingsStockLevel()).getValue();
                    rimsc.setTimerServiceSettingsStockLevel(ts);
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.STOCK_LEVEL_CHECKER, rimsc.getUseStockLevelCheck().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.STOCK_LEVEL_CHECKER);
                    rimsc = (DataValidationCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                if (Boolean.TRUE.equals(rimsc.getUseInventoryRealDateCheck())) {
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceSettingsInventoryRealDate()).getValue();
                    rimsc.setTimerServiceSettingsInventoryRealDate(ts);
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.INVENTORY_REAL_DATE_CHECKER, rimsc.getUseInventoryRealDateCheck().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.INVENTORY_REAL_DATE_CHECKER);
                    rimsc = (DataValidationCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                if (Boolean.TRUE.equals(rimsc.getUseUnconsumedChargeWithoutBatches())) {
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceSettingsChargeWithoutBatches()).getValue();
                    rimsc.setTimerServiceSettingsChargeWithoutBatches(ts);
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.INCONSISTENT_CHARGE_CHECKER, rimsc.getUseUnconsumedChargeWithoutBatches().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.INCONSISTENT_CHARGE_CHECKER);
                    rimsc = (DataValidationCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                if (Boolean.TRUE.equals(rimsc.getUseUnconsumedChargeWithOnlyIRBatches())) {
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceSettingsChargeWithOnlyIRBatches()).getValue();
                    rimsc.setTimerServiceSettingsChargeWithOnlyIRBatches(ts);
                    rimsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockLevelCheckSettings(rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.CHARGE_WITH_ONLY_IR_BATCHES_CHECKER, rimsc.getUseUnconsumedChargeWithoutBatches().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.CHARGE_WITH_ONLY_IR_BATCHES_CHECKER);
                    rimsc = (DataValidationCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        DataValidationCheckExchangeInsert.this.hideAnimation();
                        DataValidationCheckExchangeInsert.this.module.ended();
                        DataValidationCheckExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)DataValidationCheckExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceStockLevel() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(2), Integer.valueOf(50)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceInventoryRealDate() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(DayOfWeekE.SUNDAY, Integer.valueOf(2), Integer.valueOf(40), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceChargeWithoutBatches() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(DayOfWeekE.SUNDAY, Integer.valueOf(2), Integer.valueOf(30), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private TimerServiceSettingsComplete createTimerServiceChargeWithOnlyIRBatches() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfWeekTimeComplete(DayOfWeekE.SATURDAY, Integer.valueOf(2), Integer.valueOf(10), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void processFiles(final int type) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                switch (type) {
                    case 0: {
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateStockLevelCheck();
                        break;
                    }
                    case 1: {
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateInventoryDateCheck();
                        break;
                    }
                    case 2: {
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateChargeWithoutBatchesCheck();
                        break;
                    }
                    case 3: {
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateChargeWithOnlyIRBatchesCheck();
                    }
                }
                n.setValue((Object)true, 0L);
                DataValidationCheckExchangeInsert.this.edsc = (DataValidationCheckSettingsComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockLevelCheckSettings().getValue();
                DataValidationCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)DataValidationCheckExchangeInsert.this.edsc, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        DataValidationCheckExchangeInsert.this.hideAnimation();
                        DataValidationCheckExchangeInsert.this.module.ended();
                        DataValidationCheckExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, DataValidationCheckExchangeInsert.this.generateReportStockLevel);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_EDELWEISS_IMPORT, (Component)DataValidationCheckExchangeInsert.this.generateReportStockLevel);
                        DataValidationCheckExchangeInsert.this.hideAnimation();
                        DataValidationCheckExchangeInsert.this.setEnabled(true);
                        DataValidationCheckExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ScrollPaneLayout
    extends DefaultLayout {
        private ScrollPaneLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            DataValidationCheckExchangeInsert.this.configPanel.layoutTitle(parent);
            DataValidationCheckExchangeInsert.this.scrollPane.setLocation(1, DataValidationCheckExchangeInsert.this.configPanel.getTitleHeight());
            DataValidationCheckExchangeInsert.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - (DataValidationCheckExchangeInsert.this.configPanel.getTitleHeight() + 1));
        }
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            DataValidationCheckExchangeInsert.this.useStockLevelCheck.setLocation(border, border);
            DataValidationCheckExchangeInsert.this.useStockLevelCheck.setSize(DataValidationCheckExchangeInsert.this.useStockLevelCheck.getPreferredSize());
            DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.setLocation(border, DataValidationCheckExchangeInsert.this.useStockLevelCheck.getY() + DataValidationCheckExchangeInsert.this.useStockLevelCheck.getHeight() + border);
            DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.setSize(DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.getPreferredSize());
            DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.setLocation(border, DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.getY() + DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.getHeight() + border);
            DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.setSize(DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.getPreferredSize());
            DataValidationCheckExchangeInsert.this.useChargesWithOnlyIRBatchesCheck.setLocation(border, DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.getY() + DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.getHeight() + border);
            DataValidationCheckExchangeInsert.this.useChargesWithOnlyIRBatchesCheck.setSize(DataValidationCheckExchangeInsert.this.useChargesWithOnlyIRBatchesCheck.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            h = (int)((double)h + DataValidationCheckExchangeInsert.this.useStockLevelCheck.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + DataValidationCheckExchangeInsert.this.useInventoryRealDateCheck.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + DataValidationCheckExchangeInsert.this.useChargesWithoutBatchesCheck.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + DataValidationCheckExchangeInsert.this.useChargesWithOnlyIRBatchesCheck.getPreferredSize().getHeight());
            return new Dimension(0, h += border);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DataValidationCheckExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            DataValidationCheckExchangeInsert.this.generateReportStockLevel.setLocation(border, (int)((double)parent.getHeight() - (DataValidationCheckExchangeInsert.this.generateReportStockLevel.getPreferredSize().getHeight() + (double)border)));
            DataValidationCheckExchangeInsert.this.generateReportStockLevel.setSize(DataValidationCheckExchangeInsert.this.generateReportStockLevel.getPreferredSize());
            DataValidationCheckExchangeInsert.this.generateReportInventoryDate.setLocation(border, (int)((double)DataValidationCheckExchangeInsert.this.generateReportStockLevel.getY() - ((double)border + DataValidationCheckExchangeInsert.this.generateReportInventoryDate.getPreferredSize().getHeight())));
            DataValidationCheckExchangeInsert.this.generateReportInventoryDate.setSize(DataValidationCheckExchangeInsert.this.generateReportInventoryDate.getPreferredSize());
            DataValidationCheckExchangeInsert.this.generateReportChargeWithoutBatches.setLocation(border, (int)((double)DataValidationCheckExchangeInsert.this.generateReportInventoryDate.getY() - ((double)border + DataValidationCheckExchangeInsert.this.generateReportChargeWithoutBatches.getPreferredSize().getHeight())));
            DataValidationCheckExchangeInsert.this.generateReportChargeWithoutBatches.setSize(DataValidationCheckExchangeInsert.this.generateReportChargeWithoutBatches.getPreferredSize());
            DataValidationCheckExchangeInsert.this.generateReportChargeWithOnlyIRBatches.setLocation(border, (int)((double)DataValidationCheckExchangeInsert.this.generateReportChargeWithoutBatches.getY() - ((double)border + DataValidationCheckExchangeInsert.this.generateReportChargeWithOnlyIRBatches.getPreferredSize().getHeight())));
            DataValidationCheckExchangeInsert.this.generateReportChargeWithOnlyIRBatches.setSize(DataValidationCheckExchangeInsert.this.generateReportChargeWithOnlyIRBatches.getPreferredSize());
            DataValidationCheckExchangeInsert.this.saveButton.setLocation(DataValidationCheckExchangeInsert.this.generateReportStockLevel.getX() + DataValidationCheckExchangeInsert.this.generateReportStockLevel.getWidth() + border, DataValidationCheckExchangeInsert.this.generateReportStockLevel.getY());
            DataValidationCheckExchangeInsert.this.saveButton.setSize(DataValidationCheckExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (DataValidationCheckExchangeInsert.this.animation != null) {
                DataValidationCheckExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - DataValidationCheckExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - DataValidationCheckExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                DataValidationCheckExchangeInsert.this.animation.setSize(DataValidationCheckExchangeInsert.this.animation.getPreferredSize());
            }
            if (DataValidationCheckExchangeInsert.this.isInserted) {
                DataValidationCheckExchangeInsert.this.configPanel.setLocation(border, border);
                DataValidationCheckExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                DataValidationCheckExchangeInsert.this.sendPanel.setLocation(DataValidationCheckExchangeInsert.this.configPanel.getX() + DataValidationCheckExchangeInsert.this.configPanel.getWidth() + border, border);
                DataValidationCheckExchangeInsert.this.sendPanel.setSize(DataValidationCheckExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

