/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.YourBarMateServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.yourbarmate.YourBarMateSettingsComplete;
import ch.icit.pegasus.server.core.dtos.yourbarmate.YourBarMateSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class YourBarMateOrderImportInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> active;
    private TitledItem<TextField> defaultFlightName;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> stowingList;
    private TitledItem<CheckBox> processIncompleteFlights;
    private TitledItem<CheckBox> sendNotificationForIncompleteFlights;
    private TitledItem<CheckBox> sendNotificationForCompleteFlights;
    private TitledItem<TextField> notificationAddressesWarnings;
    private TitledItem<TextField> notificationAddressesSuccess;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<YourBarMateSettingsComplete> settings;
    protected YourBarMateSettingsComplete arisc;

    public YourBarMateOrderImportInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(YourBarMateSettingsComplete_.active)), "Enable Your Bar Mate Interface", TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.defaultFlightName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(YourBarMateSettingsComplete_.defaultFlightName)), "Default Flight Name", TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(false, this.settings.getChildNamed(YourBarMateSettingsComplete_.customer)), "Your Bar Mate Customer", TitledItem.TitledItemOrientation.NORTH);
        this.stowingList = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, this.settings.getChildNamed(YourBarMateSettingsComplete_.defaultAdHocStowing)), "Default Stowing List", TitledItem.TitledItemOrientation.NORTH);
        this.processIncompleteFlights = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(YourBarMateSettingsComplete_.processIncompleteFlights)), "Process incomplete Flights", TitledItem.TitledItemOrientation.EAST);
        this.sendNotificationForIncompleteFlights = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(YourBarMateSettingsComplete_.sendNotificationForIncompleteFlights)), "Send Notification for incomplete Flights", TitledItem.TitledItemOrientation.EAST);
        this.sendNotificationForCompleteFlights = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(YourBarMateSettingsComplete_.sendNotificationForCompleteFlights)), "Send Notification for complete Flights", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddressesWarnings = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(YourBarMateSettingsComplete_.notificationAddressesError)), "Error Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.notificationAddressesSuccess = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(YourBarMateSettingsComplete_.notificationAddressesSuccess)), "Success Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.active);
        this.configPanel.add(this.defaultFlightName);
        this.configPanel.add(this.customer);
        this.configPanel.add(this.stowingList);
        this.configPanel.add(this.processIncompleteFlights);
        this.configPanel.add(this.sendNotificationForIncompleteFlights);
        this.configPanel.add(this.sendNotificationForCompleteFlights);
        this.configPanel.add(this.notificationAddressesWarnings);
        this.configPanel.add(this.notificationAddressesSuccess);
        this.configPanel.add(this.saveButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    YourBarMateOrderImportInsert.this.arisc = (YourBarMateSettingsComplete)((YourBarMateServiceManager)ServiceManagerRegistry.getService(YourBarMateServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (YourBarMateOrderImportInsert.this.arisc == null) {
                    YourBarMateSettingsComplete s = new YourBarMateSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    YourBarMateOrderImportInsert.this.arisc = s;
                }
                YourBarMateOrderImportInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)YourBarMateOrderImportInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return YourBarMateOrderImportInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.defaultFlightName.setEnabled(b);
            this.processIncompleteFlights.setEnabled(b);
            this.sendNotificationForIncompleteFlights.setEnabled(b);
            this.notificationAddressesWarnings.setEnabled(b);
            this.sendNotificationForCompleteFlights.setEnabled(b);
            this.notificationAddressesSuccess.setEnabled(b);
            this.customer.setEnabled(b);
            this.stowingList.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.stowingList.kill();
            this.saveButton.kill();
            this.active.kill();
            this.defaultFlightName.kill();
            this.customer.kill();
            this.processIncompleteFlights.kill();
            this.sendNotificationForIncompleteFlights.kill();
            this.notificationAddressesWarnings.kill();
            this.sendNotificationForCompleteFlights.kill();
            this.notificationAddressesSuccess.kill();
        }
        this.sendNotificationForCompleteFlights = null;
        this.notificationAddressesSuccess = null;
        this.processIncompleteFlights = null;
        this.sendNotificationForIncompleteFlights = null;
        this.notificationAddressesWarnings = null;
        this.defaultFlightName = null;
        this.customer = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.stowingList = null;
        this.saveButton = null;
        this.active = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Your Bar Mate Interface";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                YourBarMateOrderImportInsert.this.settings.commit(YourBarMateSettingsComplete.class);
                YourBarMateSettingsComplete arisc = (YourBarMateSettingsComplete)YourBarMateOrderImportInsert.this.settings.getValue();
                arisc = (YourBarMateSettingsComplete)((YourBarMateServiceManager)ServiceManagerRegistry.getService(YourBarMateServiceManager.class)).updateSettings(arisc).getValue();
                YourBarMateOrderImportInsert.this.settings.setValue((Object)arisc, 0L);
                return YourBarMateOrderImportInsert.this.settings;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        YourBarMateOrderImportInsert.this.hideAnimation();
                        YourBarMateOrderImportInsert.this.module.ended();
                        YourBarMateOrderImportInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)YourBarMateOrderImportInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            YourBarMateOrderImportInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            YourBarMateOrderImportInsert.this.active.setLocation(border, border + YourBarMateOrderImportInsert.this.configPanel.getTitleHeight());
            YourBarMateOrderImportInsert.this.active.setSize(YourBarMateOrderImportInsert.this.active.getPreferredSize());
            YourBarMateOrderImportInsert.this.defaultFlightName.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.active.getY() + YourBarMateOrderImportInsert.this.active.getHeight() + border * 2);
            YourBarMateOrderImportInsert.this.defaultFlightName.setSize(300, (int)YourBarMateOrderImportInsert.this.defaultFlightName.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.customer.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.defaultFlightName.getY() + YourBarMateOrderImportInsert.this.defaultFlightName.getHeight() + border);
            YourBarMateOrderImportInsert.this.customer.setSize(300, (int)YourBarMateOrderImportInsert.this.customer.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.stowingList.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.customer.getY() + YourBarMateOrderImportInsert.this.customer.getHeight() + border);
            YourBarMateOrderImportInsert.this.stowingList.setSize(300, (int)YourBarMateOrderImportInsert.this.stowingList.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.processIncompleteFlights.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.stowingList.getY() + YourBarMateOrderImportInsert.this.stowingList.getHeight() + border);
            YourBarMateOrderImportInsert.this.processIncompleteFlights.setSize(300, (int)YourBarMateOrderImportInsert.this.processIncompleteFlights.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.sendNotificationForIncompleteFlights.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.processIncompleteFlights.getY() + YourBarMateOrderImportInsert.this.processIncompleteFlights.getHeight() + border);
            YourBarMateOrderImportInsert.this.sendNotificationForIncompleteFlights.setSize(300, (int)YourBarMateOrderImportInsert.this.sendNotificationForIncompleteFlights.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.sendNotificationForCompleteFlights.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.sendNotificationForIncompleteFlights.getY() + YourBarMateOrderImportInsert.this.sendNotificationForIncompleteFlights.getHeight() + border);
            YourBarMateOrderImportInsert.this.sendNotificationForCompleteFlights.setSize(300, (int)YourBarMateOrderImportInsert.this.sendNotificationForCompleteFlights.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.notificationAddressesWarnings.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.sendNotificationForCompleteFlights.getY() + YourBarMateOrderImportInsert.this.sendNotificationForCompleteFlights.getHeight() + border);
            YourBarMateOrderImportInsert.this.notificationAddressesWarnings.setSize(300, (int)YourBarMateOrderImportInsert.this.notificationAddressesWarnings.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.notificationAddressesSuccess.setLocation(YourBarMateOrderImportInsert.this.active.getX(), YourBarMateOrderImportInsert.this.notificationAddressesWarnings.getY() + YourBarMateOrderImportInsert.this.notificationAddressesWarnings.getHeight() + border);
            YourBarMateOrderImportInsert.this.notificationAddressesSuccess.setSize(300, (int)YourBarMateOrderImportInsert.this.notificationAddressesSuccess.getPreferredSize().getHeight());
            YourBarMateOrderImportInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - ((double)border + YourBarMateOrderImportInsert.this.saveButton.getPreferredSize().getHeight())));
            YourBarMateOrderImportInsert.this.saveButton.setSize(YourBarMateOrderImportInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            YourBarMateOrderImportInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (YourBarMateOrderImportInsert.this.animation != null) {
                YourBarMateOrderImportInsert.this.animation.setLocation((int)((double)parent.getWidth() - YourBarMateOrderImportInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - YourBarMateOrderImportInsert.this.animation.getPreferredSize().getHeight()) / 2);
                YourBarMateOrderImportInsert.this.animation.setSize(YourBarMateOrderImportInsert.this.animation.getPreferredSize());
            }
            if (YourBarMateOrderImportInsert.this.isInserted) {
                YourBarMateOrderImportInsert.this.configPanel.setLocation(border, border);
                YourBarMateOrderImportInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                YourBarMateOrderImportInsert.this.sendPanel.setLocation(YourBarMateOrderImportInsert.this.configPanel.getX() + YourBarMateOrderImportInsert.this.configPanel.getWidth() + border, border);
                YourBarMateOrderImportInsert.this.sendPanel.setSize(YourBarMateOrderImportInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

