/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.documentscan;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.gui.modules.documentscan.DocumentScanModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.documentscan.detail.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.documentscan.detail.InformationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.documentscan.detail.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.DocumentScanSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanLight;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.DocumentScanAccess;
import ch.icit.pegasus.server.core.dtos.search.DocumentScanSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class DocumentScanModule
extends ScreenTableView<DocumentScanLight, DocumentScanSearchConfiguration.DOCUMENT_SCAN_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_DESCRIPTION = "description";
    private static final String FILTER_CONTENT_TEXT = "contentText";
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_VALIDATION = "validation_filter";
    private PeriodComplete filterCriteria2;
    private String descriptionFilter;
    private String contentFilter;
    private Boolean validationFilter;
    private TitledPeriodEditor p;

    public DocumentScanModule() {
        super(DocumentScanLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.p.kill();
        this.p = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return DocumentScanAccess.MODULE_DOCUMENT_SCAN;
    }

    @Override
    protected boolean showDeletedComboBox() {
        return false;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", DocumentScanSearchConfiguration.DOCUMENT_SCAN_COLUMN.DATE.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_DESCRIPTION, Words.DESCRIPTION, "");
        this.filterChain.addSearchField(FILTER_CONTENT_TEXT, Words.CONTENT, "");
        ComboBox yesNo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(yesNo, FILTER_VALIDATION, Words.STATE, Words.ALL);
        this.p = this.filterChain.addPeriodSelection(FILTER_DATE, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        this.p.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<DocumentScanLight, DocumentScanSearchConfiguration.DOCUMENT_SCAN_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean emptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria2 = null;
            this.contentFilter = null;
            this.descriptionFilter = null;
            this.validationFilter = null;
        } else if (name == FILTER_DATE) {
            PeriodComplete per;
            this.filterCriteria2 = per = new PeriodComplete(this.p.getStartDate(), this.p.getEndDate());
        } else if (name == FILTER_CONTENT_TEXT) {
            this.contentFilter = (String)value;
        } else if (name == FILTER_DESCRIPTION) {
            this.descriptionFilter = (String)value;
        } else if (name == FILTER_VALIDATION) {
            this.validationFilter = value.equals(Words.YES) ? Boolean.valueOf(true) : (value.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null);
        }
        DocumentScanSearchConfiguration c = new DocumentScanSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.filterCriteria2);
        c.setDescription(this.descriptionFilter);
        c.setContent(this.contentFilter);
        c.setValidation(this.validationFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<DocumentScanLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(DocumentScanSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<DocumentScanLight> model) {
        return model != null && model.getDTO(DocumentScanLight.class) != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    public boolean isDeletable(RowModel<DocumentScanLight> model) {
        return false;
    }

    @Override
    public boolean hasAddAccess() {
        return false;
    }

    @Override
    protected RowEditorFactory<DocumentScanLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<DocumentScanLight> rowEditor = new MessageProvidedRowEditor<DocumentScanLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                ConfigurationDetailsPanel d1 = new ConfigurationDetailsPanel((RowEditor<DocumentScanLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
            } else {
                SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<DocumentScanLight>)rowEditor, p);
                InformationDetailsPanel d2 = new InformationDetailsPanel((RowEditor<DocumentScanLight>)rowEditor, p);
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d1);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new DocumentScanModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", (Class)StringConverter.class, (Enum<?>)DocumentScanSearchConfiguration.DOCUMENT_SCAN_COLUMN.DESCRIPTION, DocumentScanLight_.description, TableColumnInfo.dateTimeColumnWidth, Integer.MAX_VALUE, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.CREATION_USER, "", (Class)UserConverter.class, null, DocumentScanLight_.creationUser, TableColumnInfo.userColumnWidth));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)DocumentScanSearchConfiguration.DOCUMENT_SCAN_COLUMN.DATE, DocumentScanLight_.creationDate, TableColumnInfo.dateTimeColumnWidth));
        return columns;
    }
}

