/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.documentscan.detail;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete_;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanLight;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<DocumentScanLight>
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<FileChooserPanel> file;

    public ConfigurationDetailsPanel(RowEditor<DocumentScanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.file = new TitledItem<FileChooserPanel>(new FileChooserPanel(false, Words.CHOOSE, "", false), Words.FILE, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.file);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.file);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        this.file.getElement().setNode(node.getChildNamed(DocumentScanComplete_.fileData));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        PegasusFileComplete gr = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(DocumentScanComplete_.fileData).getValue();
        if (gr != null && gr.getLocalFile() != null) {
            FileCommitter c = new FileCommitter(gr.getLocalFile(), FileCategoryE.DOCUMENT);
            c.setWriteBackAlgorithm(reference -> {
                this.editor.getModel().getNode().getChildNamed(DocumentScanComplete_.fileData).setValue((Object)reference, 0L);
                ((DocumentScanComplete)this.editor.getModel().getNode().getValue()).setFileData(reference);
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.file.kill();
        this.file = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.file.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.file.getElement().getNode().getValue() == null || ((PegasusFileComplete)this.file.getElement().getNode().getValue()).getLocalFile() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Document Scan file is selected"));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.file.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.file.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.file.setSize(400, (int)ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = ConfigurationDetailsPanel.this.verticalBorder;
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            return new Dimension(0, lh += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

