/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.GalleyEquipmentConverter3;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.SealTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BondedEquipmentSealsDetailsPanel
extends TableDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;

    public BondedEquipmentSealsDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, false);
        this.setTitleText(Words.BONDED_SEALS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.6, 0.0, Words.EQUIPMENT, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.COLOR, null, null, null, "", 200, 200, 200));
        headers.add(new TableColumnInfo(0.4, 0.0, Words.DOOR_1, null, null, null, "", 120, 120, 120));
        return headers;
    }

    @Override
    public void setNode(Node<?> node) {
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        if (n != null) {
            Node innerNode;
            StowingListLight stowing = null;
            if (node != null && (innerNode = node.getChildNamed(FlightComplete_.activeStowingList)) != null) {
                stowing = (StowingListLight)innerNode.getValue();
            }
            if (stowing == null) {
                return;
            }
            ViewNode seals = new ViewNode("EquipmentSeals");
            Iterator it = n.getChildNamed(FlightSealsComplete_.equipments).getFailSafeChildIterator();
            while (it.hasNext()) {
                int i;
                Node nx = (Node)it.next();
                if (!Boolean.TRUE.equals(((EquipmentSealsComplete)nx.getValue(EquipmentSealsComplete.class)).getEquipment().getSealIsMandatory())) continue;
                seals.addChild(nx, 0L);
                if (!((EquipmentSealsComplete)nx.getValue()).getSeals().isEmpty()) continue;
                ColorComplete defaultColor = (ColorComplete)((List)NodeToolkit.getAffixList(ColorComplete.class).getValue()).get(0);
                for (i = 0; i < ((EquipmentSealsComplete)nx.getValue()).getEquipment().getEquipmentType().getNumberOfSeals() * stowing.getDefaultBoundedInboundSeals(); ++i) {
                    SealComplete inSeal = new SealComplete();
                    inSeal.setClientOId(Long.valueOf(ADTO.getNextId()));
                    inSeal.setType(SealTypeE.INBOUND);
                    inSeal.setSequenceNumber(Integer.valueOf(i));
                    inSeal.setSealNumber(Integer.valueOf(i));
                    inSeal.setColor(defaultColor);
                    if (i % 2 == 0) {
                        inSeal.setIdentifier("Front");
                    } else {
                        inSeal.setIdentifier("Rear");
                    }
                    ArrayList<SealComplete> inSeals = (ArrayList<SealComplete>)((EquipmentSealsComplete)nx.getValue()).getSeals().get(SealTypeE.INBOUND);
                    if (inSeals == null) {
                        inSeals = new ArrayList<SealComplete>();
                        ((EquipmentSealsComplete)nx.getValue()).getSeals().put(SealTypeE.INBOUND, inSeals);
                    }
                    inSeals.add(inSeal);
                }
                for (i = 0; i < ((EquipmentSealsComplete)nx.getValue()).getEquipment().getEquipmentType().getNumberOfSeals() * stowing.getDefaultBoundedOutboundSeals(); ++i) {
                    SealComplete outSeal = new SealComplete();
                    outSeal.setClientOId(Long.valueOf(ADTO.getNextId()));
                    outSeal.setType(SealTypeE.OUTBOUND);
                    outSeal.setSequenceNumber(Integer.valueOf(i));
                    outSeal.setSealNumber(Integer.valueOf(i));
                    outSeal.setColor(defaultColor);
                    if (i % 2 == 0) {
                        outSeal.setIdentifier("Front");
                    } else {
                        outSeal.setIdentifier("Rear");
                    }
                    ArrayList<SealComplete> outSeals = (ArrayList<SealComplete>)((EquipmentSealsComplete)nx.getValue()).getSeals().get(SealTypeE.OUTBOUND);
                    if (outSeals == null) {
                        outSeals = new ArrayList<SealComplete>();
                        ((EquipmentSealsComplete)nx.getValue()).getSeals().put(SealTypeE.OUTBOUND, outSeals);
                    }
                    outSeals.add(outSeal);
                }
            }
            this.table.getModel().setNode((Node)seals);
        }
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        for (Table2RowPanel table2RowPanel : this.table.getRows()) {
            TableRowImpl row = (TableRowImpl)table2RowPanel;
            row.getModel().getNode().commitThis();
            EquipmentSealsComplete seal = (EquipmentSealsComplete)row.getModel().getNode().getValue();
            for (Map.Entry s : seal.getSeals().entrySet()) {
                for (SealComplete sealComplete : (List)s.getValue()) {
                    Node sealNode = INodeCreator.getDefaultImpl().getNodeDirectly((Object)sealComplete);
                    sealNode.commitThis();
                }
            }
        }
        return super.commitParagraph();
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel equipment;
        private List<UIHelper> seals;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.seals = new ArrayList<UIHelper>();
            this.setLayout(new Layout());
            this.equipment = new TextLabel(m.getNode().getChildNamed(EquipmentSealsComplete_.equipment), ConverterRegistry.getConverter(GalleyEquipmentConverter3.class));
            Map sealMap = (Map)m.getNode().getChildNamed(EquipmentSealsComplete_.seals).getValue();
            for (Map.Entry entry : sealMap.entrySet()) {
                for (SealComplete s : (List)entry.getValue()) {
                    String text = "";
                    String door = s.getIdentifier();
                    text = entry.getKey() == SealTypeE.INBOUND ? Words.IN : Words.OUT;
                    Node sealNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)s, true, false);
                    TitledItem<ComboBox> sealColor = new TitledItem<ComboBox>(new ComboBox(sealNode.getChildNamed(SealComplete_.color), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class)), text, TitledItem.TitledItemOrientation.WEST);
                    TitledItem<TextField> sealNo = new TitledItem<TextField>(new TextField(sealNode.getChildNamed(SealComplete_.sealNumber), TextFieldType.INT), door, TitledItem.TitledItemOrientation.WEST);
                    sealColor.setIgnorePrefWidth(true);
                    sealNo.setIgnorePrefWidth(true);
                    UIHelper helper = new UIHelper();
                    helper.color = sealColor;
                    helper.seal1 = sealNo;
                    this.add(sealColor);
                    this.add(sealNo);
                    this.seals.add(helper);
                }
            }
            this.add(this.equipment);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            for (UIHelper helper : this.seals) {
                CheckedListAdder.addToList(focusList, helper.color);
                CheckedListAdder.addToList(focusList, helper.seal1);
            }
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.equipment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)TableRowImpl.this.getDefaultRowHeight() - TableRowImpl.this.equipment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.equipment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.equipment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int nextW = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                int currentY = 0;
                for (UIHelper helper : TableRowImpl.this.seals) {
                    helper.color.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)((double)currentY + ((double)TableRowImpl.this.getDefaultRowHeight() - helper.color.getPreferredSize().getHeight()) / 2.0));
                    helper.color.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)helper.color.getPreferredSize().getHeight());
                    helper.seal1.setLocation(currentX + w + TableRowImpl.this.getCellPadding(), (int)((double)currentY + ((double)TableRowImpl.this.getDefaultRowHeight() - helper.seal1.getPreferredSize().getHeight()) / 2.0));
                    helper.seal1.setSize(nextW - 2 * TableRowImpl.this.getCellPadding(), (int)helper.seal1.getPreferredSize().getHeight());
                    currentY += TableRowImpl.this.getDefaultRowHeight();
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.seals.size() * TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class UIHelper {
        TitledItem<ComboBox> color;
        TitledItem<TextField> seal1;

        private UIHelper() {
        }
    }
}

