/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DelaysDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements TextFieldListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private TitledItem<RDTextField> std;
    private TitledItem<RDTextField> sta;
    private TitledItem<RDTextField> gate;
    private TitledItem<RDTextField> barSetNumber;
    private TitledItem<RDTextField> touchPCNumbers;
    private final FlightEditableChecker checker = new FlightEditableChecker();
    private TitledItem<RDCheckBox> transitDelivery;
    private TitledItem<DateTimeChooser> deliveryDate;
    private TitledItem<DateTimeChooser> returnDate;
    private TitledItem<RDCheckBox> fillEmptyEquipments;
    private TitledItem<RDTextField> shortCode;
    private TitledItem<DateTimeChooser> kitchenReadyTime;

    public DelaysDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ACTUAL_FLIGHT_DATA);
        this.std = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), Words.ACTUAL_STD, TitledItem.TitledItemOrientation.NORTH);
        this.sta = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), Words.ACTUAL_STA, TitledItem.TitledItemOrientation.NORTH);
        this.std.getElement().addTextFieldListener(this);
        this.sta.getElement().addTextFieldListener(this);
        this.transitDelivery = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.TRANSIT_DELIVERY, TitledItem.TitledItemOrientation.EAST);
        this.transitDelivery.getElement().addButtonListener(this);
        this.deliveryDate = new TitledItem<DateTimeChooser>(new DateTimeChooser(null), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.returnDate = new TitledItem<DateTimeChooser>(new DateTimeChooser(null), Words.RETURN_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.gate = new TitledItem<RDTextField>(new RDTextField(provider), Words.GATE, TitledItem.TitledItemOrientation.NORTH);
        this.barSetNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.BAR_SET_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.touchPCNumbers = new TitledItem<RDTextField>(new RDTextField(provider), Words.TOUCH_PC, TitledItem.TitledItemOrientation.NORTH);
        this.kitchenReadyTime = new TitledItem<DateTimeChooser>(new DateTimeChooser(null), Words.KITCHEN_READY_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.shortCode = new TitledItem<RDTextField>(new RDTextField(provider), Words.SHORT_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.fillEmptyEquipments = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.LOAD_EMPTY_EQUIPMENTS, TitledItem.TitledItemOrientation.EAST);
        this.addToView(this.std);
        this.addToView(this.sta);
        this.addToView(this.deliveryDate);
        this.addToView(this.returnDate);
        this.addToView(this.gate);
        this.addToView(this.barSetNumber);
        this.addToView(this.touchPCNumbers);
        this.addToView(this.fillEmptyEquipments);
        this.addToView(this.shortCode);
        this.addToView(this.transitDelivery);
        this.addToView(this.kitchenReadyTime);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void requestFocusInWindowNow() {
        this.std.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(enabled);
        this.std.setEnabled(enabled);
        this.sta.setEnabled(enabled);
        this.gate.setEnabled(enabled);
        this.barSetNumber.setEnabled(enabled);
        this.touchPCNumbers.setEnabled(enabled);
        this.fillEmptyEquipments.setEnabled(enabled);
        this.shortCode.setEnabled(enabled);
        this.kitchenReadyTime.setEnabled(enabled);
        boolean writable = this.provider.isWritable(FlightComplete_.deliveryDate) && this.transitDelivery.getElement().isChecked();
        boolean writable2 = this.provider.isWritable(FlightComplete_.returnDate) && this.transitDelivery.getElement().isChecked();
        this.deliveryDate.setEnabled(isEnabled && writable);
        this.returnDate.setEnabled(isEnabled && writable2);
        this.transitDelivery.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.std.kill();
        this.sta.kill();
        this.gate.kill();
        this.fillEmptyEquipments.kill();
        this.touchPCNumbers.kill();
        this.shortCode.kill();
        this.deliveryDate.kill();
        this.returnDate.kill();
        this.transitDelivery.kill();
        this.kitchenReadyTime.kill();
        this.std = null;
        this.sta = null;
        this.gate = null;
        this.barSetNumber = null;
        this.fillEmptyEquipments = null;
        this.touchPCNumbers = null;
        this.shortCode = null;
        this.deliveryDate = null;
        this.returnDate = null;
        this.transitDelivery = null;
        this.kitchenReadyTime = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.sta);
        CheckedListAdder.addToList(focusList, this.std);
        CheckedListAdder.addToList(focusList, this.kitchenReadyTime);
        CheckedListAdder.addToList(focusList, this.transitDelivery);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.returnDate);
        CheckedListAdder.addToList(focusList, this.gate);
        CheckedListAdder.addToList(focusList, this.shortCode);
        CheckedListAdder.addToList(focusList, this.barSetNumber);
        CheckedListAdder.addToList(focusList, this.touchPCNumbers);
        CheckedListAdder.addToList(focusList, this.fillEmptyEquipments);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.root = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if (node != null) {
            this.std.getElement().setNode(node.getChildNamed(FlightComplete_.realstd));
            this.sta.getElement().setNode(node.getChildNamed(FlightComplete_.realsta));
            Node deliveryDateNode = node.getChildNamed(FlightComplete_.deliveryDate);
            if (deliveryDateNode != null && deliveryDateNode.getValue() == null) {
                deliveryDateNode.setValue((Object)new Timestamp(((Timestamp)node.getChildNamed(FlightComplete_.std).getValue()).getTime()), 0L);
            }
            if (node.getChildNamed(FlightComplete_.returnDate) != null && node.getChildNamed(FlightComplete_.returnDate) != null && node.getChildNamed(FlightComplete_.returnDate).getValue() == null) {
                node.getChildNamed(FlightComplete_.returnDate).setValue((Object)new Timestamp(((Timestamp)node.getChildNamed(FlightComplete_.sta).getValue()).getTime()), 0L);
            }
            this.transitDelivery.getElement().setNode(node.getChildNamed(FlightComplete_.transitDelivery));
            this.deliveryDate.getElement().setNode(deliveryDateNode);
            this.returnDate.getElement().setNode(node.getChildNamed(FlightComplete_.returnDate));
            this.gate.getElement().setNode(node.getChildNamed(FlightComplete_.defaultGate));
            this.shortCode.getElement().setNode(node.getChildNamed(FlightLight_.shortFlightCode));
            this.barSetNumber.getElement().setNode(node.getChildNamed(FlightLight_.sobBarSetNumber));
            this.fillEmptyEquipments.getElement().setNode(node.getChildNamed(FlightComplete_.fillEmptyEquipments));
            this.touchPCNumbers.getElement().setNode(node.getChildNamed(FlightComplete_.sobTouchPcIds));
            this.kitchenReadyTime.getElement().setNode(node.getChildNamed(FlightLight_.kitchenReadyTime));
        }
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        if (field.equals(this.sta.getElement().getEditor())) {
            FlightLight f = (FlightLight)this.editor.getModel().getNode().getValue(FlightLight.class);
            Node leg = null;
            Node legs = this.editor.getModel().getNode().getChildNamed(FlightComplete_.legs);
            if (f != null) {
                switch (f.getFlightType()) {
                    case RETURN: {
                        leg = legs.getChildAt(legs.getChildCount() - 1);
                        break;
                    }
                    case TRANSIT: {
                        leg = legs.getChildAt(0);
                    }
                }
            }
            if (leg != null) {
                Timestamp ct = (Timestamp)field.getNode().getValue();
                Node timeNode = leg.getChildNamed(FlightLegComplete_.flightTime);
                timeNode.setValue((Object)new Time(ct.getTime()), 0L);
            }
        } else if (field.equals(this.std.getElement().getEditor())) {
            FlightLight f = (FlightLight)this.editor.getModel().getNode().getValue(FlightLight.class);
            Node leg = null;
            Node leg2 = null;
            Node legs = this.editor.getModel().getNode().getChildNamed(FlightComplete_.legs);
            switch (f.getFlightType()) {
                case RETURN: {
                    leg = legs.getChildAt(0);
                    leg2 = this.editor.getModel().getNode().getChildNamed(FlightComplete_.staLeg);
                    break;
                }
                case TRANSIT: {
                    leg = legs.getChildAt(legs.getChildCount() - 1);
                    leg2 = this.editor.getModel().getNode().getChildNamed(FlightComplete_.stdLeg);
                }
            }
            if (leg != null) {
                Node timeNode2;
                Timestamp ct = (Timestamp)field.getNode().getValue();
                Node timeNode = leg.getChildNamed(FlightLegComplete_.flightTime);
                if (timeNode != null) {
                    timeNode.setValue((Object)new Time(ct.getTime()), 0L);
                }
                if ((timeNode2 = leg2.getChildNamed(FlightLegComplete_.flightTime)) != null) {
                    timeNode2.setValue((Object)new Time(ct.getTime()), 0L);
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.sta.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.std.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.kitchenReadyTime.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.transitDelivery.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.returnDate.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.gate.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.shortCode.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.barSetNumber.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.touchPCNumbers.getPreferredSize().getHeight());
            h += DelaysDetailsPanel.this.verticalBorder;
            h = (int)((double)h + DelaysDetailsPanel.this.fillEmptyEquipments.getPreferredSize().getHeight());
            return new Dimension((int)((double)DelaysDetailsPanel.this.horizontalBorder + DelaysDetailsPanel.this.sta.getPreferredSize().getWidth() + (double)DelaysDetailsPanel.this.horizontalBorder), h += DelaysDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean stdFirst = true;
            if (DelaysDetailsPanel.this.root != null) {
                FlightLight f = (FlightLight)DelaysDetailsPanel.this.root.getValue(FlightLight.class);
                stdFirst = f != null ? f.getFlightType() == FlightTypeE.RETURN : true;
            }
            int cy = 0;
            if (stdFirst) {
                DelaysDetailsPanel.this.std.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.verticalBorder);
                DelaysDetailsPanel.this.std.setSize((parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder - DelaysDetailsPanel.this.inner_horizontalBorder) / 2, ((DelaysDetailsPanel)DelaysDetailsPanel.this).std.getPreferredSize().height);
                DelaysDetailsPanel.this.sta.setLocation(DelaysDetailsPanel.this.std.getX() + DelaysDetailsPanel.this.std.getWidth() + DelaysDetailsPanel.this.inner_horizontalBorder, DelaysDetailsPanel.this.verticalBorder);
                DelaysDetailsPanel.this.sta.setSize((parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder - DelaysDetailsPanel.this.inner_horizontalBorder) / 2, ((DelaysDetailsPanel)DelaysDetailsPanel.this).sta.getPreferredSize().height);
                cy = DelaysDetailsPanel.this.sta.getY() + DelaysDetailsPanel.this.sta.getHeight();
            } else {
                DelaysDetailsPanel.this.sta.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.verticalBorder);
                DelaysDetailsPanel.this.sta.setSize((parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder - DelaysDetailsPanel.this.inner_horizontalBorder) / 2, ((DelaysDetailsPanel)DelaysDetailsPanel.this).sta.getPreferredSize().height);
                DelaysDetailsPanel.this.std.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.sta.getY() + DelaysDetailsPanel.this.sta.getHeight() + DelaysDetailsPanel.this.inner_verticalBorder);
                DelaysDetailsPanel.this.std.setSize((parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder - DelaysDetailsPanel.this.inner_horizontalBorder) / 2, ((DelaysDetailsPanel)DelaysDetailsPanel.this).std.getPreferredSize().height);
                cy = DelaysDetailsPanel.this.std.getY() + DelaysDetailsPanel.this.std.getHeight();
            }
            DelaysDetailsPanel.this.kitchenReadyTime.setLocation(DelaysDetailsPanel.this.horizontalBorder, cy + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.kitchenReadyTime.setSize(DelaysDetailsPanel.this.kitchenReadyTime.getPreferredSize());
            DelaysDetailsPanel.this.transitDelivery.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.kitchenReadyTime.getY() + DelaysDetailsPanel.this.kitchenReadyTime.getHeight() + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.transitDelivery.setSize(DelaysDetailsPanel.this.transitDelivery.getPreferredSize());
            cy = DelaysDetailsPanel.this.transitDelivery.getY() + DelaysDetailsPanel.this.transitDelivery.getHeight();
            DelaysDetailsPanel.this.deliveryDate.setLocation(DelaysDetailsPanel.this.horizontalBorder, cy + DelaysDetailsPanel.this.inner_verticalBorder);
            DelaysDetailsPanel.this.deliveryDate.setSize(DelaysDetailsPanel.this.deliveryDate.getPreferredSize());
            cy = DelaysDetailsPanel.this.deliveryDate.getY() + DelaysDetailsPanel.this.deliveryDate.getHeight();
            DelaysDetailsPanel.this.returnDate.setLocation(DelaysDetailsPanel.this.horizontalBorder, cy + DelaysDetailsPanel.this.inner_verticalBorder);
            DelaysDetailsPanel.this.returnDate.setSize(DelaysDetailsPanel.this.returnDate.getPreferredSize());
            cy = DelaysDetailsPanel.this.returnDate.getY() + DelaysDetailsPanel.this.returnDate.getHeight();
            DelaysDetailsPanel.this.gate.setLocation(DelaysDetailsPanel.this.horizontalBorder, cy + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.gate.setSize(parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder, (int)DelaysDetailsPanel.this.gate.getPreferredSize().getHeight());
            DelaysDetailsPanel.this.shortCode.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.gate.getY() + DelaysDetailsPanel.this.gate.getHeight() + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.shortCode.setSize(parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder, (int)DelaysDetailsPanel.this.shortCode.getPreferredSize().getHeight());
            DelaysDetailsPanel.this.barSetNumber.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.shortCode.getY() + DelaysDetailsPanel.this.shortCode.getHeight() + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.barSetNumber.setSize(parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder, (int)DelaysDetailsPanel.this.barSetNumber.getPreferredSize().getHeight());
            DelaysDetailsPanel.this.touchPCNumbers.setLocation(DelaysDetailsPanel.this.horizontalBorder, DelaysDetailsPanel.this.barSetNumber.getY() + DelaysDetailsPanel.this.barSetNumber.getHeight() + DelaysDetailsPanel.this.verticalBorder);
            DelaysDetailsPanel.this.touchPCNumbers.setSize(parent.getWidth() - 2 * DelaysDetailsPanel.this.horizontalBorder, (int)DelaysDetailsPanel.this.touchPCNumbers.getPreferredSize().getHeight());
            int currentY = DelaysDetailsPanel.this.touchPCNumbers.getY() + DelaysDetailsPanel.this.touchPCNumbers.getHeight() + DelaysDetailsPanel.this.verticalBorder;
            DelaysDetailsPanel.this.fillEmptyEquipments.setLocation(DelaysDetailsPanel.this.horizontalBorder, currentY);
            DelaysDetailsPanel.this.fillEmptyEquipments.setSize(DelaysDetailsPanel.this.fillEmptyEquipments.getPreferredSize());
        }
    }
}

