/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.MultiPaxTable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EditPaxDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private MultiPaxTable paxTable;
    private Node<FlightComplete> node;
    private final FlightEditableChecker checker = new FlightEditableChecker();

    public EditPaxDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PAX_COUNT);
        this.lafAttributeChanged("All attribues changed");
        this.setOpaque(false);
        this.paxTable = new MultiPaxTable(provider);
        this.paxTable.setSuperPanel(editor);
        this.paxTable.setFocusCycleCreator(editor);
        this.setCustomLayouter(new Layout());
        this.addToView(this.paxTable);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        List<ScreenValidationObject> tableValidationObjects = this.paxTable.isTableValid();
        if (tableValidationObjects != null) {
            validationObjects.addAll(tableValidationObjects);
        }
        if (this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(FlightLight_.legs) != null && this.editor.getModel().getNode().getChildNamed(FlightLight_.legs).getChildCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_FLIGHT_LEGS));
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        Node stowingNode;
        if (this.node != null) {
            this.node.getChildNamed(FlightLight_.activeStowingList).removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.paxTable.setNode(node);
        Node node2 = stowingNode = node != null ? node.getChildNamed(FlightLight_.activeStowingList) : null;
        if (stowingNode != null) {
            stowingNode.removeNodeListener((NodeListener)this);
            stowingNode.addNodeListener((NodeListener)this);
            this.updateMaxPax(stowingNode);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.node, this.provider, true);
        enabled = isEnabled && enabled;
        super.setEnabled(enabled);
        this.paxTable.setEnabled(enabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null && this.node.getChildNamed(FlightComplete_.activeStowingList) != null) {
            this.node.getChildNamed(FlightComplete_.activeStowingList).removeNodeListener((NodeListener)this);
        }
        if (this.paxTable != null) {
            this.paxTable.kill();
        }
        this.paxTable = null;
    }

    @Override
    public void setValid(boolean valid) {
        this.paxTable.setValid(valid);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.paxTable);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    public MultiPaxTable getPaxTable() {
        return this.paxTable;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.paxTable.addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void valueChanged(Node<?> node) {
        if (node != null && node.getValue() != null && node.getName().equals(FlightLight_.activeStowingList.getFieldName())) {
            this.updateMaxPax(node);
        }
    }

    private void updateMaxPax(Node<?> node) {
        if (node == null) {
            return;
        }
        Node childNamed = node.getChildNamed(StowingListLight_.seatConfigurations);
        if (childNamed == null) {
            return;
        }
        Iterator it = childNamed.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Node clazz = n.getChildNamed(SeatConfigurationComplete_.cabinClass);
            Node maxPax = n.getChildNamed(SeatConfigurationComplete_.number);
            if (clazz == null || maxPax == null || this.paxTable == null) continue;
            this.paxTable.setPaxMax((CabinClassComplete)clazz.getValue(), null, (Integer)maxPax.getValue());
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EditPaxDetailsPanel.this.paxTable.setLocation(0, 0);
            EditPaxDetailsPanel.this.paxTable.setSize(parent.getWidth(), parent.getHeight() - 1);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)EditPaxDetailsPanel.this.paxTable.getPreferredSize().getHeight() + 1;
            return new Dimension(300, h);
        }
    }
}

