/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.GalleyLoadConfigurationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete;
import ch.icit.pegasus.server.core.dtos.tracking.TruckTourComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class TrucksDetailsPanel
extends TableDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;
    private Node<FlightComplete> node;
    private FlightEditableChecker checker = new FlightEditableChecker();

    public TrucksDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, false);
        this.setTitleText(Words.DELIVERY);
        this.isDeletable = provider.isWritable(FlightComplete_.tours);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Truck", 40, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo("Driver", 40, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo("Galleys", 40, Integer.MAX_VALUE, 120));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.node, this.provider, isEnabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.table.getModel().setNode(node.getChildNamed(FlightComplete_.tours));
        super.setNode(node);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDSearchTextField2<UserLight> driverSearch;
        private RDSearchTextField2<TruckComplete> truckSearch;
        private TextLabel galleys;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.driverSearch = new RDSearchTextField2(TrucksDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.USER, true);
            this.truckSearch = new RDSearchTextField2(TrucksDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.TRUCK, false);
            this.driverSearch.setNode(m.getNode().getChildNamed(TruckTourComplete_.driver));
            this.truckSearch.setNode(m.getNode().getChildNamed(TruckTourComplete_.truck));
            this.galleys = new TextLabel(m.getNode().getChildNamed(TruckTourComplete_.loadingGroup), ConverterRegistry.getConverter(GalleyLoadConfigurationConverter.class));
            if (TrucksDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.driverSearch);
            this.add(this.truckSearch);
            this.add(this.galleys);
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        public boolean isInnerComponent(JComponent c) {
            if (this.driverSearch.isInnerComponent(c)) {
                return true;
            }
            return this.truckSearch.isInnerComponent(c);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            if (TrucksDetailsPanel.this.isDeletable) {
                CheckedListAdder.addToList(focusList, this.driverSearch);
                CheckedListAdder.addToList(focusList, this.truckSearch);
                CheckedListAdder.addToList(focusList, this.delete);
            }
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.driverSearch.setEnabled(isEnabled);
            this.truckSearch.setEnabled(isEnabled);
            this.galleys.setEnabled(isEnabled);
            if (TrucksDetailsPanel.this.isDeletable) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.driverSearch.kill();
            this.driverSearch = null;
            this.truckSearch.kill();
            this.truckSearch = null;
            this.galleys.kill();
            this.galleys = null;
            if (this.delete != null) {
                this.delete.kill();
                this.delete = null;
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.truckSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.truckSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.truckSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.truckSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.driverSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.driverSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.driverSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.driverSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.galleys.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.galleys.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.galleys.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.galleys.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

