/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details;

import ch.icit.pegasus.client.gui.hud.DTOProvider;
import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.StowingTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.MultiPaxTable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StowingListDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements DTOProvider,
NodeListener {
    private static final long serialVersionUID = 1L;
    private Node<?> node;
    private StowingTable table;
    private final boolean isFlight;
    private FlightEditableChecker checker;

    public StowingListDetailsPanel(RowEditor<T> editor, RDProvider provider, DtoField fieldName, boolean isFlight, FlightModuleDataHandler dataHandler, SpecialMenusDetailsPanel spmlDetails, AdditionalOrderDetailsPanel additionals, SealDefinitionDetailsPanel sealsPanel, MultiPaxTable paxTable) {
        super(editor, provider);
        this.isFlight = isFlight;
        if (isFlight) {
            this.checker = new FlightEditableChecker();
        }
        this.setTitleText(Words.STOWING_LISTS);
        this.setCustomLayouter(new Layout());
        this.table = new StowingTable(editor, fieldName, provider, isFlight, dataHandler, spmlDetails, additionals, sealsPanel, paxTable);
        this.table.getTable().setProvider(provider);
        this.addToView(this.table);
        this.table.fadeIn();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = true;
        if (this.node != null && !this.isFlight) {
            isDraft = this.node.getChildNamed(FlightScheduleComplete_.state).getValue() != ModificationStateE.ACCEPTED;
        }
        boolean b = isEnabled;
        if (this.isFlight) {
            b = this.checker.canEditFlight(this.node, this.provider, isEnabled);
        }
        b = isDraft && b;
        super.setEnabled(b);
        this.table.setEnabled(isEnabled);
        this.table.setEditable(b);
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.node != null && this.node.getChildNamed(FlightScheduleComplete_.customer) != null) {
            this.node.getChildNamed(FlightScheduleComplete_.customer).removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (this.node != null) {
            if (node.getChildNamed(FlightScheduleComplete_.state) != null && node.getChildNamed(FlightScheduleComplete_.state).getValue() == null) {
                node.getChildNamed(FlightScheduleComplete_.state).setValue((Object)ModificationStateE.DRAFT, 0L);
            }
            this.table.setNode(this.node);
            if (this.isFlight) {
                this.table.getTable().allInstalled();
            }
            if (node.getChildNamed(FlightScheduleComplete_.customer) != null && node.getChildNamed(FlightScheduleComplete_.customer).getValue() == null) {
                this.table.getTable().enableAddButton(false);
                node.getChildNamed(FlightScheduleComplete_.customer).addNodeListener((NodeListener)this);
            } else {
                this.table.getTable().enableAddButton(true);
            }
        } else {
            this.table.setNode(null);
        }
    }

    @Override
    public void resetParagraph() {
        if (this.table != null && this.table.getTable() != null && this.table.getTable().getModel() != null && this.node != null) {
            this.table.getTable().getModel().setNode(this.node.getChildNamed(FlightScheduleComplete_.stowingLists));
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> c;
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.isFlight) {
            FlightLight l;
            if (this.editor.getModel().getNode() != null && (l = (FlightLight)this.editor.getModel().getNode().getValue(FlightLight.class)) != null && l.getActiveStowingList() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DEFAULT_STW));
            }
        } else {
            boolean switchToAccepted = false;
            ModificationStateE newState = (ModificationStateE)this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.state).getValue();
            ModificationStateE oldState = ((FlightScheduleComplete)this.editor.getModel().getNode().getValue(FlightScheduleComplete.class)).getState();
            if (oldState == ModificationStateE.DRAFT && newState == ModificationStateE.ACCEPTED) {
                switchToAccepted = true;
            }
            if (this.editor.getModel().getNode() != null) {
                boolean accepted = ((FlightScheduleLight)this.editor.getModel().getNode().getValue()).getState() == ModificationStateE.ACCEPTED;
                Node l = this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.defaultStowingList);
                if (l.getValue() == null && switchToAccepted) {
                    o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DEFAULT_STW));
                }
                Node fsLegs = this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.legs);
                CustomerLight customer = (CustomerLight)this.editor.getModel().getNode().getChildNamed(FlightScheduleLight_.customer).getValue();
                Iterator it23 = this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.stowingLists).getChilds();
                HashSet<Object> doubleCheck = new HashSet<Object>();
                while (it23.hasNext()) {
                    List b;
                    Node nNode = (Node)it23.next();
                    Node cStw = nNode.getChildNamed(StowingListConfigurationComplete_.stowingList);
                    if (cStw.getValue() == null) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STOWING_LIST));
                        continue;
                    }
                    if (doubleCheck.contains(cStw.getValue())) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STW_IS_ADDED_ONLY_ONCE));
                    } else {
                        doubleCheck.add(cStw.getValue());
                    }
                    if (customer != null) {
                        StowingListTemplateComplete stowingListTemplateComplete = (StowingListTemplateComplete)nNode.getChildNamed(StowingListConfigurationComplete_.stowingList).getValue();
                    }
                    Node stwLegsNode = nNode.getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs});
                    Node mNode = nNode.getChildNamed(StowingListConfigurationComplete_.legMapping);
                    if (!switchToAccepted || (b = LegToolkit.validateLegsMapping((Node)stwLegsNode, (Node)fsLegs, (Node)mNode, (boolean)true, (String)Words.STW)) == null) continue;
                    o.addAll(b);
                }
            }
        }
        if ((c = this.table.validateTable()) != null && !c.isEmpty()) {
            o.addAll(c);
        }
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.customer) != null) {
            this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.customer).removeNodeListener((NodeListener)this);
        }
        this.table.kill();
        this.table = null;
    }

    @Override
    public boolean isInAddEditor() {
        return false;
    }

    public StowingTable getTable() {
        return this.table;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public Object getSelectedDTO() {
        return this.table.getRequestedDTO();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getTable().getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(FlightScheduleLight_.customer.getFieldName())) {
            if (node.getValue() != null) {
                this.table.getTable().enableAddButton(true);
            } else {
                this.table.getTable().enableAddButton(false);
            }
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StowingListDetailsPanel.this.table.setLocation(0, 0);
            StowingListDetailsPanel.this.table.setSize(parent.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)StowingListDetailsPanel.this.table.getPreferredSize().getHeight() + 2;
            return new Dimension(300, h);
        }
    }
}

