/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.HandlingCostVariantSorter;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.ArticleDeliverablePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.solar.SolarCompanySettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class HandlingCostModuleDataHandler
extends DefaultDataHandler<HandlingCostComplete, HandlingCostComplete> {
    public HandlingCostModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    public boolean reloadVariant(final Node<HandlingCostVariantReference> aNode, final RemoteLoader listener, final ProgressListener pListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HandlingCostModuleDataHandler.this.showMessage(pListener, Words.LOAD_DATA);
                Node newNode = aNode;
                HandlingCostVariantReference pr = (HandlingCostVariantReference)aNode.getValue(HandlingCostVariantReference.class);
                if (pr.getId() != null) {
                    HandlingCostVariantComplete pc = (HandlingCostVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariant(new HandlingCostVariantReference(pr.getId())).getValue();
                    aNode.removeExistingValues();
                    aNode.setValue((Object)pc, 0L);
                }
                return aNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HandlingCostComplete handling = (HandlingCostComplete)node.getValue(HandlingCostComplete.class);
                HandlingCostComplete nhandling = (HandlingCostComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCost(handling).getValue();
                node.removeExistingValues();
                node.setValue((Object)nhandling, 0L);
                node.updateNode();
                List l = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariants(new ListWrapper(nhandling.getVariants())).getList();
                HandlingCostVariantComplete pvc = (HandlingCostVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariant((HandlingCostVariantReference)handling.getCurrentVariant()).getValue();
                node.disableEvents();
                node.getChildNamed(new String[]{"currentVariant"}).disableEvents();
                node.getChildNamed(new String[]{"currentVariant"}).removeExistingValues();
                node.getChildNamed(new String[]{"currentVariant"}).removeChildsPermanent();
                node.getChildNamed(new String[]{"currentVariant"}).setValue((Object)pvc, 0L);
                node.getChildNamed(new String[]{"currentVariant"}).updateNode();
                node.getChildNamed(new String[]{"currentVariant"}).enableEvents();
                node.getChildNamed(new String[]{"variants"}).disableEvents();
                node.getChildNamed(new String[]{"variants"}).removeExistingValues();
                node.getChildNamed(new String[]{"variants"}).setValue((Object)l, 0L);
                node.getChildNamed(new String[]{"variants"}).updateNode();
                node.getChildNamed(new String[]{"variants"}).enableEvents();
                node.enableEvents();
                Node n = node;
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    private void validateHandlingCosts(HandlingCostComplete handling) {
        for (HandlingCostVariantReference v : handling.getVariants()) {
            HandlingCostArticleDeliverableComplete art;
            HandlingCostVariantComplete vc;
            if (!(v instanceof HandlingCostVariantComplete) || !((vc = (HandlingCostVariantComplete)v).getDeliverable() instanceof HandlingCostArticleDeliverableComplete) || (art = (HandlingCostArticleDeliverableComplete)vc.getDeliverable()).getId() != null) continue;
            for (ArticleDeliverablePriceCalculationComplete a : art.getArticles()) {
                if (a.getId() != null) {
                    a.setId(null);
                }
                if (a.getPriceCalculation() == null || a.getPriceCalculation().getId() == null) continue;
                a.getPriceCalculation().setId(null);
            }
        }
    }

    @Override
    public void updateData(final Node<HandlingCostComplete> node, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HandlingCostModuleDataHandler.this.showMessage(l, Words.SAVE_DATA);
                HandlingCostComplete dto = (HandlingCostComplete)node.getValue(HandlingCostComplete.class);
                Node newNode = node;
                ArrayList<HandlingCostVariantComplete> cl = new ArrayList<HandlingCostVariantComplete>();
                ArrayList<Object> allVariants = new ArrayList<Object>();
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Iterator it = node.getChildNamed(new String[]{"variants"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.getChildNamed(new String[]{"base"}).setValue((Object)dto, 0L);
                    if (n.getValue(HandlingCostVariantComplete.class) != null) {
                        HandlingCostVariantComplete vc = (HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        n.commitThis(HandlingCostVariantComplete.class);
                        HandlingCostVariantComplete c = (HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        c.setBase(dto);
                        cl.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    allVariants.add((HandlingCostVariantReference)n.getValue());
                }
                Hashtable<Class<HandlingCostVariantReference>, Class<HandlingCostVariantComplete>> t = new Hashtable<Class<HandlingCostVariantReference>, Class<HandlingCostVariantComplete>>();
                t.put(HandlingCostVariantReference.class, HandlingCostVariantComplete.class);
                node.commit(HandlingCostComplete.class, t);
                HandlingCostComplete l2 = dto = (HandlingCostComplete)node.getValue(HandlingCostComplete.class);
                l2.setVariants(allVariants);
                if (!cl.isEmpty()) {
                    dto.setCurrentVariant((HandlingCostVariantComplete)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                HandlingCostComplete h = (HandlingCostComplete)node.getValue(HandlingCostModuleDataHandler.this.getCommittingClass());
                HandlingCostModuleDataHandler.this.validateHandlingCosts(h);
                boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
                if (isSolarCompany) {
                    HandlingCostModuleDataHandler.this.ensureSolarCompanyData(h);
                }
                HandlingCostComplete nh = (HandlingCostComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateHandlingCost(h).getValue();
                node.getChildNamed(new String[]{"variants"}).removeAllChilds();
                node.removeExistingValues();
                node.setValue((Object)nh, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureSolarCompanyData(HandlingCostComplete handlingCost) {
        SolarCompanySettingsComplete value = (SolarCompanySettingsComplete)NodeToolkit.getAffixClass(SolarCompanySettingsComplete.class).getValue();
        handlingCost.setCustomer(value.getSolarCustomer());
        for (HandlingCostVariantReference variant : handlingCost.getVariants()) {
            if (!(variant instanceof HandlingCostVariantComplete)) continue;
            this.ensureSolarCompanyVariantData((HandlingCostVariantComplete)variant);
        }
    }

    private void ensureSolarCompanyVariantData(HandlingCostVariantComplete variant) {
        variant.setType(HandlingCostTypeE.FLIGHT);
        variant.setExcludeFromCanBeUseFromOtherCustomers(Boolean.valueOf(false));
        if (!(variant.getQuantity() instanceof AbsolutePriceCalculationComplete)) {
            AbsolutePriceCalculationComplete quantity = new AbsolutePriceCalculationComplete();
            quantity.setClientOId(Long.valueOf(ADTO.getNextId()));
            variant.setQuantity((PriceCalculationComplete)quantity);
        }
    }

    @Override
    public void createNewData(final Node<HandlingCostComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HandlingCostComplete nh;
                boolean isSolarCompany;
                HandlingCostComplete h = (HandlingCostComplete)node.getValue(HandlingCostComplete.class);
                HandlingCostModuleDataHandler.this.validateHandlingCosts(h);
                Node nn = node;
                ArrayList<HandlingCostVariantComplete> cl = new ArrayList<HandlingCostVariantComplete>();
                Iterator it = node.getChildNamed(new String[]{"variants"}).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(HandlingCostVariantComplete.class) == null) continue;
                    HandlingCostVariantComplete c = (HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class);
                    if (c.getState() == null) {
                        c.setState(ModificationStateE.DRAFT);
                    }
                    c.setBase(h);
                    cl.add(c);
                }
                node.commit(HandlingCostComplete.class);
                PeriodComplete pTime = h.getPeriod();
                HandlingCostModuleDataHandler.this.ensurePeriodMatching(pTime, cl, true);
                if (!cl.isEmpty()) {
                    h.setCurrentVariant((HandlingCostVariantComplete)cl.get(0));
                } else {
                    h.setCurrentVariant(null);
                }
                h.getVariants().clear();
                h.getVariants().addAll(cl);
                if (h.getEligibleLocations().isEmpty()) {
                    h.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                if (isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType())) {
                    HandlingCostModuleDataHandler.this.ensureSolarCompanyData(h);
                }
                if ((nh = (HandlingCostComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createHandlingCost(h).getValue()) != null) {
                    node.getChildNamed(new String[]{"variants"}).removeAllChilds();
                    node.removeExistingValues();
                    node.setValue((Object)nh, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensurePeriodMatching(PeriodComplete pTime, List<HandlingCostVariantComplete> cl, boolean b) {
        ArrayList<HandlingCostVariantComplete> l = new ArrayList<HandlingCostVariantComplete>();
        l.addAll(cl);
        Collections.sort(l, ComparatorRegistry.getComparator(HandlingCostVariantSorter.class));
        long d = pTime.getEndDate().getTime() - pTime.getStartDate().getTime();
        if (l.size() > 0) {
            d /= (long)l.size();
        }
        long latestTS = -1L;
        for (int i = 0; i < l.size(); ++i) {
            HandlingCostVariantComplete f = (HandlingCostVariantComplete)l.get(i);
            long dd = pTime.getStartDate().getTime() + (long)i * d;
            if (latestTS != -1L) {
                f.getValidityPeriod().setStartDate(new Date(latestTS));
            } else {
                f.getValidityPeriod().setStartDate(new Date(dd));
            }
            if (i == l.size() - 1) {
                f.getValidityPeriod().setEndDate(pTime.getEndDate());
            } else {
                dd = pTime.getStartDate().getTime() + (long)(i + 1) * d;
                f.getValidityPeriod().setEndDate(new Date(--dd));
            }
            latestTS = f.getValidityPeriod().getEndDate().getTime() + 1L;
        }
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HandlingCostModuleDataHandler.this.setCurrentLoadMaximum(11);
                boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
                if (isSolarCompany) {
                    SolarCompanySettingsComplete value = (SolarCompanySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSolarCompanySettings().getValue();
                    Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                    node4DTO.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(value.getClass()));
                    NodeToolkit.addAffix((Node)node4DTO);
                }
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllHandlingCostTypes();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllQuantityTypes();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                HandlingCostModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(DiscountTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return HandlingCostModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<HandlingCostComplete> resetData(Node<HandlingCostComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<HandlingCostComplete> createEmptyNode() {
        HandlingCostComplete dto = new HandlingCostComplete();
        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        HandlingCostVariantComplete variant = new HandlingCostVariantComplete();
        variant.setClientOId(Long.valueOf(ADTO.getNextId()));
        variant.setValidityPeriod(new PeriodComplete());
        dto.setCurrentVariant(variant);
        dto.getVariants().add(variant);
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(CalendarUtil.getDefaultStartDate((boolean)true));
        p.setEndDate(CalendarUtil.getInfinityDate());
        dto.setPeriod(p);
        variant.setState(ModificationStateE.DRAFT);
        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (isSolarCompany) {
            this.ensureSolarCompanyData(dto);
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, false, false);
        return n;
    }

    @Override
    public Class<HandlingCostComplete> getCommittingClass() {
        return HandlingCostComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<HandlingCostComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

